/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.pi;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Request;
import com.ibm.CORBA.iiop.Response;
import com.ibm.CORBA.iiop.ServiceContext;
import com.ibm.rmi.iiop.ServiceContextList;
import com.ibm.rmi.pi.LocalRequest;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.PortableInterceptor.ForwardRequest;

public class LocalResponse
implements Response {
    private ORB orb;
    private Request request;
    private ServiceContextList serviceContexts;
    private Exception exception;
    private IOR forwardIOR;

    public LocalResponse(ORB oRB, LocalRequest localRequest, Throwable throwable) {
        this.orb = oRB;
        this.request = localRequest;
        this.serviceContexts = new ServiceContextList();
        this.setException(throwable);
    }

    public void setException(Throwable throwable) {
        if (throwable != null) {
            if (throwable instanceof ForwardRequest) {
                this.forwardIOR = this.orb.objectToIOR(((ForwardRequest)throwable).forward);
            } else {
                this.exception = throwable instanceof SystemException || throwable instanceof UserException ? (Exception)throwable : new UNKNOWN("Unexpected exception found, can't be stored as a CORBA exception: " + throwable.getMessage(), 1229127334, CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    @Override
    public int getRequestId() {
        return this.request.getRequestId();
    }

    @Override
    public ServiceContext[] getServiceContextList() {
        return this.serviceContexts.get();
    }

    @Override
    public ServiceContext getServiceContext(int n) {
        return this.serviceContexts.getServiceContext(n);
    }

    public void setServiceContextList(ServiceContext[] serviceContextArray) {
        this.serviceContexts.set(serviceContextArray);
    }

    @Override
    public boolean setServiceContext(ServiceContext serviceContext, boolean bl) {
        return this.serviceContexts.add(serviceContext, bl);
    }

    @Override
    public byte getGIOPMajor() {
        return 1;
    }

    @Override
    public byte getGIOPMinor() {
        return 2;
    }

    @Override
    public boolean isSystemException() {
        return this.exception instanceof SystemException;
    }

    @Override
    public boolean isUserException() {
        return this.exception instanceof UserException;
    }

    @Override
    public boolean isLocationForward() {
        return this.forwardIOR != null;
    }

    @Override
    public IOR getForwardedIOR() {
        return this.forwardIOR;
    }

    @Override
    public SystemException getSystemException() {
        return (SystemException)((Object)this.exception);
    }

    @Override
    public Exception getUserException() {
        return this.exception;
    }
}

