/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.rmi.iiop.ObjectPool;
import com.ibm.rmi.io.ValueHandlerImpl;
import java.io.Serializable;
import java.util.Hashtable;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.SendingContext.RunTime;

public class ValueHandlerPool
extends ObjectPool {
    private static ValueHandlerSingleton valueHandlerSingleton = null;
    private static ValueHandlerPool valueHandlerPool = new ValueHandlerPool(50);

    private ValueHandlerPool(int n) {
        super("ValueHandlerPool", n);
    }

    @Override
    public Object createObject() {
        return new ValueHandlerImpl();
    }

    public static synchronized ValueHandler createValueHandler() {
        if (valueHandlerSingleton == null) {
            valueHandlerSingleton = new ValueHandlerSingleton();
            if (valueHandlerPool == null) {
                valueHandlerPool = new ValueHandlerPool(50);
            }
        }
        return valueHandlerSingleton;
    }

    public static ValueHandlerImpl getValueHandler() {
        return (ValueHandlerImpl)valueHandlerPool.getObject();
    }

    public static void returnValueHandler(ValueHandlerImpl valueHandlerImpl) {
        valueHandlerImpl.reset();
        if (valueHandlerPool != null) {
            valueHandlerPool.releaseObject(valueHandlerImpl);
        }
    }

    private static final class ValueHandlerSingleton
    implements ValueHandler {
        private Hashtable valueHandlerTable = null;

        private ValueHandlerSingleton() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getRMIRepositoryID(Class clazz) {
            ValueHandlerImpl valueHandlerImpl = null;
            String string = null;
            try {
                valueHandlerImpl = ValueHandlerPool.getValueHandler();
                string = valueHandlerImpl.getRMIRepositoryID(clazz);
            }
            finally {
                ValueHandlerPool.returnValueHandler(valueHandlerImpl);
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Serializable readValue(InputStream inputStream, int n, Class clazz, String string, RunTime runTime) {
            ValueHandlerImpl valueHandlerImpl = null;
            Serializable serializable = null;
            boolean bl = false;
            if (this.valueHandlerTable == null) {
                this.valueHandlerTable = new Hashtable();
            }
            if ((valueHandlerImpl = (ValueHandlerImpl)this.valueHandlerTable.get(inputStream)) == null) {
                valueHandlerImpl = ValueHandlerPool.getValueHandler();
                this.valueHandlerTable.put(inputStream, valueHandlerImpl);
                bl = true;
            }
            try {
                serializable = valueHandlerImpl.readValue(inputStream, n, clazz, string, runTime);
            }
            finally {
                if (bl) {
                    this.valueHandlerTable.remove(inputStream);
                    ValueHandlerPool.returnValueHandler(valueHandlerImpl);
                }
            }
            return serializable;
        }

        public void writeValue(OutputStream outputStream, Serializable serializable) {
            this.writeValue(outputStream, serializable, (byte)1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeValue(OutputStream outputStream, Serializable serializable, byte by) {
            ValueHandlerImpl valueHandlerImpl = null;
            Object var5_5 = null;
            boolean bl = false;
            if (this.valueHandlerTable == null) {
                this.valueHandlerTable = new Hashtable();
            }
            if ((valueHandlerImpl = (ValueHandlerImpl)this.valueHandlerTable.get(outputStream)) == null) {
                valueHandlerImpl = ValueHandlerPool.getValueHandler();
                this.valueHandlerTable.put(outputStream, valueHandlerImpl);
                bl = true;
            }
            try {
                valueHandlerImpl.writeValue(outputStream, serializable, by);
            }
            finally {
                if (bl) {
                    this.valueHandlerTable.remove(outputStream);
                    ValueHandlerPool.returnValueHandler(valueHandlerImpl);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCustomMarshaled(Class clazz) {
            boolean bl;
            ValueHandlerImpl valueHandlerImpl = null;
            try {
                valueHandlerImpl = ValueHandlerPool.getValueHandler();
                bl = valueHandlerImpl.isCustomMarshaled(clazz);
            }
            finally {
                ValueHandlerPool.returnValueHandler(valueHandlerImpl);
            }
            return bl;
        }

        public RunTime getRunTimeCodeBase() {
            RunTime runTime;
            ValueHandlerImpl valueHandlerImpl = null;
            try {
                valueHandlerImpl = ValueHandlerPool.getValueHandler();
                runTime = valueHandlerImpl.getRunTimeCodeBase();
            }
            finally {
                ValueHandlerPool.returnValueHandler(valueHandlerImpl);
            }
            return runTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Serializable writeReplace(Serializable serializable) {
            Serializable serializable2;
            ValueHandlerImpl valueHandlerImpl = null;
            try {
                valueHandlerImpl = ValueHandlerPool.getValueHandler();
                serializable2 = valueHandlerImpl.writeReplace(serializable);
            }
            finally {
                ValueHandlerPool.returnValueHandler(valueHandlerImpl);
            }
            return serializable2;
        }

        public byte getMaximumStreamFormatVersion() {
            byte by;
            ValueHandlerImpl valueHandlerImpl = null;
            try {
                valueHandlerImpl = ValueHandlerPool.getValueHandler();
                by = valueHandlerImpl.getMaximumStreamFormatVersion();
            }
            finally {
                ValueHandlerPool.returnValueHandler(valueHandlerImpl);
            }
            return by;
        }
    }
}

