/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CodeSetMapping {
    private static boolean tablesLoaded = false;
    private static Map osfToJava = null;
    private static Map javaToOsf = null;

    public static int mapFromJavaEncoding(String string) {
        Integer n;
        block7: {
            String string2;
            String string3;
            Set set;
            if (string.equals("ISO8859_1")) {
                return 65537;
            }
            if (string.equals("Cp1047")) {
                return 268567575;
            }
            if (string.equals("UCS2")) {
                return 65792;
            }
            if (string.equals("UTF8")) {
                return 0x5010001;
            }
            if (string.equals("UTF16")) {
                return 65801;
            }
            if (!tablesLoaded) {
                CodeSetMapping.loadTables();
            }
            if ((n = (Integer)javaToOsf.get(string)) != null || (set = (Set)AccessController.doPrivileged(new PrivilegedAction(string3 = string){
                final /* synthetic */ String val$callerEnc;
                {
                    this.val$callerEnc = string;
                }

                public Object run() {
                    try {
                        return Charset.forName(this.val$callerEnc).aliases();
                    }
                    catch (Exception exception) {
                        return Collections.EMPTY_SET;
                    }
                }
            })).isEmpty()) break block7;
            Iterator iterator = set.iterator();
            while (iterator.hasNext() && (n = (Integer)javaToOsf.get(string2 = (String)iterator.next())) == null) {
            }
        }
        return n != null ? n : 0;
    }

    public static String mapToJavaEncoding(int n) {
        switch (n) {
            case 65537: {
                return "ISO8859_1";
            }
            case 268567575: {
                return "Cp1047";
            }
            case 65792: {
                return "UCS2";
            }
            case 0x5010001: {
                return "UTF8";
            }
            case 65801: {
                return "UTF16";
            }
        }
        if (!tablesLoaded) {
            CodeSetMapping.loadTables();
        }
        String string = (String)osfToJava.get(n);
        return string;
    }

    private static synchronized void loadTables() {
        if (!tablesLoaded) {
            osfToJava = new HashMap();
            javaToOsf = new HashMap();
            CodeSetMapping.loadEntry("ASCII", 65568, false);
            CodeSetMapping.loadEntry("ISO8859_1", 65537, false);
            CodeSetMapping.loadEntry("ISO8859_2", 65538, false);
            CodeSetMapping.loadEntry("ISO8859_3", 65539, false);
            CodeSetMapping.loadEntry("ISO8859_4", 65540, false);
            CodeSetMapping.loadEntry("ISO8859_5", 65541, false);
            CodeSetMapping.loadEntry("ISO8859_6", 65542, false);
            CodeSetMapping.loadEntry("ISO8859_7", 65543, false);
            CodeSetMapping.loadEntry("ISO8859_8", 65544, false);
            CodeSetMapping.loadEntry("ISO8859_9", 65545, false);
            CodeSetMapping.loadEntry("ISO8859_15_FDIS", 65551, false);
            CodeSetMapping.loadEntry("Cp1250", 268567778, false);
            CodeSetMapping.loadEntry("Cp1251", 268567779, false);
            CodeSetMapping.loadEntry("Cp1252", 268567780, false);
            CodeSetMapping.loadEntry("Cp1253", 268567781, false);
            CodeSetMapping.loadEntry("Cp1254", 268567782, false);
            CodeSetMapping.loadEntry("Cp1255", 268567783, false);
            CodeSetMapping.loadEntry("Cp1256", 268567784, false);
            CodeSetMapping.loadEntry("Cp1257", 268567785, false);
            CodeSetMapping.loadEntry("Cp943C", 268567471, false);
            CodeSetMapping.loadEntry("Cp943", 268567471, true);
            CodeSetMapping.loadEntry("Cp949C", 268567477, false);
            CodeSetMapping.loadEntry("Cp949", 268567477, true);
            CodeSetMapping.loadEntry("Cp1363C", 268567891, false);
            CodeSetMapping.loadEntry("Cp1363", 268567891, true);
            CodeSetMapping.loadEntry("Cp950", 268567478, false);
            CodeSetMapping.loadEntry("Cp1381", 268567909, false);
            CodeSetMapping.loadEntry("Cp1386", 268567914, false);
            CodeSetMapping.loadEntry("EUC_JP", 196624, false);
            CodeSetMapping.loadEntry("EUC_KR", 262154, false);
            CodeSetMapping.loadEntry("EUC_TW", 327696, false);
            CodeSetMapping.loadEntry("Cp964", 268567492, false);
            CodeSetMapping.loadEntry("Cp970", 268567498, false);
            CodeSetMapping.loadEntry("Cp1383", 268567911, false);
            CodeSetMapping.loadEntry("Cp33722C", 268600250, false);
            CodeSetMapping.loadEntry("Cp33722", 268600250, true);
            CodeSetMapping.loadEntry("Cp930", 268567458, false);
            CodeSetMapping.loadEntry("Cp1047", 268567575, false);
            CodeSetMapping.loadEntry("UCS2", 65792, false);
            CodeSetMapping.loadEntry("UTF8", 0x5010001, false);
            CodeSetMapping.loadEntry("UTF16", 65801, false);
            tablesLoaded = true;
        }
    }

    private static void loadEntry(String string, int n, boolean bl) {
        Integer n2 = n;
        javaToOsf.put(string, n2);
        if (!bl) {
            osfToJava.put(n2, string);
        }
    }
}

