/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba.DynamicAny;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.corba.DynamicAny.BasicDynAnyImpl;
import com.ibm.rmi.corba.DynamicAny.DynAnyImpl;
import com.ibm.rmi.corba.DynamicAny.DynArrayImpl;
import com.ibm.rmi.corba.DynamicAny.DynEnumImpl;
import com.ibm.rmi.corba.DynamicAny.DynFixedImpl;
import com.ibm.rmi.corba.DynamicAny.DynSequenceImpl;
import com.ibm.rmi.corba.DynamicAny.DynStructImpl;
import com.ibm.rmi.corba.DynamicAny.DynUnionImpl;
import com.ibm.rmi.corba.DynamicAny.DynValueBoxImpl;
import com.ibm.rmi.corba.DynamicAny.DynValueImpl;
import com.ibm.rmi.corba.TypeCodeImpl;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UserException;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;

public class DynAnyFactoryImpl
extends LocalObject
implements DynAnyFactory {
    private static final String CLASS = DynAnyFactoryImpl.class.getName();
    private ORB _orb;
    private static final int[] BADTCKINDS = new int[]{32, 13, 31, 25};

    public DynAnyFactoryImpl(ORB oRB) {
        this._orb = oRB;
    }

    public DynAny create_dyn_any(Any any) throws InconsistentTypeCode {
        if (any != null) {
            if (!this.isPermittedTCKind(any.type())) {
                String string = "Any's typecode kind (" + any.type() + ") is unsupported by this DynAnyFactory.";
                if (Trc.enabled()) {
                    Trc.warn(string, CLASS, "create_dyn_any:106");
                }
                throw new InconsistentTypeCode(string);
            }
            DynAny dynAny = null;
            try {
                dynAny = this.create_dyn_any_from_type_code(any.type());
                dynAny.from_any(any);
                return dynAny;
            }
            catch (InvalidValue invalidValue) {
                if (Trc.enabled()) {
                    Trc.warn("Any does not contain an object", CLASS, "create_dyn_any:123");
                }
                return dynAny;
            }
            catch (UserException userException) {
                Trc.ffdc(userException, CLASS, "create_dyn_any:129");
                throw new InconsistentTypeCode(userException.getMessage());
            }
        }
        if (Trc.enabled()) {
            Trc.warn("method called with null Any parameter.", CLASS, "create_dyn_any:136");
        }
        throw new BAD_PARAM("NULL_PARAM create_dyn_any()", 1229124116, CompletionStatus.COMPLETED_NO);
    }

    public DynAny create_dyn_any_from_type_code(TypeCode typeCode) throws InconsistentTypeCode {
        if (typeCode != null) {
            if (!this.isPermittedTCKind(typeCode)) {
                throw new InconsistentTypeCode("TypeCode is not permitted");
            }
            return DynAnyFactoryImpl.createDynAnyFromTypeCode(this._orb, typeCode, null);
        }
        throw new BAD_PARAM("NULL_PARAM create_dyn_any_from_type_code()", 1229124116, CompletionStatus.COMPLETED_NO);
    }

    static DynAny createDynAnyFromTypeCode(ORB oRB, TypeCode typeCode, DynAny dynAny) {
        DynAnyImpl dynAnyImpl = null;
        TypeCode typeCode2 = null;
        if (typeCode != null && oRB != null) {
            typeCode2 = DynAnyFactoryImpl.getRealTypeCode(typeCode);
            TypeCodeImpl typeCodeImpl = new TypeCodeImpl(oRB, typeCode);
            switch (typeCode2.kind().value()) {
                case 20: {
                    dynAnyImpl = new DynArrayImpl(oRB, typeCodeImpl);
                    break;
                }
                case 17: {
                    dynAnyImpl = new DynEnumImpl(oRB, typeCodeImpl);
                    break;
                }
                case 15: 
                case 22: {
                    dynAnyImpl = new DynStructImpl(oRB, typeCodeImpl);
                    break;
                }
                case 28: {
                    dynAnyImpl = new DynFixedImpl(oRB, typeCodeImpl);
                    break;
                }
                case 19: {
                    dynAnyImpl = new DynSequenceImpl(oRB, typeCodeImpl);
                    break;
                }
                case 16: {
                    dynAnyImpl = new DynUnionImpl(oRB, typeCodeImpl);
                    break;
                }
                case 29: {
                    dynAnyImpl = new DynValueImpl(oRB, typeCodeImpl);
                    break;
                }
                case 30: {
                    dynAnyImpl = new DynValueBoxImpl(oRB, typeCodeImpl);
                    break;
                }
                default: {
                    dynAnyImpl = new BasicDynAnyImpl(oRB, typeCodeImpl);
                }
            }
            if (dynAny != null) {
                ((DynAnyImpl)dynAnyImpl)._parent = dynAny;
            }
        }
        return dynAnyImpl;
    }

    static DynAny createDynAnyFromDynAny(ORB oRB, DynAny dynAny, DynAny dynAny2) {
        DynAnyImpl dynAnyImpl = null;
        TypeCode typeCode = null;
        if (dynAny != null && oRB != null) {
            try {
                typeCode = DynAnyFactoryImpl.getRealTypeCode(dynAny.type());
                TypeCodeImpl typeCodeImpl = new TypeCodeImpl(oRB, dynAny.type());
                switch (typeCode.kind().value()) {
                    case 20: {
                        dynAnyImpl = new DynArrayImpl(oRB, typeCodeImpl, (DynArrayImpl)dynAny);
                        break;
                    }
                    case 17: {
                        dynAnyImpl = new DynEnumImpl(oRB, typeCodeImpl, (DynEnumImpl)dynAny);
                        break;
                    }
                    case 15: 
                    case 22: {
                        dynAnyImpl = new DynStructImpl(oRB, typeCodeImpl, (DynStructImpl)dynAny);
                        break;
                    }
                    case 28: {
                        dynAnyImpl = new DynFixedImpl(oRB, typeCodeImpl, (DynFixedImpl)dynAny);
                        break;
                    }
                    case 19: {
                        dynAnyImpl = new DynSequenceImpl(oRB, typeCodeImpl, (DynSequenceImpl)dynAny);
                        break;
                    }
                    case 16: {
                        dynAnyImpl = new DynUnionImpl(oRB, typeCodeImpl, (DynUnionImpl)dynAny);
                        break;
                    }
                    case 29: {
                        dynAnyImpl = new DynValueImpl(oRB, typeCodeImpl, (DynValueImpl)dynAny);
                        break;
                    }
                    case 30: {
                        dynAnyImpl = new DynValueBoxImpl(oRB, typeCodeImpl, (DynValueBoxImpl)dynAny);
                        break;
                    }
                    default: {
                        dynAnyImpl = new BasicDynAnyImpl(oRB, typeCodeImpl, dynAny);
                    }
                }
                if (dynAny2 != null) {
                    ((DynAnyImpl)dynAnyImpl)._parent = dynAny2;
                }
            }
            catch (TypeMismatch typeMismatch) {}
        } else {
            throw new BAD_PARAM("NULL_PARAM passed to DynAnyFactoryImpl.createDynAnyFromDynAny", 1229124116, CompletionStatus.COMPLETED_NO);
        }
        return dynAnyImpl;
    }

    static DynAny createDynAnyFromAny(ORB oRB, Any any, DynAny dynAny) throws TypeMismatch, InvalidValue {
        DynAny dynAny2 = null;
        if (any != null && oRB != null) {
            dynAny2 = DynAnyFactoryImpl.createDynAnyFromTypeCode(oRB, any.type(), dynAny);
            dynAny2.from_any(any);
        }
        return dynAny2;
    }

    private boolean isPermittedTCKind(TypeCode typeCode) {
        boolean bl = true;
        if (typeCode != null) {
            int n = typeCode.kind().value();
            for (int i = 0; i < BADTCKINDS.length; ++i) {
                if (n != BADTCKINDS[i]) continue;
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    static TypeCode getRealTypeCode(TypeCode typeCode) {
        TypeCode typeCode2 = typeCode;
        try {
            while (typeCode2.kind().value() == 21) {
                typeCode2 = typeCode2.content_type();
            }
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        return typeCode2;
    }
}

