/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.ECNamedCurve;
import com.ibm.crypto.fips.provider.ECUtils;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.IBMJCEFIPS;
import com.ibm.crypto.fips.provider.PrimeCurve;
import com.ibm.crypto.fips.provider.PrimeField;
import com.ibm.crypto.fips.provider.SelfTest;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import java.util.Map;
import java.util.Set;

public final class ECParameters
extends AlgorithmParametersSpi {
    protected int a;
    protected EllipticCurve b;
    protected ECPoint c;
    protected BigInteger d;
    private static final String[] z;

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        if (SelfTest.isFipsRunnable()) {
            return this.a();
        }
        throw new FIPSRuntimeException();
    }

    protected byte[] a() throws IOException {
        byte[] byArray = this.encodeECParameters();
        return byArray;
    }

    @Override
    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> clazz) throws InvalidParameterSpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(clazz);
        }
        throw new FIPSRuntimeException();
    }

    protected <T extends AlgorithmParameterSpec> T a(Class<T> clazz) throws InvalidParameterSpecException {
        try {
            Class<T> clazz2 = Class.forName(z[23]);
            if (clazz2.isAssignableFrom(clazz)) {
                return (T)((AlgorithmParameterSpec)clazz.cast(new ECParameterSpec(this.b, this.c, this.d, this.a)));
            }
            throw new InvalidParameterSpecException(z[22]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException(z[21] + classNotFoundException.getMessage());
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        block3: {
            block2: {
                if (!SelfTest.isFipsRunnable()) break block2;
                this.a(algorithmParameterSpec);
                break block3;
            }
            throw new FIPSRuntimeException();
        }
    }

    protected void a(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        ECParameterSpec eCParameterSpec;
        block9: {
            if (algorithmParameterSpec == null) {
                throw new InvalidParameterSpecException(z[4]);
            }
            if (algorithmParameterSpec instanceof ECParameterSpec) {
                eCParameterSpec = (ECParameterSpec)algorithmParameterSpec;
            } else {
                if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                    String string = ((ECGenParameterSpec)algorithmParameterSpec).getName();
                    eCParameterSpec = ECNamedCurve.getECParameterSpec(string);
                    if (eCParameterSpec == null) {
                        throw new InvalidParameterSpecException(z[2] + string);
                    }
                    break block9;
                }
                throw new InvalidParameterSpecException(z[3]);
            }
        }
        eCParameterSpec = ECUtils.getPrimeParameterSpec(eCParameterSpec);
        this.b = eCParameterSpec.getCurve();
        this.c = eCParameterSpec.getGenerator();
        this.d = eCParameterSpec.getOrder();
        this.a = eCParameterSpec.getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray) throws IOException {
        block3: {
            block2: {
                if (!SelfTest.isFipsRunnable()) break block2;
                this.a(byArray);
                break block3;
            }
            throw new FIPSRuntimeException();
        }
    }

    protected void a(byte[] byArray) throws IOException {
        ECParameterSpec eCParameterSpec = ECParameters.decodeECParameters(byArray);
        eCParameterSpec = ECUtils.getPrimeParameterSpec(eCParameterSpec);
        this.b = eCParameterSpec.getCurve();
        this.c = eCParameterSpec.getGenerator();
        this.d = eCParameterSpec.getOrder();
        this.a = eCParameterSpec.getCofactor();
    }

    @Override
    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected String engineToString() {
        if (SelfTest.isFipsRunnable()) {
            return this.b();
        }
        throw new FIPSRuntimeException();
    }

    protected String b() {
        return z[11] + this.b.getA() + z[13] + this.b.getB() + z[12] + this.b.getField().getFieldSize() + z[14] + ECUtils.a(this.c) + z[15] + this.d.toString() + z[16] + this.a + "\n";
    }

    protected static AlgorithmParameters a(ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(z[0], IBMJCEFIPS.getInstance());
            algorithmParameters.init(eCParameterSpec);
            return algorithmParameters;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidParameterSpecException(z[1] + generalSecurityException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encodePoint(ECPoint eCPoint, EllipticCurve ellipticCurve) {
        int n3 = ellipticCurve.getField().getFieldSize();
        int n2 = n3 + 7 >> 3;
        byte[] byArray2 = ECParameters.b(eCPoint.getAffineX().toByteArray());
        byte[] byArray = ECParameters.b(eCPoint.getAffineY().toByteArray());
        if (byArray2.length <= n2 && byArray.length <= n2) {
            byte[] byArray3 = new byte[1 + (n2 << 1)];
            byArray3[0] = 4;
            System.arraycopy(byArray2, 0, byArray3, n2 - byArray2.length + 1, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
            return byArray3;
        }
        throw new RuntimeException(z[19]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ECPoint decodePoint(byte[] byArray, EllipticCurve ellipticCurve) throws IOException {
        if (byArray.length == 0 || byArray[0] != 4) {
            throw new IOException(z[18]);
        }
        int n2 = ellipticCurve.getField().getFieldSize() + 7 >> 3;
        if (byArray.length != n2 * 2 + 1) {
            throw new IOException(z[17]);
        }
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 1, byArray2, 0, n2);
        System.arraycopy(byArray, n2 + 1, byArray3, 0, n2);
        return new ECPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static byte[] b(byte[] byArray) {
        int n2;
        for (n2 = 0; n2 < byArray.length - 1 && byArray[n2] == 0; ++n2) {
        }
        if (n2 == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static DerValue encodeEllipticCurve(EllipticCurve ellipticCurve) throws IOException {
        try {
            byte[] byArray = ECParameters.b(ellipticCurve.getA().toByteArray());
            byte[] byArray2 = ECParameters.b(ellipticCurve.getB().toByteArray());
            byte[] byArray3 = ellipticCurve.getSeed();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOctetString(byArray);
            derOutputStream.putOctetString(byArray2);
            if (byArray3 != null) {
                derOutputStream.putBitString(byArray3);
            }
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(z[10] + iOException);
        }
    }

    public static EllipticCurve decodeEllipticCurve(DerValue derValue, ECField eCField) throws IOException {
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(z[26]);
            }
            DerInputStream derInputStream = derValue.getData();
            byte[] byArray = derInputStream.getOctetString();
            BigInteger bigInteger = new BigInteger(1, byArray);
            byte[] byArray2 = derInputStream.getOctetString();
            BigInteger bigInteger2 = new BigInteger(1, byArray2);
            byte[] byArray3 = null;
            if (derInputStream.available() != 0) {
                byArray3 = derInputStream.getBitString();
            }
            PrimeCurve primeCurve = null;
            int n2 = 0;
            if (ECUtils.isNistPrime(((ECFieldFp)eCField).getP())) {
                n2 = 1;
            }
            primeCurve = byArray3 == null ? ECUtils.getCurve((PrimeField)eCField, bigInteger, bigInteger2, n2) : ECUtils.getCurve((PrimeField)eCField, bigInteger, bigInteger2, byArray3, n2);
            return primeCurve;
        }
        catch (IOException iOException) {
            throw new IOException(z[27] + iOException);
        }
    }

    public static DerValue encodePrimeFieldType(ECFieldFp eCFieldFp) throws IOException {
        try {
            int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
            BigInteger bigInteger = eCFieldFp.getP();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID(objectIdentifier);
            derOutputStream.putInteger(bigInteger);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue;
        }
        catch (IOException iOException) {
            throw new IOException(z[20] + iOException);
        }
    }

    public static ECFieldFp decodePrimeFieldType(DerValue derValue) throws IOException {
        int[] nArray = new int[]{1, 2, 840, 10045, 1, 1};
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(nArray);
        try {
            if (derValue.getTag() != 48) {
                throw new IOException(z[5]);
            }
            DerInputStream derInputStream = derValue.getData();
            ObjectIdentifier objectIdentifier2 = derInputStream.getOID();
            if (!objectIdentifier2.equals(objectIdentifier)) {
                throw new IOException(z[7]);
            }
            BigInteger bigInteger = derInputStream.getInteger();
            ECFieldFp eCFieldFp = (ECFieldFp)((Object)ECUtils.getField(bigInteger.bitLength(), bigInteger, ECUtils.isNistPrime(bigInteger)));
            return eCFieldFp;
        }
        catch (IOException iOException) {
            throw new IOException(z[6] + iOException);
        }
    }

    public byte[] encodeECParameters() throws IOException {
        try {
            EllipticCurve ellipticCurve = this.b;
            ECPoint eCPoint = this.c;
            BigInteger bigInteger = this.d;
            int n2 = this.a;
            ECParameterSpec eCParameterSpec = new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n2);
            ECNamedCurve eCNamedCurve = ECParameters.getNamedCurve(eCParameterSpec);
            if (eCNamedCurve != null) {
                return eCNamedCurve.a();
            }
            ECField eCField = ellipticCurve.getField();
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            if (!(eCField instanceof ECFieldFp)) {
                throw new IOException(z[9]);
            }
            DerValue derValue = ECParameters.encodePrimeFieldType((ECFieldFp)eCField);
            derOutputStream.putDerValue(derValue);
            derValue = ECParameters.encodeEllipticCurve(ellipticCurve);
            derOutputStream.putDerValue(derValue);
            byte[] byArray = ECParameters.encodePoint(eCPoint, ellipticCurve);
            derOutputStream.putOctetString(byArray);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(n2);
            DerValue derValue2 = new DerValue(48, derOutputStream.toByteArray());
            byte[] byArray2 = derValue2.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new IOException(z[8] + iOException);
        }
    }

    public static ECParameterSpec decodeECParameters(byte[] byArray) throws IOException {
        boolean bl = false;
        try {
            DerValue derValue;
            block5: {
                block6: {
                    DerInputStream derInputStream = new DerInputStream(byArray);
                    derValue = derInputStream.getDerValue();
                    if (derValue.getTag() == 48) break block5;
                    if (derValue.getTag() != 6) break block6;
                    String string = derValue.getOID().toString();
                    return ECNamedCurve.getECParameterSpec(string);
                }
                throw new IOException(z[24]);
            }
            DerInputStream derInputStream = derValue.getData();
            int n2 = derInputStream.getInteger().intValue();
            DerValue derValue2 = derInputStream.getDerValue();
            ECFieldFp eCFieldFp = ECParameters.decodePrimeFieldType(derValue2);
            DerValue derValue3 = derInputStream.getDerValue();
            EllipticCurve ellipticCurve = ECParameters.decodeEllipticCurve(derValue3, eCFieldFp);
            byte[] byArray2 = derInputStream.getOctetString();
            ECPoint eCPoint = ECParameters.decodePoint(byArray2, ellipticCurve);
            BigInteger bigInteger = derInputStream.getBigInteger();
            int n3 = 0;
            if (derInputStream.available() != 0) {
                bl = true;
                n3 = derInputStream.getInteger().intValue();
            }
            ECParameterSpec eCParameterSpec = null;
            eCParameterSpec = bl ? new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, n3) : new ECParameterSpec(ellipticCurve, eCPoint, bigInteger, 0);
            return eCParameterSpec;
        }
        catch (IOException iOException) {
            throw new IOException(z[25] + iOException);
        }
    }

    public static ECNamedCurve getNamedCurve(ECParameterSpec eCParameterSpec) {
        try {
            Map<String, ECParameterSpec> map = ECNamedCurve.b();
            Set<Map.Entry<String, ECParameterSpec>> set = map.entrySet();
            for (Map.Entry<String, ECParameterSpec> entry : set) {
                ECParameterSpec eCParameterSpec2;
                String string;
                block43: {
                    byte[] byArray;
                    byte[] byArray2;
                    block42: {
                        string = entry.getKey();
                        eCParameterSpec2 = entry.getValue();
                        eCParameterSpec2 = ECUtils.getPrimeParameterSpec(eCParameterSpec2);
                        eCParameterSpec = ECUtils.getPrimeParameterSpec(eCParameterSpec);
                        BigInteger bigInteger = eCParameterSpec2.getCurve().getA();
                        BigInteger bigInteger2 = eCParameterSpec.getCurve().getA();
                        BigInteger bigInteger3 = eCParameterSpec2.getCurve().getB();
                        BigInteger bigInteger4 = eCParameterSpec.getCurve().getB();
                        int n2 = eCParameterSpec2.getCurve().getField().getFieldSize();
                        int n3 = eCParameterSpec.getCurve().getField().getFieldSize();
                        byArray2 = eCParameterSpec2.getCurve().getSeed();
                        byArray = eCParameterSpec.getCurve().getSeed();
                        if (!bigInteger.equals(bigInteger2) || !bigInteger3.equals(bigInteger4)) continue;
                        if (n2 != n3) {
                            continue;
                        }
                        if (byArray2 != null || byArray != null) break block42;
                        break block43;
                    }
                    if (byArray2 == null && byArray != null) {
                        continue;
                    }
                    if (byArray2 != null && byArray == null) {
                        continue;
                    }
                    if (byArray2 == null || byArray == null) break block43;
                    if (byArray2.length != byArray.length) {
                        continue;
                    }
                    boolean bl = true;
                    int n4 = 0;
                    while (true) {
                        block47: {
                            if (n4 >= byArray2.length) break;
                            if (byArray2[n4] == byArray[n4]) break block47;
                            bl = false;
                            break;
                        }
                        ++n4;
                    }
                    if (!bl) {
                        continue;
                    }
                }
                if (!eCParameterSpec2.getGenerator().equals(eCParameterSpec.getGenerator())) {
                    continue;
                }
                if (!eCParameterSpec2.getOrder().equals(eCParameterSpec.getOrder())) {
                    continue;
                }
                if (eCParameterSpec2.getCofactor() != eCParameterSpec.getCofactor()) {
                    continue;
                }
                ECNamedCurve eCNamedCurve = new ECNamedCurve(string);
                return eCNamedCurve;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[28];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "6+";
        int n3 = -1;
        block35: while (true) {
            char[] cArray;
            block40: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block39: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block39;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block40;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 115;
                                break;
                            }
                            case 1: {
                                n9 = 104;
                                break;
                            }
                            case 2: {
                                n9 = 117;
                                break;
                            }
                            case 3: {
                                n9 = 4;
                                break;
                            }
                            default: {
                                n9 = 60;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "&\u0006\u0006qL\u0003\u0007\u0007pY\u0017H\u0005eN\u0012\u0005\u0010pY\u0001H\u0006tY\u0010\u0001\u0013m_\u0012\u001c\u001ckRIH";
                    n3 = 0;
                    continue block35;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "&\u0006\u001ejS\u0004\u0006UgI\u0001\u001e\u0010>\u001c";
                    n3 = 1;
                    continue block35;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ":\u0006\u0014tL\u0001\u0007\u0005vU\u0012\u001c\u0010$L\u0012\u001a\u0014iY\u0007\r\u0007$O\u0003\r\u0016mZ\u001a\u000b\u0014pU\u001c\u0006";
                    n3 = 2;
                    continue block35;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u0003\t\u0007eQ \u0018\u0010g\u001c\u001e\u001d\u0006p\u001c\u001d\u0007\u0001$^\u0016H\u001bqP\u001f";
                    n3 = 3;
                    continue block35;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "=\u0007\u0001$]S;0Ui6&6A";
                    n3 = 4;
                    continue block35;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "6\u0010\u0016aL\u0007\u0001\u001aj\u001c\u001a\u0006U`Y\u0010\u0007\u0011al\u0001\u0001\u0018az\u001a\r\u0019`h\n\u0018\u0010,\u0015IH";
                    n3 = 5;
                    continue block35;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ":\u0006\u0016kN\u0001\r\u0016p\u001c<!1$Y\u001d\u000b\u001aqR\u0007\r\u0007aXS\f\u0000vU\u001d\u000fU`Y\u0010\u0007\u0011al\u0001\u0001\u0018az\u001a\r\u0019`h\n\u0018\u0010*";
                    n3 = 6;
                    continue block35;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "6\u0010\u0016aL\u0007\u0001\u001aj\u001c\u001a\u0006UaR\u0010\u0007\u0011ay08\u0014v]\u001e\r\u0001aN\u0000@\\>\u001c";
                    n3 = 7;
                    continue block35;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "6+3mY\u001f\f36QS\r\u001bgS\u0006\u0006\u0001aN\u0016\fUmRS\r\u001bgS\u0017\r0Gl\u0012\u001a\u0014iY\u0007\r\u0007w\u0014ZFU$y0.\u001caP\u0017.Gi\u001c\u001a\u001bUjS\u0007H\u0016qN\u0001\r\u001bpP\nH\u0006qL\u0003\u0007\u0007pY\u0017F";
                    n3 = 8;
                    continue block35;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "6\u0010\u0016aL\u0007\u0001\u001aj\u001c\u001a\u0006UaR\u0010\u0007\u0011ay\u001f\u0004\u001ctH\u001a\u000b6qN\u0005\r]-\u0006S";
                    n3 = 9;
                    continue block35;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "ya\u0016qN\u0005\rO$6za\u0014>\u001c";
                    n3 = 10;
                    continue block35;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "ya|wU\t\rO$";
                    n3 = 11;
                    continue block35;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "ya|f\u0006S";
                    n3 = 12;
                    continue block35;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "ya\u0012aR\u0016\u001a\u0014pS\u0001RU\u000e5z";
                    n3 = 13;
                    continue block35;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "ya\u001avX\u0016\u001aO$6za";
                    n3 = 14;
                    continue block35;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "ya\u0016kZ\u0012\u000b\u0001kNIH";
                    n3 = 15;
                    continue block35;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "#\u0007\u001cjHS\f\u001aaOS\u0006\u001ap\u001c\u001e\t\u0001gTS\u000e\u001caP\u0017H\u0006mF\u0016";
                    n3 = 16;
                    continue block35;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "<\u0006\u0019}\u001c\u0006\u0006\u0016kQ\u0003\u001a\u0010wO\u0016\fUtS\u001a\u0006\u0001$Z\u001c\u001a\u0018eHS\u001b\u0000tL\u001c\u001a\u0001aX";
                    n3 = 17;
                    continue block35;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "#\u0007\u001cjHS\u000b\u001akN\u0017\u0001\u001beH\u0016\u001bU`SS\u0006\u001ap\u001c\u001e\t\u0001gTS\u000e\u001caP\u0017H\u0006mF\u0016";
                    n3 = 18;
                    continue block35;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "6\u0010\u0016aL\u0007\u0001\u001aj\u001c\u001a\u0006UaR\u0010\u0007\u0011al\u0001\u0001\u0018az\u001a\r\u0019`h\n\u0018\u0010,\u0015IH";
                    n3 = 19;
                    continue block35;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "&\u0006\u0006qL\u0003\u0007\u0007pY\u0017H\u0005eN\u0012\u0005\u0010pY\u0001H\u0006tY\u0010\u0001\u0013m_\u0012\u001c\u001ckRIH";
                    n3 = 20;
                    continue block35;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = ":\u0006\u0014tL\u0001\u0007\u0005vU\u0012\u001c\u0010$L\u0012\u001a\u0014iY\u0007\r\u0007$o\u0003\r\u0016mZ\u001a\u000b\u0014pU\u001c\u0006";
                    n3 = 21;
                    continue block35;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "\u0019\t\u0003e\u0012\u0000\r\u0016qN\u001a\u001c\f*O\u0003\r\u0016*y08\u0014v]\u001e\r\u0001aN \u0018\u0010g";
                    n3 = 22;
                    continue block35;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "=\u0007\u0001$]S;0Ui6&6A\u001c\u001c\u001aUeRS'<@";
                    n3 = 23;
                    continue block35;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "6\u0010\u0016aL\u0007\u0001\u001aj\u001c\u001a\u0006U`Y\u0010\u0007\u0011ay08\u0014v]\u001e\r\u0001aN\u0000@\\>\u001c";
                    n3 = 24;
                    continue block35;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "=\u0007\u0001$]S;0Ui6&6A";
                    n3 = 25;
                    continue block35;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "6\u0010\u0016aL\u0007\u0001\u001aj\u001c\u001a\u0006U`Y\u0010\u0007\u0011ay\u001f\u0004\u001ctH\u001a\u000b6qN\u0005\r]-\u0006S";
                    n3 = 26;
                    continue block35;
                }
                case 26: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

