/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAKeyFactory;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.rsa.RSAUtil;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import javax.security.auth.DestroyFailedException;

final class RSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.RSAPrivateKey,
Serializable {
    static final long serialVersionUID = -5387735831354112582L;
    private BigInteger modulus;
    private BigInteger privateExponent;
    private AlgorithmParameterSpec keyParams;
    private BigInteger publicExponent = BigInteger.ZERO;
    private BigInteger primeP = BigInteger.ZERO;
    private BigInteger primeQ = BigInteger.ZERO;
    private BigInteger primeExponentP = BigInteger.ZERO;
    private BigInteger primeExponentQ = BigInteger.ZERO;
    private BigInteger crtCoefficient = BigInteger.ZERO;
    private static final String[] z;

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = new AlgIdRSA();
        this.a(this.algid, bigInteger, bigInteger2);
    }

    public RSAPrivateKey(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.a(algorithmId, bigInteger, bigInteger2);
    }

    public static RSAPrivateKey newKey(byte[] byArray) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(byArray);
        return rSAPrivateKey;
    }

    public static RSAPrivateKey newKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(bigInteger, bigInteger2);
        return rSAPrivateKey;
    }

    private void a(AlgorithmId algorithmId, BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.algid = algorithmId;
        this.modulus = bigInteger;
        this.privateExponent = bigInteger2;
        this.keyParams = RSAUtil.getParamSpec((AlgorithmId)algorithmId);
        RSAKeyFactory.b(this.modulus.bitLength(), null);
        try {
            this.key = RSAPrivateKey.a(bigInteger, bigInteger2);
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[2] + iOException.getMessage());
        }
    }

    public RSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algid.getName();
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.privateExponent;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    protected void parseKeyBits() throws IOException {
        block7: {
            try {
                block6: {
                    DerValue derValue = new DerValue(this.key);
                    int n2 = derValue.getData().getInteger().intValue();
                    if (n2 != 0) break block6;
                    this.modulus = derValue.getData().getPositiveBigInteger();
                    this.publicExponent = derValue.getData().getPositiveBigInteger();
                    this.privateExponent = derValue.getData().getPositiveBigInteger();
                    this.primeP = derValue.getData().getPositiveBigInteger();
                    this.primeQ = derValue.getData().getPositiveBigInteger();
                    this.primeExponentP = derValue.getData().getPositiveBigInteger();
                    this.primeExponentQ = derValue.getData().getPositiveBigInteger();
                    this.crtCoefficient = derValue.getData().getPositiveBigInteger();
                    if (derValue.getData().available() == 0) break block7;
                    throw new IOException(z[0]);
                }
                this.a();
            }
            catch (IOException iOException) {
                throw new IOException(z[1], iOException);
            }
        }
    }

    private void a() throws IOException {
        try {
            DerValue derValue = new DerValue(this.key);
            this.modulus = derValue.getData().getInteger();
            this.privateExponent = derValue.getData().getInteger();
            if (derValue.getData().available() != 0) {
                throw new IOException(z[3]);
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    private static byte[] a(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        DerValue[] derValueArray = new DerValue[]{new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, bigInteger.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, bigInteger2.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray()), new DerValue(2, BigInteger.ZERO.toByteArray())};
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    @Override
    public void destroy() throws DestroyFailedException {
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\t,G}9)&\u0011N\u0006\u0001\u0012Cu#!6TW09bTr6/&Xr2lbU}!!b^j020Dr";
        int n3 = -1;
        block11: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                block14: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block14;
                    n5 = n5;
                    if (n5 <= n4) break block15;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 64;
                            break;
                        }
                        case 1: {
                            n6 = 66;
                            break;
                        }
                        case 2: {
                            n6 = 49;
                            break;
                        }
                        case 3: {
                            n6 = 28;
                            break;
                        }
                        default: {
                            n6 = 85;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\t,G}9)&\u0011N\u0006\u0001bAn<6#Eyu+'H";
                    n3 = 0;
                    continue block11;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "#-Dp1`,^hu\u0004\u0007c<0.!^x0zb";
                    n3 = 1;
                    continue block11;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\t,G}9)&\u0011N\u0006\u0001\u0012Cu#!6TW09jBl421T5u%,Rs1),V0u$#E}u/4Tn'5,";
                    n3 = 2;
                    continue block11;
                }
                case 2: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

