/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.util.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class PKCS12Attribute
implements KeyStore.Entry.Attribute {
    private static final Pattern a;
    private String b;
    private String c;
    private byte[] d;
    private int e;
    private static final String[] z;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PKCS12Attribute(String string, String string2) {
        String[] stringArray;
        ObjectIdentifier objectIdentifier;
        block10: {
            block9: {
                this.e = -1;
                if (string == null) throw new NullPointerException();
                if (string2 == null) {
                    throw new NullPointerException();
                }
                try {
                    objectIdentifier = new ObjectIdentifier(string);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(z[2], iOException);
                }
                this.b = string;
                int n2 = string2.length();
                if (string2.charAt(0) != '[' || string2.charAt(n2 - 1) != ']') break block9;
                stringArray = string2.substring(1, n2 - 1).split(z[1]);
                break block10;
            }
            stringArray = new String[]{string2};
        }
        this.c = string2;
        try {
            this.d = this.a(objectIdentifier, stringArray);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(z[0], iOException);
        }
    }

    public PKCS12Attribute(byte[] byArray) {
        this.e = -1;
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.d = (byte[])byArray.clone();
        try {
            this.a(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(z[3], iOException);
        }
    }

    @Override
    public String getName() {
        return this.b;
    }

    @Override
    public String getValue() {
        return this.c;
    }

    public byte[] getEncoded() {
        return (byte[])this.d.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PKCS12Attribute)) {
            return false;
        }
        return Arrays.equals(this.d, ((PKCS12Attribute)object).getEncoded());
    }

    public int hashCode() {
        if (this.e == -1) {
            Arrays.hashCode(this.d);
        }
        return this.e;
    }

    public String toString() {
        return this.b + "=" + this.c;
    }

    private byte[] a(ObjectIdentifier objectIdentifier, String[] derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(objectIdentifier);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        for (String string : derOutputStream) {
            if (a.matcher(string).matches()) {
                byte[] byArray = new BigInteger(string.replace(":", ""), 16).toByteArray();
                if (byArray[0] == 0) {
                    byArray = Arrays.copyOfRange(byArray, 1, byArray.length);
                }
                derOutputStream3.putOctetString(byArray);
                continue;
            }
            derOutputStream3.putUTF8String(string);
        }
        derOutputStream2.write((byte)49, derOutputStream3);
        DerOutputStream derOutputStream4 = new DerOutputStream();
        derOutputStream4.write((byte)48, derOutputStream2);
        return derOutputStream4.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        ObjectIdentifier objectIdentifier = derValueArray[0].getOID();
        DerInputStream derInputStream2 = new DerInputStream(derValueArray[1].toByteArray());
        DerValue[] derValueArray2 = derInputStream2.getSet(1);
        Object[] objectArray = new String[derValueArray2.length];
        for (int n2 = 0; n2 < derValueArray2.length; ++n2) {
            String string;
            objectArray[n2] = derValueArray2[n2].getTag() == 4 ? Debug.toString((byte[])derValueArray2[n2].getOctetString()) : ((string = derValueArray2[n2].getAsString()) != null ? string : (derValueArray2[n2].getTag() == 6 ? derValueArray2[n2].getOID().toString() : (derValueArray2[n2].getTag() == 24 ? derValueArray2[n2].getGeneralizedTime().toString() : (derValueArray2[n2].getTag() == 23 ? derValueArray2[n2].getUTCTime().toString() : (derValueArray2[n2].getTag() == 2 ? derValueArray2[n2].getBigInteger().toString() : (derValueArray2[n2].getTag() == 1 ? String.valueOf(derValueArray2[n2].getBoolean()) : Debug.toString((byte[])derValueArray2[n2].getDataBytes())))))));
        }
        this.b = objectIdentifier.toString();
        this.c = objectArray.length == 1 ? objectArray[0] : Arrays.toString(objectArray);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block25: {
            int n2;
            int n3;
            block24: {
                String string;
                String[] stringArray = new String[4];
                String[] stringArray2 = stringArray;
                String[] stringArray3 = stringArray;
                int n4 = 0;
                String string2 = "Z\u0019_\u0018da\u0012_\u00036u\u0018N\u001awgM\u001c\u0001w\u007f\u0002Y";
                int n5 = -1;
                block17: while (true) {
                    char[] cArray2;
                    block23: {
                        int n6;
                        block22: {
                            char[] cArray3 = string2.toCharArray();
                            cArray2 = cArray3;
                            n6 = cArray3.length;
                            n3 = 0;
                            if (!true) break block22;
                            n6 = n6;
                            if (n6 <= n3) break block23;
                        }
                        do {
                            int n7;
                            cArray2 = cArray2;
                            int n8 = n3;
                            char c2 = cArray2[n8];
                            switch (n3 % 5) {
                                case 0: {
                                    n7 = 19;
                                    break;
                                }
                                case 1: {
                                    n7 = 119;
                                    break;
                                }
                                case 2: {
                                    n7 = 60;
                                    break;
                                }
                                case 3: {
                                    n7 = 119;
                                    break;
                                }
                                default: {
                                    n7 = 22;
                                }
                            }
                            cArray2[n8] = (char)(c2 ^ n7);
                            ++n3;
                            n6 = n6;
                        } while (n6 > n3);
                    }
                    string = new String(cArray2);
                    switch (n5) {
                        default: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 1;
                            string2 = "?W";
                            n5 = 0;
                            continue block17;
                        }
                        case 0: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 2;
                            string2 = "Z\u0019_\u0018da\u0012_\u00036u\u0018N\u001awgM\u001c\u0019w~\u0012";
                            n5 = 1;
                            continue block17;
                        }
                        case 1: {
                            stringArray2[n4] = string.intern();
                            stringArray2 = stringArray3;
                            stringArray3 = stringArray3;
                            n4 = 3;
                            string2 = "Z\u0019_\u0018da\u0012_\u00036u\u0018N\u001awgM\u001c\u0012xp\u0018X\u0012r";
                            n5 = 2;
                            continue block17;
                        }
                        case 2: 
                    }
                    break;
                }
                stringArray2[n4] = string.intern();
                z = stringArray3;
                char[] cArray4 = "M,\fZ/rZZ6;U*GEk;MgG;*\u0016\u0011\u0011W>1a\f$n^\u0017S".toCharArray();
                cArray = cArray4;
                n2 = cArray4.length;
                n3 = 0;
                if (!true) break block24;
                n2 = n2;
                if (n2 <= n3) break block25;
            }
            do {
                int n9;
                cArray = cArray;
                int n10 = n3;
                char c3 = cArray[n10];
                switch (n3 % 5) {
                    case 0: {
                        n9 = 19;
                        break;
                    }
                    case 1: {
                        n9 = 119;
                        break;
                    }
                    case 2: {
                        n9 = 60;
                        break;
                    }
                    case 3: {
                        n9 = 119;
                        break;
                    }
                    default: {
                        n9 = 22;
                    }
                }
                cArray[n10] = (char)(c3 ^ n9);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        a = Pattern.compile(new String(cArray).intern());
    }
}

