/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.ECParameters;
import com.ibm.crypto.provider.ECUtils;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class ECPublicKey
extends X509Key
implements java.security.interfaces.ECPublicKey,
ECKey,
Serializable {
    static final long serialVersionUID = -6195576206652962694L;
    private ECPoint w;
    private ECParameterSpec params;
    private static final String[] z;

    public ECPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    public ECPublicKey(ECPoint eCPoint, ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        this.w = eCPoint;
        this.params = ECUtils.getPrimeParameterSpec(eCParameterSpec);
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.a(eCParameterSpec));
        this.key = ECParameters.encodePoint(eCPoint, this.params.getCurve());
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                throw new InvalidKeyException(z[1]);
            }
            this.params = ECUtils.getPrimeParameterSpec(algorithmParameters.getParameterSpec(ECParameterSpec.class));
            this.w = ECParameters.decodePoint(this.key, this.params.getCurve());
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z[0], iOException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException(z[2], invalidParameterSpecException);
        }
    }

    @Override
    public ECPoint getW() {
        return this.w;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "\b\t.\u001e|(\u0003x:Sa\f=\u0006";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                block13: {
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    n5 = cArray2.length;
                    n4 = 0;
                    if (!true) break block13;
                    n5 = n5;
                    if (n5 <= n4) break block14;
                }
                do {
                    int n6;
                    cArray = cArray;
                    int n7 = n4;
                    char c2 = cArray[n7];
                    switch (n4 % 5) {
                        case 0: {
                            n6 = 65;
                            break;
                        }
                        case 1: {
                            n6 = 103;
                            break;
                        }
                        case 2: {
                            n6 = 88;
                            break;
                        }
                        case 3: {
                            n6 = 127;
                            break;
                        }
                        default: {
                            n6 = 16;
                        }
                    }
                    cArray[n7] = (char)(c2 ^ n6);
                    ++n4;
                    n5 = n5;
                } while (n5 > n4);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0004$x\u001b\u007f,\u00061\u001101\u0006*\u001e}$\u0013=\rca\n-\fda\u0005=_u/\u00047\u001bu%G1\u001105\u000f=_q-\u00007\ry5\u000f5_y%\u00026\u000by'\u000e=\r";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\b\t.\u001e|(\u0003x:Sa\f=\u0006";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

