/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.security.auth.DestroyFailedException;

final class DSAPrivateKey
extends PrivateKeyInfo
implements java.security.interfaces.DSAPrivateKey,
Serializable {
    static final long serialVersionUID = 6681063074876594473L;
    private BigInteger x;
    private static final String z;

    public DSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this.x = bigInteger;
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        try {
            this.key = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z + iOException.getMessage());
        }
    }

    public DSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        try {
            this.decode(byArray);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    @Override
    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)this.algid;
            }
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            if (algorithmParameters == null) {
                return null;
            }
            DSAParameterSpec dSAParameterSpec = algorithmParameters.getParameterSpec(DSAParameterSpec.class);
            return dSAParameterSpec;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    protected void parseKeyBits() throws IOException {
        DerInputStream derInputStream = new DerInputStream(this.key);
        try {
            this.x = derInputStream.getInteger();
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block9: {
            int n2;
            int n3;
            block8: {
                char[] cArray2 = "B\u0016'de\u0001\u0017=|!e<\u0000(dO\u001a=ld\u0001\u0001h(".toCharArray();
                cArray = cArray2;
                n3 = cArray2.length;
                n2 = 0;
                if (!true) break block8;
                n3 = n3;
                if (n3 <= n2) break block9;
            }
            do {
                int n4;
                cArray = cArray;
                int n5 = n2;
                char c2 = cArray[n5];
                switch (n2 % 5) {
                    case 0: {
                        n4 = 33;
                        break;
                    }
                    case 1: {
                        n4 = 121;
                        break;
                    }
                    case 2: {
                        n4 = 82;
                        break;
                    }
                    case 3: {
                        n4 = 8;
                        break;
                    }
                    default: {
                        n4 = 1;
                    }
                }
                cArray[n5] = (char)(c2 ^ n4);
                ++n2;
                n3 = n3;
            } while (n3 > n2);
        }
        z = new String(cArray).intern();
    }
}

