/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import com.ibm.dtfj.utils.file.FileManager;
import com.ibm.dtfj.utils.file.FileSniffer;
import com.ibm.dtfj.utils.file.ImageSourceType;
import com.ibm.dtfj.utils.file.MVSImageInputStream;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public class SimpleFileManager
extends FileManager {
    protected final File managedFile;
    private long filesize = Long.MAX_VALUE;

    public SimpleFileManager(File file) {
        this.managedFile = file;
    }

    @Override
    public List<ManagedImageSource> getImageSources() throws IOException {
        ArrayList<ManagedImageSource> candidates = new ArrayList<ManagedImageSource>();
        ImageInputStream iis = this.getStream();
        if (this.identifiedCoreFile(candidates, iis)) {
            iis.close();
            return candidates;
        }
        if (this.identifiedJavaCore(candidates, iis)) {
            iis.close();
            return candidates;
        }
        if (this.identifiedPHD(candidates, iis)) {
            iis.close();
            return candidates;
        }
        iis.close();
        throw new IOException("No Image sources were found for " + this.managedFile.getAbsolutePath());
    }

    private boolean identifiedCoreFile(ArrayList<ManagedImageSource> candidates, ImageInputStream iis) throws IOException {
        if (FileSniffer.isCoreFile(iis, this.filesize)) {
            ManagedImageSource candidate = new ManagedImageSource(this.managedFile.getName(), ImageSourceType.CORE);
            candidate.setPath(this.managedFile.getPath());
            File meta = new File(this.managedFile.getParent(), this.managedFile.getName() + ".xml");
            logger.finer("Identified core file : " + candidate.toURI());
            if (SimpleFileManager.fileExists(meta)) {
                ManagedImageSource metadata = new ManagedImageSource(meta.getName(), ImageSourceType.META);
                metadata.setPath(meta.getPath());
                candidate.setMetadata(metadata);
                logger.finer("Identified core file metadata : " + metadata.toURI());
            }
            candidates.add(candidate);
            return true;
        }
        return false;
    }

    private boolean identifiedJavaCore(ArrayList<ManagedImageSource> candidates, ImageInputStream iis) throws IOException {
        if (FileSniffer.isJavaCoreFile(iis, this.filesize)) {
            ManagedImageSource candidate = new ManagedImageSource(this.managedFile.getName(), ImageSourceType.JAVACORE);
            candidate.setPath(this.managedFile.getPath());
            candidates.add(candidate);
            logger.finer("Identified javacore file : " + candidate.toURI());
            return true;
        }
        return false;
    }

    private boolean identifiedPHD(ArrayList<ManagedImageSource> candidates, ImageInputStream iis) throws IOException {
        if (FileSniffer.isPHDFile(iis, this.filesize)) {
            ManagedImageSource candidate = new ManagedImageSource(this.managedFile.getName(), ImageSourceType.PHD);
            candidate.setPath(this.managedFile.getPath());
            String[] jcnames = this.getJavaCoreNameFromPHD(this.managedFile.getName());
            logger.finer("Identified PHD file : " + candidate.toURI());
            for (String jcname : jcnames) {
                File jc = new File(this.managedFile.getParent(), jcname);
                if (!SimpleFileManager.fileExists(jc)) continue;
                ManagedImageSource meta = new ManagedImageSource(jcname, ImageSourceType.META);
                meta.setPath(jc.getPath());
                candidate.setMetadata(meta);
                logger.finer("Identified associated javacore file : " + meta.toURI());
                break;
            }
            candidates.add(candidate);
            return true;
        }
        return false;
    }

    @Override
    public ImageInputStream getStream() throws IOException {
        if (this.managedFile.exists()) {
            this.filesize = this.managedFile.length();
            return new FileImageInputStream(this.managedFile);
        }
        String os = System.getProperty("os.name");
        if (os == null) {
            throw new IOException("Cannot determine the system type from os.name");
        }
        if (os.toLowerCase().contains("z/os")) {
            try {
                MVSImageInputStream mvsStream = new MVSImageInputStream(this.managedFile.getName());
                this.filesize = mvsStream.size();
                return mvsStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        throw new FileNotFoundException("The specified file " + this.managedFile.getAbsolutePath() + " was not found");
    }
}

