/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd.util;

public final class BitStream {
    private int[] bits = new int[100];
    private int wordOffset;
    private int bitOffset;
    private static final boolean dbg = false;

    void reset() {
        this.wordOffset = 0;
        this.bitOffset = 0;
    }

    public void rewind() {
        this.reset();
    }

    public void clear() {
        this.reset();
        if (this.bits.length > 262144) {
            this.bits = new int[100];
        }
        this.bits[0] = 0;
    }

    private void writeIntInWord(int n, int len) {
        if (len < 32) {
            n &= (1 << len) - 1;
        }
        if (len <= 0) {
            throw new Error("bad length: " + len);
        }
        int b = this.bits[this.wordOffset];
        this.bits[this.wordOffset] = b |= n << 32 - (this.bitOffset + len);
        this.bitOffset += len;
    }

    public void writeLongBits(long n, int len) {
        BitStream.Assert(len < 64);
        this.writeIntBits((int)(n >> 32), len - 32);
        this.writeIntBits((int)n, 32);
    }

    public void writeIntBits(int n, int len) {
        if (len > 32 || len < 0) {
            throw new Error("bad length: " + len);
        }
        if (len < 32 - this.bitOffset) {
            this.writeIntInWord(n, len);
        } else {
            int firstlen = 32 - this.bitOffset;
            int secondlen = len + this.bitOffset - 32;
            if (firstlen > 0) {
                this.writeIntInWord(n >>> secondlen, firstlen);
            }
            if (secondlen > 0) {
                this.nextWord(true);
                this.bits[this.wordOffset] = 0;
                this.writeIntInWord(n, secondlen);
            }
        }
    }

    public void writeIntBits(int n, int len, int wordOff, int bitOff) {
        int saveWordOffset = this.wordOffset;
        int saveBitOffset = this.bitOffset;
        this.wordOffset = wordOff;
        this.bitOffset = bitOff;
        this.writeIntBits(n, len);
        this.wordOffset = saveWordOffset;
        this.bitOffset = saveBitOffset;
    }

    public void nextWord(boolean write) {
        ++this.wordOffset;
        if (this.wordOffset >= this.bits.length) {
            int[] tmp = new int[(this.bits.length * 3 + 1) / 2];
            System.arraycopy(this.bits, 0, tmp, 0, this.bits.length);
            this.bits = tmp;
        } else if (write) {
            this.bits[this.wordOffset] = 0;
        }
        this.bitOffset = 0;
    }

    public void compact() {
        int[] tmp = new int[this.wordOffset + 1];
        System.arraycopy(this.bits, 0, tmp, 0, tmp.length);
        this.bits = tmp;
    }

    public int getOffset() {
        return this.wordOffset;
    }

    public void setOffset(int offset) {
        this.wordOffset = offset;
        this.bitOffset = 0;
    }

    private int readIntInWord(int len) {
        BitStream.Assert(len > 0);
        int n = this.bits[this.wordOffset] >> 32 - (this.bitOffset + len);
        if (len < 32) {
            n &= (1 << len) - 1;
        }
        this.bitOffset += len;
        return n;
    }

    public int readIntBits(int len) {
        if (len > 32 || len <= 0) {
            throw new Error("bad length: " + len);
        }
        if (len < 32 - this.bitOffset) {
            return this.readIntInWord(len);
        }
        int firstlen = 32 - this.bitOffset;
        int secondlen = len + this.bitOffset - 32;
        int first = 0;
        if (firstlen > 0) {
            first = this.readIntInWord(firstlen);
        }
        int second = 0;
        if (secondlen > 0) {
            this.nextWord(false);
            second = this.readIntInWord(secondlen);
        }
        return first << secondlen | second;
    }

    public long readLongBits(int len) {
        BitStream.Assert(len < 64);
        if (len <= 32) {
            return this.readIntBits(len);
        }
        long upper = this.readIntBits(len - 32);
        BitStream.Assert(upper >= 0L);
        long lower = this.readIntBits(32);
        return upper << 32 | lower & 0xFFFFFFFFL;
    }

    public int readIntBits(int len, int wordOff, int bitOff) {
        int saveWordOffset = this.wordOffset;
        int saveBitOffset = this.bitOffset;
        this.wordOffset = wordOff;
        this.bitOffset = bitOff;
        int r = this.readIntBits(len);
        this.wordOffset = saveWordOffset;
        this.bitOffset = saveBitOffset;
        return r;
    }

    public int memoryUsage() {
        return this.bits.length * 4;
    }

    static void Assert(boolean condition) {
        if (!condition) {
            throw new Error("assert failed");
        }
    }

    static String hex(long i) {
        return Long.toHexString(i);
    }
}

