/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDCorruptJavaStackFrame;
import com.ibm.dtfj.phd.PHDImageProcess;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import com.ibm.dtfj.phd.PHDJavaStackFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PHDJavaThread
implements JavaThread {
    private ImagePointer env;
    private CorruptData env_cd;
    private String name;
    private CorruptData name_cd;
    private int priority;
    private CorruptData priority_cd;
    private int state;
    private CorruptData state_cd;
    private List<JavaStackFrame> frames = new ArrayList<JavaStackFrame>();
    private JavaObject object;
    private CorruptData object_cd;
    private ImageThread imageThread;
    private CorruptData imageThread_cd;

    PHDJavaThread(ImageAddressSpace space, PHDImageProcess process, PHDJavaRuntime runtime, JavaThread meta) {
        try {
            this.env = space.getPointer(meta.getJNIEnv().getAddress());
        }
        catch (CorruptDataException e) {
            this.env_cd = new PHDCorruptData(space, e);
        }
        try {
            this.name = meta.getName();
        }
        catch (CorruptDataException e) {
            this.name_cd = new PHDCorruptData(space, e);
        }
        try {
            this.priority = meta.getPriority();
        }
        catch (CorruptDataException e) {
            this.priority_cd = new PHDCorruptData(space, e);
        }
        try {
            this.state = meta.getState();
        }
        catch (CorruptDataException e) {
            this.state_cd = new PHDCorruptData(space, e);
        }
        Iterator it = meta.getStackFrames();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof CorruptData) {
                this.frames.add(new PHDCorruptJavaStackFrame(space, (CorruptData)next));
                continue;
            }
            this.frames.add(new PHDJavaStackFrame(space, runtime, (JavaStackFrame)next));
        }
        try {
            JavaObject obj = meta.getObject();
            if (obj != null) {
                try {
                    this.object = runtime.getObjectAtAddress(space.getPointer(obj.getID().getAddress()));
                }
                catch (CorruptDataException e) {
                    this.object_cd = e.getCorruptData();
                }
                catch (DataUnavailable dataUnavailable) {
                }
                catch (MemoryAccessException memoryAccessException) {}
            }
        }
        catch (CorruptDataException e) {
            this.object_cd = new PHDCorruptData(space, e);
        }
        try {
            ImageThread metaThread = meta.getImageThread();
            this.imageThread = process.getThread(space, metaThread);
        }
        catch (DataUnavailable metaThread) {
        }
        catch (CorruptDataException e) {
            this.imageThread_cd = new PHDCorruptData(space, e);
        }
    }

    @Override
    public ImageThread getImageThread() throws CorruptDataException, DataUnavailable {
        if (this.imageThread_cd != null) {
            throw new CorruptDataException(this.imageThread_cd);
        }
        if (this.imageThread == null) {
            throw new DataUnavailable();
        }
        return this.imageThread;
    }

    @Override
    public ImagePointer getJNIEnv() throws CorruptDataException {
        this.checkCD(this.env_cd);
        return this.env;
    }

    @Override
    public String getName() throws CorruptDataException {
        this.checkCD(this.name_cd);
        return this.name;
    }

    @Override
    public JavaObject getObject() throws CorruptDataException {
        this.checkCD(this.object_cd);
        return this.object;
    }

    @Override
    public int getPriority() throws CorruptDataException {
        this.checkCD(this.priority_cd);
        return this.priority;
    }

    @Override
    public Iterator<JavaStackFrame> getStackFrames() {
        return this.frames.iterator();
    }

    @Override
    public Iterator<ImageSection> getStackSections() {
        return Collections.emptyList().iterator();
    }

    @Override
    public int getState() throws CorruptDataException {
        this.checkCD(this.state_cd);
        return this.state;
    }

    private void checkCD(CorruptData cd) throws CorruptDataException {
        if (cd != null) {
            throw new CorruptDataException(cd);
        }
    }

    @Override
    public JavaObject getBlockingObject() throws CorruptDataException, DataUnavailable {
        throw new DataUnavailable("Not Available.");
    }
}

