/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageFactory;
import com.ibm.dtfj.phd.PHDImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.stream.ImageInputStream;

public class PHDImageFactory
implements ImageFactory {
    static final Date earliestDump = new Date(946684800000L);
    static final Date latestDump = new Date(2147483647000L);

    @Override
    public Image getImage(ImageInputStream in, URI sourceID) throws IOException {
        return new PHDImage(sourceID, in);
    }

    @Override
    public Image getImage(ImageInputStream in, ImageInputStream meta, URI sourceID) throws IOException {
        ImageFactory metaFactory = this.getMetaFactory();
        Image metaImage = metaFactory.getImage(meta, sourceID);
        return new PHDImage(sourceID, in, metaImage);
    }

    @Override
    public Image[] getImagesFromArchive(File archive, boolean extract) throws IOException {
        throw new IOException("Not supported for PHD files");
    }

    private ImageFactory getMetaFactory() throws IOException {
        ImageFactory factory = null;
        try {
            Class<?> c2 = Class.forName("com.ibm.dtfj.image.javacore.JCImageFactory");
            factory = (ImageFactory)c2.newInstance();
        }
        catch (ClassNotFoundException e) {
            IOException e2 = new IOException("Unable to create javacore image factory");
            e2.initCause(e);
            throw e2;
        }
        catch (InstantiationException e) {
            IOException e2 = new IOException("Unable to create javacore image factory");
            e2.initCause(e);
            throw e2;
        }
        catch (IllegalAccessException e) {
            IOException e2 = new IOException("Unable to create javacore image factory");
            e2.initCause(e);
            throw e2;
        }
        return factory;
    }

    @Override
    public int getDTFJMajorVersion() {
        return 1;
    }

    @Override
    public int getDTFJMinorVersion() {
        return 12;
    }

    @Override
    public Image getImage(File file) throws IOException {
        File meta = this.findMetaFile(file);
        if (meta == null) {
            File f2 = file;
            try {
                f2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!file.equals(f2)) {
                meta = this.findMetaFile(f2);
            }
        }
        if (meta != null) {
            try {
                Image i2 = this.getMetaImage(file, meta);
                return new PHDImage(file, i2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new PHDImage(file);
    }

    private File findMetaFile(File file) {
        String name = file.getName();
        String prefix = "heapdump";
        int p = Math.max(0, name.indexOf(prefix));
        String extraPrefix = name.substring(0, p);
        if ((name = name.substring(p)).startsWith(prefix)) {
            String[] s = name.split("\\.");
            s[0] = extraPrefix + "javacore" + s[0].substring(prefix.length());
            int[] sequence = s.length >= 6 ? new int[]{0, 1, -1} : new int[]{0};
            for (int j : sequence) {
                String metafn = this.genJavacoreName(s, j, 4);
                File meta = new File(file.getParent(), metafn);
                if (!meta.exists()) continue;
                return meta;
            }
            if (s.length == 5 || s.length == 6 && s[5].equals("gz")) {
                String dateTime = "yyyyMMdd.HHmmss";
                SimpleDateFormat sdf = new SimpleDateFormat(dateTime);
                ParsePosition pp = new ParsePosition(0);
                for (int i = prefix.length(); i < name.length(); ++i) {
                    pp.setIndex(i);
                    Date d = sdf.parse(name, pp);
                    if (d == null || d.before(earliestDump) || !d.before(latestDump)) continue;
                    String namePrefix = name.substring(0, i).replace("heapdump", "javacore");
                    String nameSuffix = name.substring(pp.getIndex()).replaceAll("\\.phd$", ".txt").replaceAll("\\.phd\\.gz$", ".txt");
                    for (long dl = d.getTime(); dl < d.getTime() + 120000L; dl += 1000L) {
                        String newDate = sdf.format(new Date(dl));
                        String metafn = extraPrefix + namePrefix + newDate + nameSuffix;
                        File meta = new File(file.getParent(), metafn);
                        if (!meta.exists()) continue;
                        return meta;
                    }
                }
            }
            if (s.length == 3 || s.length == 4 && s[3].equals("gz")) {
                for (int j = 1; j < 300; ++j) {
                    String metafn = this.genJavacoreName(s, j, 1);
                    File meta = new File(file.getParent(), metafn);
                    if (!meta.exists()) continue;
                    return meta;
                }
            }
        }
        return null;
    }

    private String genJavacoreName(String[] s, int inc, int componentToInc) {
        StringBuffer sb = new StringBuffer(s[0]);
        for (int i = 1; i < s.length - 1; ++i) {
            String ss = s[i];
            if (i == componentToInc) {
                try {
                    int iv = Integer.parseInt(ss);
                    String si = Integer.toString(iv + inc);
                    ss = ss.substring(0, Math.max(0, ss.length() - si.length())) + si;
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (i == s.length - 2 && s[i + 1].equals("gz")) break;
            sb.append('.');
            sb.append(ss);
        }
        sb.append(".txt");
        return sb.toString();
    }

    @Override
    public Image getImage(File file, File metaFile) throws IOException {
        Image i2 = this.getMetaImage(file, metaFile);
        return new PHDImage(file, i2);
    }

    private Image getMetaImage(File file, File metaFile) throws IOException, FileNotFoundException {
        Image i2;
        ImageFactory metaFactory = this.getMetaFactory();
        try {
            i2 = metaFactory.getImage(metaFile);
        }
        catch (RuntimeException e) {
            FileNotFoundException ex = new FileNotFoundException(MessageFormat.format("Problem opening dump {0} metafile {1}", file, metaFile));
            ex.initCause(e);
            throw ex;
        }
        return i2;
    }

    @Override
    public int getDTFJModificationLevel() {
        return 28002;
    }
}

