/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.thread;

import com.ibm.dtfj.javacore.parser.framework.scanner.TokenManager;
import com.ibm.dtfj.javacore.parser.framework.tag.LineRule;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.thread.ThreadPatternMatchers;
import java.util.regex.Matcher;

public class StackTraceLineRule
extends LineRule {
    private StringBuffer fNameBuffer = new StringBuffer("");

    @Override
    public void processLine(String source, int startingOffset) {
        int offset = startingOffset;
        this.consumeUntilFirstMatch(CommonPatternMatchers.at_string);
        this.processMethodAndClassName(offset);
        String methodType = "stacktrace_java_method";
        if (this.consumeUntilFirstMatch(ThreadPatternMatchers.native_method_string)) {
            methodType = "stacktrace_native_method";
        }
        this.addToken("stacktrace_method_type", methodType);
        if (methodType.equals("stacktrace_java_method") && !this.findFirst(ThreadPatternMatchers.bytecode_pc)) {
            this.addToken("class_file_name", CommonPatternMatchers.java_file_name);
            String compilation_level = "unknown_comp_lvl";
            if (this.consumeUntilFirstMatch(CommonPatternMatchers.colon)) {
                this.addToken("stacktrace_line_number", CommonPatternMatchers.dec);
            }
            if (this.consumeUntilFirstMatch(ThreadPatternMatchers.compiled_code)) {
                compilation_level = "compiled";
            }
            this.addToken(TokenManager.getToken(0, offset, this.getLineNumber(), "comp_level", compilation_level));
        }
    }

    private void processMethodAndClassName(int offset) {
        Matcher matcher = this.findFirst(CommonPatternMatchers.forward_slash) ? CommonPatternMatchers.java_absolute_method_name : CommonPatternMatchers.java_sov_absolute_method_name;
        String fullName = this.matchAndConsumeValue(matcher);
        if (fullName != null) {
            this.fNameBuffer.delete(0, this.fNameBuffer.length());
            this.fNameBuffer.append(fullName);
            int endingDot = 0;
            for (int index = 0; index < this.fNameBuffer.length(); ++index) {
                if (this.fNameBuffer.charAt(index) != '.') continue;
                endingDot = index;
                this.fNameBuffer.setCharAt(index, '/');
            }
            if (endingDot > 0) {
                String className = this.fNameBuffer.substring(0, endingDot);
                this.addToken("full_location_name", className);
            }
            if (++endingDot < this.fNameBuffer.length()) {
                String methodName = this.fNameBuffer.substring(endingDot);
                this.addToken("method_name", methodName);
            }
        }
    }
}

