/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.monitor;

import com.ibm.dtfj.javacore.parser.framework.tag.LineRule;
import com.ibm.dtfj.javacore.parser.framework.tag.TagParser;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.monitor.IMonitorTypes;
import com.ibm.dtfj.javacore.parser.j9.section.monitor.MonitorObjectLineRule;

public class MonitorTagParser
extends TagParser
implements IMonitorTypes {
    public MonitorTagParser() {
        super("LOCKS");
    }

    @Override
    protected void initTagAttributeRules() {
        this.addTag("1LKPOOLINFO", null);
        this.addPoolTotal();
        this.addTag("1LKMONPOOLDUMP", null);
        this.addMonInUse();
        this.addMonObject();
        this.addTag("3LKWAITERQ", null);
        this.addWaiter();
        this.addTag("3LKNOTIFYQ", null);
        this.addWaitNotify();
        this.addTag("1LKREGMONDUMP", null);
        this.addRegMon();
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.addToken("LOCKS", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("1LKFLATMONDUMP", lineRule);
        LineRule lineRule2 = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.addPrefixedHexToken("monitor_flat_id");
                this.addToken("monitor_thd_name", CommonPatternMatchers.quoted_stringvalue);
                this.addPrefixedHexToken("monitor_thread_id");
                this.addPrefixedHexToken("monitor_thread_ee");
            }
        };
        this.addTag("2LKFLATMON", lineRule2);
        this.addTag("1LKOBJMONDUMP", null);
        MonitorObjectLineRule lineRule3 = new MonitorObjectLineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.addMonitorObjectNameAndAddress();
            }
        };
        this.addTag("2LKINFLATEDMON", lineRule3);
        this.addTag("3LKINFLDETAILS", null);
        this.addTag("2LKFLATLOCKED", lineRule3);
        LineRule lineRule4 = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.addPrefixedHexToken("monitor_flat_id");
            }
        };
        this.addTag("3LKFLATDETAILS", lineRule4);
    }

    private void addPoolTotal() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.addToken("mon_total_monitors", CommonPatternMatchers.dec);
            }
        };
        this.addTag("2LKPOOLTOTAL", lineRule);
    }

    private void addMonInUse() {
        MonitorObjectLineRule lineRule = new MonitorObjectLineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.addSystemAndInflatedThdInfo();
            }
        };
        this.addTag("2LKMONINUSE", lineRule);
    }

    private void addMonObject() {
        MonitorObjectLineRule lineRule = new MonitorObjectLineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.addMonitorObjectNameAndAddress();
            }
        };
        this.addTag("3LKMONOBJECT", lineRule);
    }

    private void addWaiter() {
        MonitorObjectLineRule lineRule = new MonitorObjectLineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.addVMThreadInformation();
            }
        };
        this.addTag("3LKWAITER", lineRule);
    }

    private void addWaitNotify() {
        MonitorObjectLineRule lineRule = new MonitorObjectLineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.addVMThreadInformation();
            }
        };
        this.addTag("3LKWAITNOTIFY", lineRule);
    }

    private void addRegMon() {
        MonitorObjectLineRule lineRule = new MonitorObjectLineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.addMonitorLockNameAndAddress();
            }
        };
        this.addTag("2LKREGMON", lineRule);
    }
}

