/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.j9.CorruptData;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class ImageModule
implements com.ibm.dtfj.image.ImageModule {
    private String _name;
    private Vector _sections = new Vector();
    private Vector _symbols = new Vector();
    private Properties _properties;
    private long _loadAddress;

    public ImageModule(String moduleName, Properties properties, Iterator sections, Iterator symbols, long loadAddress) {
        this._name = moduleName;
        while (sections.hasNext()) {
            this._sections.add(sections.next());
        }
        while (symbols.hasNext()) {
            this._symbols.add(symbols.next());
        }
        this._properties = properties;
        this._loadAddress = loadAddress;
    }

    @Override
    public String getName() throws CorruptDataException {
        return this._name;
    }

    @Override
    public Iterator getSections() {
        return this._sections.iterator();
    }

    @Override
    public Iterator getSymbols() {
        return this._symbols.iterator();
    }

    @Override
    public Properties getProperties() throws CorruptDataException {
        if (null == this._properties) {
            throw new CorruptDataException(new CorruptData("no properties available for module " + this.getName(), null));
        }
        return this._properties;
    }

    @Override
    public long getLoadAddress() throws DataUnavailable {
        String moduleName;
        if (this._loadAddress != 0L) {
            return this._loadAddress;
        }
        try {
            moduleName = this.getName();
        }
        catch (CorruptDataException e) {
            moduleName = "<module name not available>";
        }
        throw new DataUnavailable("Load address not available for module: " + moduleName);
    }
}

