/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer.utils;

import java.io.IOException;
import org.apache.xml.serializer.utils.Utils;

final class URI {
    private static final String RESERVED_CHARACTERS = ";/?:@&=+$,";
    private static final String MARK_CHARACTERS = "-_.!~*'() ";
    private static final String SCHEME_CHARACTERS = "+-.";
    private static final String USERINFO_CHARACTERS = ";:&=+$,";
    private String m_scheme = null;
    private String m_userinfo = null;
    private String m_host = null;
    private int m_port = -1;
    private String m_path = null;
    private String m_queryString = null;
    private String m_fragment = null;

    public URI() {
    }

    public URI(URI uRI) {
        this.initialize(uRI);
    }

    public URI(String string) throws MalformedURIException {
        this((URI)null, string);
    }

    public URI(URI uRI, String string) throws MalformedURIException {
        this.initialize(uRI, string);
    }

    public URI(String string, String string2) throws MalformedURIException {
        if (string == null || string.trim().length() == 0) {
            throw new MalformedURIException("Cannot construct URI with null/empty scheme!");
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new MalformedURIException("Cannot construct URI with null/empty scheme-specific part!");
        }
        this.setScheme(string);
        this.setPath(string2);
    }

    public URI(String string, String string2, String string3, String string4, String string5) throws MalformedURIException {
        this(string, null, string2, -1, string3, string4, string5);
    }

    public URI(String string, String string2, String string3, int n, String string4, String string5, String string6) throws MalformedURIException {
        if (string == null || string.trim().length() == 0) {
            throw new MalformedURIException(Utils.messages.createMessage("ER_SCHEME_REQUIRED", null));
        }
        if (string3 == null) {
            if (string2 != null) {
                throw new MalformedURIException(Utils.messages.createMessage("ER_NO_USERINFO_IF_NO_HOST", null));
            }
            if (n != -1) {
                throw new MalformedURIException(Utils.messages.createMessage("ER_NO_PORT_IF_NO_HOST", null));
            }
        }
        if (string4 != null) {
            if (string4.indexOf(63) != -1 && string5 != null) {
                throw new MalformedURIException(Utils.messages.createMessage("ER_NO_QUERY_STRING_IN_PATH", null));
            }
            if (string4.indexOf(35) != -1 && string6 != null) {
                throw new MalformedURIException(Utils.messages.createMessage("ER_NO_FRAGMENT_STRING_IN_PATH", null));
            }
        }
        this.setScheme(string);
        this.setHost(string3);
        this.setPort(n);
        this.setUserinfo(string2);
        this.setPath(string4);
        this.setQueryString(string5);
        this.setFragment(string6);
    }

    private void initialize(URI uRI) {
        this.m_scheme = uRI.getScheme();
        this.m_userinfo = uRI.getUserinfo();
        this.m_host = uRI.getHost();
        this.m_port = uRI.getPort();
        this.m_path = uRI.getPath();
        this.m_queryString = uRI.getQueryString();
        this.m_fragment = uRI.getFragment();
    }

    private void initialize(URI uRI, String string) throws MalformedURIException {
        if (uRI == null && (string == null || string.trim().length() == 0)) {
            throw new MalformedURIException(Utils.messages.createMessage("ER_CANNOT_INIT_URI_EMPTY_PARMS", null));
        }
        if (string == null || string.trim().length() == 0) {
            this.initialize(uRI);
            return;
        }
        String string2 = string.trim();
        int n = string2.length();
        int n2 = 0;
        int n3 = string2.indexOf(58);
        if (n3 < 0) {
            if (uRI == null) {
                throw new MalformedURIException(Utils.messages.createMessage("ER_NO_SCHEME_IN_URI", new Object[]{string2}));
            }
        } else {
            this.initializeScheme(string2);
            string2 = string2.substring(n3 + 1);
            n = string2.length();
        }
        if (n2 + 1 < n && string2.substring(n2).startsWith("//")) {
            int n4 = n2 += 2;
            char c = '\u0000';
            while (n2 < n && (c = string2.charAt(n2)) != '/' && c != '?' && c != '#') {
                ++n2;
            }
            if (n2 > n4) {
                this.initializeAuthority(string2.substring(n4, n2));
            } else {
                this.m_host = "";
            }
        }
        this.initializePath(string2.substring(n2));
        if (uRI != null) {
            int n5;
            if (this.m_path.length() == 0 && this.m_scheme == null && this.m_host == null) {
                this.m_scheme = uRI.getScheme();
                this.m_userinfo = uRI.getUserinfo();
                this.m_host = uRI.getHost();
                this.m_port = uRI.getPort();
                this.m_path = uRI.getPath();
                if (this.m_queryString == null) {
                    this.m_queryString = uRI.getQueryString();
                }
                return;
            }
            if (this.m_scheme == null) {
                this.m_scheme = uRI.getScheme();
            }
            if (this.m_host != null) {
                return;
            }
            this.m_userinfo = uRI.getUserinfo();
            this.m_host = uRI.getHost();
            this.m_port = uRI.getPort();
            if (this.m_path.length() > 0 && this.m_path.startsWith("/")) {
                return;
            }
            String string3 = new String();
            String string4 = uRI.getPath();
            if (string4 != null && (n5 = string4.lastIndexOf(47)) != -1) {
                string3 = string4.substring(0, n5 + 1);
            }
            string3 = string3.concat(this.m_path);
            n2 = -1;
            while ((n2 = string3.indexOf("/./")) != -1) {
                string3 = string3.substring(0, n2 + 1).concat(string3.substring(n2 + 3));
            }
            if (string3.endsWith("/.")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            n2 = -1;
            n5 = -1;
            String string5 = null;
            while ((n2 = string3.indexOf("/../")) > 0) {
                string5 = string3.substring(0, string3.indexOf("/../"));
                n5 = string5.lastIndexOf(47);
                if (n5 == -1 || string5.substring(n5++).equals("..")) continue;
                string3 = string3.substring(0, n5).concat(string3.substring(n2 + 4));
            }
            if (string3.endsWith("/..") && (n5 = (string5 = string3.substring(0, string3.length() - 3)).lastIndexOf(47)) != -1) {
                string3 = string3.substring(0, n5 + 1);
            }
            this.m_path = string3;
        }
    }

    private void initializeScheme(String string) throws MalformedURIException {
        int n;
        int n2 = string.length();
        String string2 = null;
        char c = '\u0000';
        for (n = 0; n < n2 && (c = string.charAt(n)) != ':' && c != '/' && c != '?' && c != '#'; ++n) {
        }
        string2 = string.substring(0, n);
        if (string2.length() == 0) {
            throw new MalformedURIException(Utils.messages.createMessage("ER_NO_SCHEME_INURI", null));
        }
        this.setScheme(string2);
    }

    private void initializeAuthority(String string) throws MalformedURIException {
        int n;
        int n2 = 0;
        int n3 = string.length();
        char c = '\u0000';
        String string2 = null;
        if (string.indexOf(64, n2) != -1) {
            for (n = 0; n < n3 && (c = string.charAt(n)) != '@'; ++n) {
            }
            string2 = string.substring(n2, n);
            ++n;
        }
        String string3 = null;
        n2 = n;
        while (n < n3 && (c = string.charAt(n)) != ':') {
            ++n;
        }
        string3 = string.substring(n2, n);
        int n4 = -1;
        if (string3.length() > 0 && c == ':') {
            n2 = ++n;
            while (n < n3) {
                ++n;
            }
            String string4 = string.substring(n2, n);
            if (string4.length() > 0) {
                for (int i = 0; i < string4.length(); ++i) {
                    if (URI.isDigit(string4.charAt(i))) continue;
                    throw new MalformedURIException(string4 + " is invalid. Port should only contain digits!");
                }
                try {
                    n4 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.setHost(string3);
        this.setPort(n4);
        this.setUserinfo(string2);
    }

    private void initializePath(String string) throws MalformedURIException {
        int n;
        if (string == null) {
            throw new MalformedURIException("Cannot initialize path from null string!");
        }
        int n2 = 0;
        int n3 = string.length();
        char c = '\u0000';
        for (n = 0; n < n3 && (c = string.charAt(n)) != '?' && c != '#'; ++n) {
            if (c == '%') {
                if (n + 2 < n3 && URI.isHex(string.charAt(n + 1)) && URI.isHex(string.charAt(n + 2))) continue;
                throw new MalformedURIException(Utils.messages.createMessage("ER_PATH_CONTAINS_INVALID_ESCAPE_SEQUENCE", null));
            }
            if (URI.isReservedCharacter(c) || URI.isUnreservedCharacter(c) || '\\' == c) continue;
            throw new MalformedURIException(Utils.messages.createMessage("ER_PATH_INVALID_CHAR", new Object[]{String.valueOf(c)}));
        }
        this.m_path = string.substring(n2, n);
        if (c == '?') {
            n2 = ++n;
            while (n < n3 && (c = string.charAt(n)) != '#') {
                if (c == '%') {
                    if (n + 2 >= n3 || !URI.isHex(string.charAt(n + 1)) || !URI.isHex(string.charAt(n + 2))) {
                        throw new MalformedURIException("Query string contains invalid escape sequence!");
                    }
                } else if (!URI.isReservedCharacter(c) && !URI.isUnreservedCharacter(c)) {
                    throw new MalformedURIException("Query string contains invalid character:" + c);
                }
                ++n;
            }
            this.m_queryString = string.substring(n2, n);
        }
        if (c == '#') {
            n2 = ++n;
            while (n < n3) {
                c = string.charAt(n);
                if (c == '%') {
                    if (n + 2 >= n3 || !URI.isHex(string.charAt(n + 1)) || !URI.isHex(string.charAt(n + 2))) {
                        throw new MalformedURIException("Fragment contains invalid escape sequence!");
                    }
                } else if (!URI.isReservedCharacter(c) && !URI.isUnreservedCharacter(c)) {
                    throw new MalformedURIException("Fragment contains invalid character:" + c);
                }
                ++n;
            }
            this.m_fragment = string.substring(n2, n);
        }
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public String getSchemeSpecificPart() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_userinfo != null || this.m_host != null || this.m_port != -1) {
            stringBuffer.append("//");
        }
        if (this.m_userinfo != null) {
            stringBuffer.append(this.m_userinfo);
            stringBuffer.append('@');
        }
        if (this.m_host != null) {
            stringBuffer.append(this.m_host);
        }
        if (this.m_port != -1) {
            stringBuffer.append(':');
            stringBuffer.append(this.m_port);
        }
        if (this.m_path != null) {
            stringBuffer.append(this.m_path);
        }
        if (this.m_queryString != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.m_queryString);
        }
        if (this.m_fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.m_fragment);
        }
        return stringBuffer.toString();
    }

    public String getUserinfo() {
        return this.m_userinfo;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getPath(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(this.m_path);
        if (bl && this.m_queryString != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.m_queryString);
        }
        if (bl2 && this.m_fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.m_fragment);
        }
        return stringBuffer.toString();
    }

    public String getPath() {
        return this.m_path;
    }

    public String getQueryString() {
        return this.m_queryString;
    }

    public String getFragment() {
        return this.m_fragment;
    }

    public void setScheme(String string) throws MalformedURIException {
        if (string == null) {
            throw new MalformedURIException(Utils.messages.createMessage("ER_SCHEME_FROM_NULL_STRING", null));
        }
        if (!URI.isConformantSchemeName(string)) {
            throw new MalformedURIException(Utils.messages.createMessage("ER_SCHEME_NOT_CONFORMANT", null));
        }
        this.m_scheme = string.toLowerCase();
    }

    public void setUserinfo(String string) throws MalformedURIException {
        if (string == null) {
            this.m_userinfo = null;
        } else {
            if (this.m_host == null) {
                throw new MalformedURIException("Userinfo cannot be set when host is null!");
            }
            int n = string.length();
            char c = '\u0000';
            for (int i = 0; i < n; ++i) {
                c = string.charAt(i);
                if (c == '%') {
                    if (i + 2 < n && URI.isHex(string.charAt(i + 1)) && URI.isHex(string.charAt(i + 2))) continue;
                    throw new MalformedURIException("Userinfo contains invalid escape sequence!");
                }
                if (URI.isUnreservedCharacter(c) || USERINFO_CHARACTERS.indexOf(c) != -1) continue;
                throw new MalformedURIException("Userinfo contains invalid character:" + c);
            }
        }
        this.m_userinfo = string;
    }

    public void setHost(String string) throws MalformedURIException {
        if (string == null || string.trim().length() == 0) {
            this.m_host = string;
            this.m_userinfo = null;
            this.m_port = -1;
        } else if (!URI.isWellFormedAddress(string)) {
            throw new MalformedURIException(Utils.messages.createMessage("ER_HOST_ADDRESS_NOT_WELLFORMED", null));
        }
        this.m_host = string;
    }

    public void setPort(int n) throws MalformedURIException {
        if (n >= 0 && n <= 65535) {
            if (this.m_host == null) {
                throw new MalformedURIException(Utils.messages.createMessage("ER_PORT_WHEN_HOST_NULL", null));
            }
        } else if (n != -1) {
            throw new MalformedURIException(Utils.messages.createMessage("ER_INVALID_PORT", null));
        }
        this.m_port = n;
    }

    public void setPath(String string) throws MalformedURIException {
        if (string == null) {
            this.m_path = null;
            this.m_queryString = null;
            this.m_fragment = null;
        } else {
            this.initializePath(string);
        }
    }

    public void appendPath(String string) throws MalformedURIException {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        if (!URI.isURIString(string)) {
            throw new MalformedURIException(Utils.messages.createMessage("ER_PATH_INVALID_CHAR", new Object[]{string}));
        }
        this.m_path = this.m_path == null || this.m_path.trim().length() == 0 ? (string.startsWith("/") ? string : "/" + string) : (this.m_path.endsWith("/") ? (string.startsWith("/") ? this.m_path.concat(string.substring(1)) : this.m_path.concat(string)) : (string.startsWith("/") ? this.m_path.concat(string) : this.m_path.concat("/" + string)));
    }

    public void setQueryString(String string) throws MalformedURIException {
        if (string == null) {
            this.m_queryString = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURIException("Query string can only be set for a generic URI!");
            }
            if (this.getPath() == null) {
                throw new MalformedURIException("Query string cannot be set when path is null!");
            }
            if (!URI.isURIString(string)) {
                throw new MalformedURIException("Query string contains invalid character!");
            }
            this.m_queryString = string;
        }
    }

    public void setFragment(String string) throws MalformedURIException {
        if (string == null) {
            this.m_fragment = null;
        } else {
            if (!this.isGenericURI()) {
                throw new MalformedURIException(Utils.messages.createMessage("ER_FRAG_FOR_GENERIC_URI", null));
            }
            if (this.getPath() == null) {
                throw new MalformedURIException(Utils.messages.createMessage("ER_FRAG_WHEN_PATH_NULL", null));
            }
            if (!URI.isURIString(string)) {
                throw new MalformedURIException(Utils.messages.createMessage("ER_FRAG_INVALID_CHAR", null));
            }
            this.m_fragment = string;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof URI) {
            URI uRI = (URI)object;
            if ((this.m_scheme == null && uRI.m_scheme == null || this.m_scheme != null && uRI.m_scheme != null && this.m_scheme.equals(uRI.m_scheme)) && (this.m_userinfo == null && uRI.m_userinfo == null || this.m_userinfo != null && uRI.m_userinfo != null && this.m_userinfo.equals(uRI.m_userinfo)) && (this.m_host == null && uRI.m_host == null || this.m_host != null && uRI.m_host != null && this.m_host.equals(uRI.m_host)) && this.m_port == uRI.m_port && (this.m_path == null && uRI.m_path == null || this.m_path != null && uRI.m_path != null && this.m_path.equals(uRI.m_path)) && (this.m_queryString == null && uRI.m_queryString == null || this.m_queryString != null && uRI.m_queryString != null && this.m_queryString.equals(uRI.m_queryString)) && (this.m_fragment == null && uRI.m_fragment == null || this.m_fragment != null && uRI.m_fragment != null && this.m_fragment.equals(uRI.m_fragment))) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_scheme != null) {
            stringBuffer.append(this.m_scheme);
            stringBuffer.append(':');
        }
        stringBuffer.append(this.getSchemeSpecificPart());
        return stringBuffer.toString();
    }

    public boolean isGenericURI() {
        return this.m_host != null;
    }

    public static boolean isConformantSchemeName(String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        if (!URI.isAlpha(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (URI.isAlphanum(c) || SCHEME_CHARACTERS.indexOf(c) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isWellFormedAddress(String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        int n = string2.length();
        if (n == 0 || n > 255) {
            return false;
        }
        if (string2.startsWith(".") || string2.startsWith("-")) {
            return false;
        }
        int n2 = string2.lastIndexOf(46);
        if (string2.endsWith(".")) {
            n2 = string2.substring(0, n2).lastIndexOf(46);
        }
        if (n2 + 1 < n && URI.isDigit(string.charAt(n2 + 1))) {
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c == '.') {
                    if (!URI.isDigit(string2.charAt(i - 1)) || i + 1 < n && !URI.isDigit(string2.charAt(i + 1))) {
                        return false;
                    }
                    ++n3;
                    continue;
                }
                if (URI.isDigit(c)) continue;
                return false;
            }
            if (n3 != 3) {
                return false;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c == '.') {
                    if (!URI.isAlphanum(string2.charAt(i - 1))) {
                        return false;
                    }
                    if (i + 1 >= n || URI.isAlphanum(string2.charAt(i + 1))) continue;
                    return false;
                }
                if (URI.isAlphanum(c) || c == '-') continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHex(char c) {
        return URI.isDigit(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isAlphanum(char c) {
        return URI.isAlpha(c) || URI.isDigit(c);
    }

    private static boolean isReservedCharacter(char c) {
        return RESERVED_CHARACTERS.indexOf(c) != -1;
    }

    private static boolean isUnreservedCharacter(char c) {
        return URI.isAlphanum(c) || MARK_CHARACTERS.indexOf(c) != -1;
    }

    private static boolean isURIString(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        char c = '\u0000';
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (c == '%') {
                if (i + 2 >= n || !URI.isHex(string.charAt(i + 1)) || !URI.isHex(string.charAt(i + 2))) {
                    return false;
                }
                i += 2;
                continue;
            }
            if (URI.isReservedCharacter(c) || URI.isUnreservedCharacter(c)) continue;
            return false;
        }
        return true;
    }

    public static class MalformedURIException
    extends IOException {
        private static final long serialVersionUID = -7137112272984045853L;

        public MalformedURIException() {
        }

        public MalformedURIException(String string) {
            super(string);
        }
    }
}

