/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers.partialeval;

import com.ibm.xylem.Instruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.NaNInstruction;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;

public class NaNEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction instruction, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        NaNInstruction naNInstruction = (NaNInstruction)instruction;
        Instruction instruction2 = naNInstruction.getOperand();
        partialInformationCollector.partiallyEvaluate(instruction2, letChainManager);
        Object object = NaNEvaluator.extractLiteralValue(partialInformationCollector, instruction2, letChainManager);
        if (object != null) {
            if (object instanceof Double) {
                return new PartialEvaluationResult(LiteralInstruction.booleanLiteral(Double.isNaN((Double)object)));
            }
            if (object instanceof Float) {
                return new PartialEvaluationResult(LiteralInstruction.booleanLiteral(Float.isNaN(((Float)object).floatValue())));
            }
        }
        return PartialEvaluationResult.s_emptyResult;
    }
}

