/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.bcel.generic;

import com.ibm.xtq.bcel.generic.ClassGenException;
import com.ibm.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xtq.bcel.generic.ConstantPushInstruction;
import com.ibm.xtq.bcel.generic.Instruction;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xtq.bcel.generic.TypeConstants;
import com.ibm.xtq.bcel.generic.TypedInstruction;
import com.ibm.xtq.bcel.generic.Visitor;

public class DCONST
extends Instruction
implements ConstantPushInstruction,
TypedInstruction {
    private double value;

    DCONST() {
    }

    public DCONST(double f) {
        super((short)14, (short)1);
        if (f == 0.0) {
            this.opcode = (short)14;
        } else if (f == 1.0) {
            this.opcode = (short)15;
        } else {
            throw new ClassGenException("DCONST can be used only for 0.0 and 1.0: " + f);
        }
        this.value = f;
    }

    public Number getValue() {
        return new Double(this.value);
    }

    public Type getType(ConstantPoolGen cp) {
        return TypeConstants.DOUBLE;
    }

    public void accept(Visitor v) {
        v.visitPushInstruction(this);
        v.visitStackProducer(this);
        v.visitTypedInstruction(this);
        v.visitConstantPushInstruction(this);
        v.visitDCONST(this);
    }
}

