/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.ast.nodes;

import com.ibm.xtq.ast.XPath20Exception;
import com.ibm.xtq.ast.XPath20Utilities;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.SimpleNode;
import com.ibm.xtq.ast.parsers.xpath.Token;
import com.ibm.xtq.ast.parsers.xpath.Utilities;
import com.ibm.xtq.ast.parsers.xpath.XPathTreeConstants;
import com.ibm.xtq.ast.parsers.xpath.XPathVisitor;
import com.ibm.xtq.ast.parsers.xslt.ASTBuildingContext;
import com.ibm.xtq.common.utils.Assert;

public class OperatorExpr
extends Expr {
    public static final short COMMA_SEQUENCE = 0;
    public static final short UNION_COMBINE = 1;
    public static final short INTERSECT_COMBINE = 2;
    public static final short EXCEPT_COMBINE = 3;
    public static final short PLUS_ADDITIVE = 4;
    public static final short MINUS_ADDITIVE = 5;
    public static final short TO = 6;
    public static final short EQUAL_VALUE_COMPARISON = 7;
    public static final short NOTEQUAL_VALUE_COMPARISON = 8;
    public static final short LESSTHAN_VALUE_COMPARISON = 9;
    public static final short LESSOREQUALTHAN_VALUE_COMPARISON = 10;
    public static final short GREATTHAN_VALUE_COMPARISON = 11;
    public static final short GREATOREQUALTHAN_VALUE_COMPARISON = 12;
    public static final short EQUAL_GENERAL_COMPARISON = 13;
    public static final short NOTEQUAL_GENERAL_COMPARISON = 14;
    public static final short LESSTHAN_GENERAL_COMPARISON = 15;
    public static final short LESSOREQUALTHAN_GENERAL_COMPARISON = 16;
    public static final short GREATTHAN_GENERAL_COMPARISON = 17;
    public static final short GREATOREQUALTHAN_GENERAL_COMPARISON = 18;
    public static final short IS_NODE_COMPARISON = 19;
    public static final short IS_NOT_NODE_COMPARISON = 20;
    public static final short EARLIERTHAN_ORDER_COMPARISON = 21;
    public static final short LATERTHAN_ORDER_COMPARISON = 22;
    public static final short AND_LOGICAL = 23;
    public static final short OR_LOGICAL = 24;
    public static final short PLUS_UNARY = 25;
    public static final short MINUS_UNARY = 26;
    public static final short SLASH_STEP = 27;
    public static final short SLASH_SLASH_STEP = 28;
    public static final short COMMA = 29;
    public static final short MULT_PRODUCT = 30;
    public static final short MULT_DIV = 31;
    public static final short MULT_IDIV = 32;
    public static final short MULT_MOD = 33;
    private static final String[] OPTYPE2STRING = new String[]{",", "|", "intersect", "except", "+", "-", "to", "eq", "ne", "lt", "le", "gt", "ge", "=", "!=", "<", "<=", ">", ">=", "is", "isnot", "<<", ">>", "and", "or", "+", "-", "/", "//", ",", "*", "div", "idiv", "mod"};
    private static final boolean[] SPACE_NEEDED = new boolean[]{false, false, true, true, false, false, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, false, false, true, true, false, false, false, false, false, false, true, true, true};
    private static final short[] OPERATOR_PRECEDENCE = new short[]{1, 13, 14, 14, 10, 10, 9, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 3, 2, 12, 12, 15, 15, 1, 11, 11, 11, 11};
    private short _opType;

    public OperatorExpr(int n) {
        super(n);
    }

    public OperatorExpr(int n, OperatorExpr operatorExpr) {
        super(n, operatorExpr);
        this._opType = operatorExpr._opType;
    }

    protected final boolean isSpaceNeeded() {
        return SPACE_NEEDED[this._opType];
    }

    @Override
    protected short getOperatorPrecedence() {
        return OPERATOR_PRECEDENCE[this._opType];
    }

    public boolean isUnary() {
        return this._opType == 25 || this._opType == 26;
    }

    @Override
    public boolean canBeFlatten(ASTBuildingContext aSTBuildingContext, Expr expr) {
        if (expr.getId() == 165 && this._opType == 29 && ((OperatorExpr)expr).getOperatorType() == 29) {
            return true;
        }
        boolean bl = aSTBuildingContext.getExpressionFactory().flatten();
        return bl && expr.getId() == this.getId() && ((OperatorExpr)expr).getOperatorType() == this._opType;
    }

    public String getOperatorChar() {
        return OPTYPE2STRING[this._opType];
    }

    @Override
    public void getXQueryString(StringBuffer stringBuffer, boolean bl, String string) {
        if (this.jjtGetParent() == null && this.getOperandCount() == 0) {
            stringBuffer.append("()");
        } else {
            boolean bl2 = this.lowerPrecedence();
            if (bl2) {
                stringBuffer.append('(');
            }
            int n = this.getOperandCount();
            String string2 = this.getOperatorChar();
            if (this._opType == 26 || this._opType == 25) {
                stringBuffer.append(string2);
            }
            for (int i = 0; i < n; ++i) {
                Expr expr = this.getOperand(i);
                if (null == expr) continue;
                expr.getXQueryString(stringBuffer, bl, string);
                if (i >= n - 1) continue;
                if (this.isSpaceNeeded()) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(string2);
                if (!this.isSpaceNeeded()) continue;
                stringBuffer.append(' ');
            }
            if (bl2) {
                stringBuffer.append(')');
            }
        }
    }

    @Override
    public boolean isRootOnSelfNode() {
        return this.getOperandCount() == 1 && this.getOperand(0).isRootOnSelfNode();
    }

    protected Expr getLastOperand() {
        int n = this.jjtGetNumChildren();
        return (Expr)(n == 0 ? null : this.jjtGetChild(n - 1));
    }

    public void setOpType(short s) {
        this._opType = s;
    }

    public Expr addOperand(ASTBuildingContext aSTBuildingContext, Expr expr) throws XPath20Exception {
        expr = XPath20Utilities.parentless(expr);
        super.jjtAppendChild(aSTBuildingContext, expr);
        return expr;
    }

    public Expr insertOperand(int n, Expr expr) {
        expr = XPath20Utilities.parentless(expr);
        super.jjtInsertChild(expr, n);
        return expr;
    }

    public Expr replaceOperand(ASTBuildingContext aSTBuildingContext, int n, Expr expr) throws XPath20Exception {
        expr = XPath20Utilities.parentless(expr);
        Expr expr2 = this.getOperand(n);
        expr2.jjtSetParent(null);
        super.jjtAddChild(aSTBuildingContext, expr, n);
        return expr;
    }

    public void append(ASTBuildingContext aSTBuildingContext, OperatorExpr operatorExpr) throws XPath20Exception {
        if (operatorExpr.getId() == this.getId() && operatorExpr.getOperatorType() == this._opType) {
            int n = operatorExpr.getOperandCount();
            for (int i = 0; i < n; ++i) {
                this.addOperand(aSTBuildingContext, operatorExpr.getOperand(i));
            }
        } else {
            throw new XPath20Exception("ERR_SYSTEM", "Operator expressions do not match with the type.");
        }
    }

    public Expr getOperand(int n) {
        Node node = this.jjtGetChild(n);
        try {
            return (Expr)node;
        }
        catch (ClassCastException classCastException) {
            Assert._assert(true, "\nYikes! Node can't be cast to Expr: " + node.getClass().getName());
            return null;
        }
    }

    public int getOperandCount() {
        return this.jjtGetNumChildren();
    }

    public short getOperatorType() {
        return this._opType;
    }

    public void removeOperand(Expr expr) throws XPath20Exception {
        super.jjtRemoveChild(expr);
    }

    @Override
    public void processToken(ASTBuildingContext aSTBuildingContext, Token token) {
        if (this.id != 40) {
            this._opType = Utilities.getOpType(token.image);
        }
    }

    @Override
    public void processValue(ASTBuildingContext aSTBuildingContext, String string) {
        if (this.id != 40) {
            this._opType = Utilities.getOpType(string);
        }
    }

    @Override
    public void jjtAddChild(ASTBuildingContext aSTBuildingContext, Node node, int n) {
        if (node.getId() == 70) {
            this._opType = (short)26;
        } else if (node.getId() == 71) {
            this._opType = (short)25;
        } else {
            SimpleNode simpleNode = (SimpleNode)node;
            if (simpleNode.canBeReduced() || this._opType == 29 && simpleNode.getId() == 40) {
                if (node.jjtGetNumChildren() == 1 && this.canBeFlatten(aSTBuildingContext, (Expr)node.jjtGetChild(0))) {
                    this.jjtInsertNodeChildren(aSTBuildingContext, node.jjtGetChild(0), 0);
                } else {
                    this.jjtInsertNodeChildren(aSTBuildingContext, node, 0);
                }
            } else {
                if (!(node instanceof Expr)) {
                    Assert._assert(true, "Child not good for inserting into operator " + this._opType + ", child is " + XPathTreeConstants.jjtNodeName[node.getId()]);
                }
                this.jjtInsertChild(node, 0);
            }
        }
    }

    private boolean isComparisonType() {
        switch (this.getOpType()) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void jjtInsertNodeChildren(ASTBuildingContext aSTBuildingContext, Node node, int n) throws IndexOutOfBoundsException {
        int n2 = node.jjtGetNumChildren();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                String string;
                Node node2 = node.jjtGetChild(i);
                if (node2 instanceof OperatorExpr && !(string = aSTBuildingContext.getExpressionFactory().getLanguage()).equals("XPath1") && !string.equals("XSLT1") && this.isComparisonType() && ((OperatorExpr)node2).isComparisonType()) {
                    throw new XPath20Exception("ERR_MULT_COMPARISON");
                }
                node2.jjtSetParent(this);
                Assert._assert(node2 instanceof Expr, this.toString());
                this.jjtInsertChild(node2, n + i);
            }
        }
    }

    @Override
    public boolean canBeReduced() {
        return !this.isUnary() && this.getOperandCount() == 1 && this._opType != 28;
    }

    @Override
    public Object jjtAccept(XPathVisitor xPathVisitor, Object object) {
        return xPathVisitor.visit(this, null);
    }

    public short getOpType() {
        return this._opType;
    }
}

