/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.ParsedEntity;

public final class UTF8Support {
    private static final int[] fgMultiByteLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 3, 4, 0};
    private static final int[] fgFirstByteValueMask = new int[]{0, 0, 31, 15, 7};

    public static CharConversionError convertCharsToBytes(char[] cArray, int n, int n2, byte[][] byArray, int[] nArray) {
        int n3;
        int n4;
        byte[] byArray2 = byArray[0];
        int n5 = nArray[0];
        int n6 = byArray2.length;
        if (nArray[1] == -1) {
            n4 = n6 - n5;
            int n7 = n2 - n <= n4 ? n2 : n + n4;
            while (n < n7) {
                n3 = cArray[n];
                if (n3 >= 128) break;
                ++n;
                byArray2[n5++] = (byte)n3;
            }
            if (n == n2) {
                nArray[0] = n5;
                return null;
            }
        } else {
            n3 = nArray[1];
            if (n == n2) {
                nArray[0] = n5;
                nArray[1] = n;
                return CharConversionError.missingSecondHalfOfSurrogatePair();
            }
            nArray[1] = -1;
            if ((n4 = cArray[n++]) < 56320 || n4 >= 57344) {
                nArray[0] = n5;
                nArray[1] = n - 1;
                return CharConversionError.invalidSecondHalfOfSurrogatePair();
            }
            n3 = 65536 + (n3 - 55296 << 10) + (n4 - 56320);
            if (n5 + 4 > n6) {
                byArray2 = UTF8Support.resize(byArray2);
                byArray[0] = byArray2;
                n6 <<= 1;
            }
            byArray2[n5] = (byte)(0xF0 | n3 >> 18);
            byArray2[n5 + 1] = (byte)(0x80 | 0x3F & n3 >> 12);
            byArray2[n5 + 2] = (byte)(0x80 | 0x3F & n3 >> 6);
            byArray2[n5 + 3] = (byte)(0x80 | 0x3F & n3);
            n5 += 4;
        }
        while (n < n2) {
            if ((n3 = cArray[n++]) < 128) {
                if (n5 == n6) {
                    byArray2 = UTF8Support.resize(byArray2);
                    byArray[0] = byArray2;
                    n6 <<= 1;
                }
                byArray2[n5++] = (byte)n3;
                continue;
            }
            if (n3 < 2048) {
                if (n5 + 2 > n6) {
                    byArray2 = UTF8Support.resize(byArray2);
                    byArray[0] = byArray2;
                    n6 <<= 1;
                }
                byArray2[n5] = (byte)(0xC0 | n3 >> 6);
                byArray2[n5 + 1] = (byte)(0x80 | 0x3F & n3);
                n5 += 2;
                continue;
            }
            if (n3 < 55296 || n3 >= 57344) {
                if (n5 + 3 > n6) {
                    byArray2 = UTF8Support.resize(byArray2);
                    byArray[0] = byArray2;
                    n6 <<= 1;
                }
                byArray2[n5] = (byte)(0xE0 | n3 >> 12);
                byArray2[n5 + 1] = (byte)(0x80 | 0x3F & n3 >> 6);
                byArray2[n5 + 2] = (byte)(0x80 | 0x3F & n3);
                n5 += 3;
                continue;
            }
            if (n3 < 56320) {
                if (n == n2) {
                    nArray[1] = n3;
                    break;
                }
                n4 = cArray[n];
                if (n4 >= 56320 && n4 < 57344) {
                    ++n;
                } else {
                    nArray[0] = n5;
                    nArray[1] = n - 1;
                    return CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                n3 = 65536 + (n3 - 55296 << 10) + (n4 - 56320);
                if (n5 + 4 > n6) {
                    byArray2 = UTF8Support.resize(byArray2);
                    byArray[0] = byArray2;
                    n6 <<= 1;
                }
                byArray2[n5] = (byte)(0xF0 | n3 >> 18);
                byArray2[n5 + 1] = (byte)(0x80 | 0x3F & n3 >> 12);
                byArray2[n5 + 2] = (byte)(0x80 | 0x3F & n3 >> 6);
                byArray2[n5 + 3] = (byte)(0x80 | 0x3F & n3);
                n5 += 4;
                continue;
            }
            nArray[0] = n5;
            nArray[1] = n - 1;
            return CharConversionError.invalidFirstHalfOfSurrogatePair();
        }
        nArray[0] = n5;
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static CharConversionError convertCharsToBytes(char[] var0, int var1_1, int var2_2, byte[] var3_3, int var4_4, int var5_5, int[] var6_6) {
        var7_7 = var5_5 - var4_4;
        var8_8 = var2_2 - var1_1 <= var7_7 ? var2_2 : var1_1 + var7_7;
        while (var1_1 < var8_8) {
            var9_9 = var0[var1_1];
            if (var9_9 >= 128) break;
            ++var1_1;
            var3_3[var4_4++] = (byte)var9_9;
        }
        if (var1_1 != var2_2) ** GOTO lbl65
        var6_6[0] = var1_1;
        var6_6[1] = var4_4;
        return null;
lbl-1000:
        // 1 sources

        {
            var9_9 = var0[var1_1];
            if (var9_9 < 128) {
                if (var4_4 == var5_5) {
                    var6_6[0] = var1_1;
                    var6_6[1] = var4_4;
                    return null;
                }
                ++var1_1;
                var3_3[var4_4++] = (byte)var9_9;
                continue;
            }
            if (var9_9 < 2048) {
                if (var4_4 + 2 > var5_5) {
                    var6_6[0] = var1_1;
                    var6_6[1] = var4_4;
                    return null;
                }
                ++var1_1;
                var3_3[var4_4] = (byte)(192 | var9_9 >> 6);
                var3_3[var4_4 + 1] = (byte)(128 | 63 & var9_9);
                var4_4 += 2;
                continue;
            }
            if (var9_9 < 55296 || var9_9 >= 57344) {
                if (var4_4 + 3 > var5_5) {
                    var6_6[0] = var1_1;
                    var6_6[1] = var4_4;
                    return null;
                }
                ++var1_1;
                var3_3[var4_4] = (byte)(224 | var9_9 >> 12);
                var3_3[var4_4 + 1] = (byte)(128 | 63 & var9_9 >> 6);
                var3_3[var4_4 + 2] = (byte)(128 | 63 & var9_9);
                var4_4 += 3;
                continue;
            }
            if (var9_9 < 56320) {
                if (++var1_1 == var2_2 || var4_4 + 4 > var5_5) {
                    var6_6[0] = var1_1 - 1;
                    var6_6[1] = var4_4;
                    return null;
                }
                var10_10 = var0[var1_1];
                if (var10_10 >= '\udc00' && var10_10 < '\ue000') {
                    ++var1_1;
                } else {
                    var6_6[0] = var1_1 - 1;
                    var6_6[1] = var4_4;
                    return CharConversionError.invalidSecondHalfOfSurrogatePair();
                }
                var9_9 = 65536 + (var9_9 - 55296 << 10) + (var10_10 - 56320);
                var3_3[var4_4] = (byte)(240 | var9_9 >> 18);
                var3_3[var4_4 + 1] = (byte)(128 | 63 & var9_9 >> 12);
                var3_3[var4_4 + 2] = (byte)(128 | 63 & var9_9 >> 6);
                var3_3[var4_4 + 3] = (byte)(128 | 63 & var9_9);
                var4_4 += 4;
                continue;
            }
            var6_6[0] = var1_1;
            var6_6[1] = var4_4;
            return CharConversionError.invalidFirstHalfOfSurrogatePair();
lbl65:
            // 5 sources

            ** while (var1_1 < var2_2)
        }
lbl66:
        // 1 sources

        var6_6[0] = var1_1;
        var6_6[1] = var4_4;
        return null;
    }

    public static int encodeCharacter(int n, byte[][] byArray, int n2) {
        byte[] byArray2 = byArray[0];
        int n3 = byArray2.length;
        if (n < 128) {
            if (n2 == n3) {
                byArray2 = UTF8Support.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n2] = (byte)n;
            return n2 + 1;
        }
        if (n < 2048) {
            if (n2 + 2 > n3) {
                byArray2 = UTF8Support.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n2] = (byte)(0xC0 | n >> 6);
            byArray2[n2 + 1] = (byte)(0x80 | 0x3F & n);
            return n2 + 2;
        }
        if (n < 65536) {
            if (n2 + 3 > n3) {
                byArray2 = UTF8Support.resize(byArray2);
                byArray[0] = byArray2;
            }
            byArray2[n2] = (byte)(0xE0 | n >> 12);
            byArray2[n2 + 1] = (byte)(0x80 | 0x3F & n >> 6);
            byArray2[n2 + 2] = (byte)(0x80 | 0x3F & n);
            return n2 + 3;
        }
        if (n2 + 4 > n3) {
            byArray2 = UTF8Support.resize(byArray2);
            byArray[0] = byArray2;
        }
        byArray2[n2] = (byte)(0xF0 | n >> 18);
        byArray2[n2 + 1] = (byte)(0x80 | 0x3F & n >> 12);
        byArray2[n2 + 2] = (byte)(0x80 | 0x3F & n >> 6);
        byArray2[n2 + 3] = (byte)(0x80 | 0x3F & n);
        return n2 + 4;
    }

    public static CharConversionError convertBytesToChars(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, char[][] cArray, int[] nArray) {
        byte[] byArray = dataBuffer.bytes;
        int n3 = n;
        char[] cArray2 = cArray[0];
        int n4 = nArray[0];
        if (dataBuffer2 == null && n2 - n3 <= cArray2.length - n4) {
            while (n3 < n2 && byArray[n3] >= 0) {
                cArray2[n4++] = (char)byArray[n3++];
            }
            if (n3 == n2) {
                nArray[0] = n4;
                return null;
            }
            n = n3;
            nArray[0] = n4;
        }
        return UTF8Support.convertBytesToChars2(dataBuffer, dataBuffer2, n, n2, cArray, nArray);
    }

    private static CharConversionError convertBytesToChars2(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, char[][] cArray, int[] nArray) {
        int n3;
        DataBuffer dataBuffer3 = dataBuffer;
        byte[] byArray = dataBuffer3.bytes;
        int n4 = n;
        char[] cArray2 = cArray[0];
        int n5 = nArray[0];
        int n6 = cArray2.length;
        int n7 = n6 - n5;
        int n8 = 0;
        if (dataBuffer2 == null) {
            dataBuffer2 = dataBuffer3;
            n3 = n2;
        } else {
            n3 = dataBuffer2 == dataBuffer3 ? n2 : dataBuffer3.endOffset;
        }
        while (true) {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13 = n3 - n4 <= (n7 = n6 - n5) ? n3 : n4 + n7;
            while (n4 < n13) {
                n8 = byArray[n4];
                if (n8 < 0) break;
                ++n4;
                cArray2[n5++] = (char)n8;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return null;
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
                continue;
            }
            if (n5 == n6) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n6 <<= 1;
                continue;
            }
            if (n4 == n13) continue;
            if ((n12 = fgMultiByteLength[(n8 = byArray[n4++] & 0xFF) >> 3]) == 0) {
                return UTF8Support.charConversionFailure(1, n8, 0, 0, 0);
            }
            int n14 = n8 & fgFirstByteValueMask[n12];
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n11 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(2, n8, n11, 0, 0);
            }
            if (n12 == 2) {
                n14 = (n14 << 6) + (0x3F & n11);
                cArray2[n5++] = (char)n14;
                continue;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n10 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(3, n8, n11, n10, 0);
            }
            if (n12 == 3) {
                if ((n14 = (n14 << 12) + ((0x3F & n11) << 6) + (0x3F & n10)) >= 55296 && n14 < 57344) {
                    return UTF8Support.charConversionFailure(1, n8, n11, n10, 0);
                }
                cArray2[n5++] = (char)n14;
                continue;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n9 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(4, n8, n11, n10, n9);
            }
            int n15 = (n14 << 8) + ((0x30 & n11) << 2);
            if (n15 > 1024 || n15 == 0) {
                return CharConversionError.invalidUTF8SurrogateEncoding();
            }
            int n16 = n15 - 64;
            int n17 = 55296 + n16 + ((0xF & n11) << 2) + ((0x30 & n10) >> 4);
            int n18 = 56320 + ((0xF & n10) << 6) + (0x3F & n9);
            cArray2[n5] = (char)n17;
            if (n5 + 1 == n6) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n6 <<= 1;
            }
            cArray2[n5 + 1] = (char)n18;
            n5 += 2;
        }
    }

    public static CharConversionError normalizeBytesToChars(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, char[][] cArray, int[] nArray, boolean bl) {
        block5: {
            byte[] byArray = dataBuffer.bytes;
            int n3 = n;
            char[] cArray2 = cArray[0];
            int n4 = nArray[0];
            if (dataBuffer2 == null && n2 - n3 <= cArray2.length - n4) {
                while (n3 < n2) {
                    if (byArray[n3] != 13) {
                        if (byArray[n3] >= 0) {
                            cArray2[n4++] = (char)byArray[n3++];
                            continue;
                        }
                        break block5;
                    }
                    cArray2[n4++] = 10;
                    if (++n3 < n2 && byArray[n3] == 10) {
                        ++n3;
                        continue;
                    }
                    if (!bl || n3 + 1 >= n2 || (byArray[n3] & 0xFF) != 194 || (byArray[n3 + 1] & 0xFF) != 133) continue;
                    n3 += 2;
                }
                nArray[0] = n4;
                return null;
            }
        }
        return UTF8Support.normalizeBytesToChars2(dataBuffer, dataBuffer2, n, n2, cArray, nArray, bl);
    }

    private static CharConversionError normalizeBytesToChars2(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, char[][] cArray, int[] nArray, boolean bl) {
        int n3;
        DataBuffer dataBuffer3 = dataBuffer;
        byte[] byArray = dataBuffer3.bytes;
        int n4 = n;
        char[] cArray2 = cArray[0];
        int n5 = nArray[0];
        int n6 = cArray2.length;
        boolean bl2 = false;
        int n7 = 0;
        if (dataBuffer2 == null) {
            dataBuffer2 = dataBuffer3;
            n3 = n2;
        } else {
            n3 = dataBuffer2 == dataBuffer3 ? n2 : dataBuffer3.endOffset;
        }
        while (true) {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13 = n3 - n4 <= (n12 = n6 - n5) ? n3 : n4 + n12;
            while (n4 < n13) {
                n7 = byArray[n4];
                if (!bl2) {
                    if (n7 < 0) break;
                    ++n4;
                    if (n7 != 13) {
                        cArray2[n5++] = (char)n7;
                        continue;
                    }
                    bl2 = true;
                    cArray2[n5++] = 10;
                    continue;
                }
                bl2 = false;
                if (n7 == 10) {
                    ++n4;
                    continue;
                }
                if (n7 >= 0) {
                    ++n4;
                    if (n7 == 13) {
                        n7 = 10;
                        bl2 = true;
                    }
                    cArray2[n5++] = (char)n7;
                    continue;
                }
                bl2 = bl;
                break;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return null;
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
                continue;
            }
            if (n5 == n6) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n6 <<= 1;
                continue;
            }
            if (n4 == n13) continue;
            if ((n11 = fgMultiByteLength[(n7 = byArray[n4++] & 0xFF) >> 3]) == 0) {
                return UTF8Support.charConversionFailure(1, n7, 0, 0, 0);
            }
            int n14 = n7 & fgFirstByteValueMask[n11];
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n10 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(2, n7, n10, 0, 0);
            }
            if (n11 == 2) {
                n14 = (n14 << 6) + (0x3F & n10);
                if (bl && n14 == 133) {
                    if (!bl2) {
                        cArray2[n5++] = 10;
                    }
                } else {
                    cArray2[n5++] = (char)n14;
                }
                bl2 = false;
                continue;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n9 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(3, n7, n10, n9, 0);
            }
            if (n11 == 3) {
                if ((n14 = (n14 << 12) + ((0x3F & n10) << 6) + (0x3F & n9)) >= 55296 && n14 < 57344) {
                    return UTF8Support.charConversionFailure(1, n7, n10, n9, 0);
                }
                cArray2[n5++] = bl && n14 == 8232 ? 10 : (char)n14;
                bl2 = false;
                continue;
            }
            if (n4 == n3) {
                if (dataBuffer3 == dataBuffer2) {
                    nArray[0] = n5;
                    return CharConversionError.partialMultiPartCharacterSequence();
                }
                dataBuffer3 = dataBuffer3.next;
                byArray = dataBuffer3.bytes;
                n3 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
                n4 = dataBuffer3.startOffset;
            }
            if ((0xC0 & (n8 = byArray[n4++] & 0xFF)) != 128) {
                return UTF8Support.charConversionFailure(4, n7, n10, n9, n8);
            }
            int n15 = (n14 << 8) + ((0x30 & n10) << 2);
            if (n15 > 1024 || n15 == 0) {
                return CharConversionError.invalidUTF8SurrogateEncoding();
            }
            int n16 = n15 - 64;
            int n17 = 55296 + n16 + ((0xF & n10) << 2) + ((0x30 & n9) >> 4);
            int n18 = 56320 + ((0xF & n9) << 6) + (0x3F & n8);
            cArray2[n5] = (char)n17;
            if (n5 + 1 == n6) {
                cArray2 = UTF8Support.resize(cArray2);
                cArray[0] = cArray2;
                n6 <<= 1;
            }
            cArray2[n5 + 1] = (char)n18;
            n5 += 2;
        }
    }

    public static CharConversionError decodeCharacter(byte[] byArray, int n, int n2, int[] nArray) {
        if (n < n2) {
            int n3 = byArray[n];
            if (n3 >= 0) {
                nArray[0] = n3;
                nArray[1] = 1;
                return null;
            }
            int n4 = fgMultiByteLength[(n3 &= 0xFF) >> 3];
            if (n4 > 0) {
                nArray[1] = n4;
                if (n + n4 > n2) {
                    return CharConversionError.insufficientInputToDecodeCharacter();
                }
                int n5 = n3 & fgFirstByteValueMask[n4];
                int n6 = byArray[n + 1] & 0xFF;
                if ((0xC0 & n6) != 128) {
                    return UTF8Support.charConversionFailure(2, n3, n6, 0, 0);
                }
                if (n4 == 2) {
                    nArray[0] = n5 = (n5 << 6) + (0x3F & n6);
                    return null;
                }
                int n7 = byArray[n + 2] & 0xFF;
                if ((0xC0 & n7) != 128) {
                    return UTF8Support.charConversionFailure(3, n3, n6, n7, 0);
                }
                if (n4 == 3) {
                    nArray[0] = n5 = (n5 << 12) + ((0x3F & n6) << 6) + (0x3F & n7);
                    return null;
                }
                int n8 = byArray[n + 3] & 0xFF;
                if ((0xC0 & n8) != 128) {
                    return UTF8Support.charConversionFailure(4, n3, n6, n7, n8);
                }
                nArray[0] = n5 = (n5 << 18) + ((0x3F & n6) << 12) + ((0x3F & n7) << 6) + (0x3F & n8);
                return null;
            }
            return UTF8Support.charConversionFailure(1, n3, 0, 0, 0);
        }
        return CharConversionError.insufficientInputToDecodeCharacter();
    }

    public static CharConversionError decodeCharacter(DataBuffer dataBuffer, int n, DataBuffer dataBuffer2, int n2, int[] nArray) {
        int n3;
        byte[] byArray;
        block11: {
            byArray = dataBuffer.bytes;
            n3 = dataBuffer.endOffset;
            while (true) {
                byArray = dataBuffer.bytes;
                if (n < n3) break block11;
                if (dataBuffer == dataBuffer2) break;
                dataBuffer = dataBuffer.next;
                n = dataBuffer.startOffset;
                n3 = dataBuffer == dataBuffer2 ? n2 : dataBuffer.endOffset;
            }
            return CharConversionError.insufficientInputToDecodeCharacter();
        }
        int n4 = byArray[n++];
        if (n4 >= 0) {
            nArray[0] = n4;
            nArray[1] = 1;
            return null;
        }
        int n5 = fgMultiByteLength[(n4 &= 0xFF) >> 3];
        if (n5 > 1) {
            int n6;
            int n7;
            int n8;
            block14: {
                block13: {
                    block12: {
                        nArray[1] = n5;
                        n8 = n4 & fgFirstByteValueMask[n5];
                        while (true) {
                            if (n < n3) break block12;
                            if (dataBuffer == dataBuffer2) break;
                            dataBuffer = dataBuffer.next;
                            byArray = dataBuffer.bytes;
                            n = dataBuffer.startOffset;
                            n3 = dataBuffer == dataBuffer2 ? n2 : dataBuffer.endOffset;
                        }
                        return CharConversionError.insufficientInputToDecodeCharacter();
                    }
                    n7 = byArray[n++] & 0xFF;
                    if ((0xC0 & n7) != 128) {
                        return UTF8Support.charConversionFailure(2, n4, n7, 0, 0);
                    }
                    if (n5 == 2) {
                        nArray[0] = n8 = (n8 << 6) + (0x3F & n7);
                        return null;
                    }
                    while (true) {
                        if (n < n3) break block13;
                        if (dataBuffer == dataBuffer2) break;
                        dataBuffer = dataBuffer.next;
                        byArray = dataBuffer.bytes;
                        n = dataBuffer.startOffset;
                        n3 = dataBuffer == dataBuffer2 ? n2 : dataBuffer.endOffset;
                    }
                    return CharConversionError.insufficientInputToDecodeCharacter();
                }
                n6 = byArray[n++] & 0xFF;
                if ((0xC0 & n6) != 128) {
                    return UTF8Support.charConversionFailure(3, n4, n7, n6, 0);
                }
                if (n5 == 3) {
                    nArray[0] = n8 = (n8 << 12) + ((0x3F & n7) << 6) + (0x3F & n6);
                    return null;
                }
                while (true) {
                    if (n < n3) break block14;
                    if (dataBuffer == dataBuffer2) break;
                    dataBuffer = dataBuffer.next;
                    byArray = dataBuffer.bytes;
                    n = dataBuffer.startOffset;
                    n3 = dataBuffer == dataBuffer2 ? n2 : dataBuffer.endOffset;
                }
                return CharConversionError.insufficientInputToDecodeCharacter();
            }
            int n9 = byArray[n++] & 0xFF;
            if ((0xC0 & n9) != 128) {
                return UTF8Support.charConversionFailure(4, n4, n7, n6, n9);
            }
            nArray[0] = n8 = (n8 << 18) + ((0x3F & n7) << 12) + ((0x3F & n6) << 6) + (0x3F & n9);
            return null;
        }
        return UTF8Support.charConversionFailure(1, n4, 0, 0, 0);
    }

    public static void decodeCharacter(ParsedEntity parsedEntity, int[] nArray) {
        int n;
        int n2;
        byte[] byArray;
        DataBuffer dataBuffer;
        boolean bl;
        block21: {
            block22: {
                bl = false;
                do {
                    dataBuffer = parsedEntity.buffer;
                    byArray = parsedEntity.bytes;
                    n2 = parsedEntity.offset;
                    n = parsedEntity.endOffset;
                    if (n2 < n) break block21;
                    if (parsedEntity.unbuffered && parsedEntity.offset == parsedEntity.endOffset) {
                        nArray[0] = 0;
                        nArray[1] = 0;
                        return;
                    }
                    if (!bl) {
                        parsedEntity.setMark();
                        bl = true;
                    }
                    parsedEntity.load();
                    if (parsedEntity.error != null) break block22;
                } while (parsedEntity.buffer != dataBuffer);
                parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
                return;
            }
            return;
        }
        int n3 = byArray[n2++];
        if (n3 >= 0) {
            nArray[0] = n3;
            nArray[1] = 1;
            if (bl) {
                parsedEntity.resetToMark();
            }
            return;
        }
        int n4 = fgMultiByteLength[(n3 &= 0xFF) >> 3];
        if (n4 > 1) {
            int n5;
            int n6;
            int n7;
            block27: {
                block28: {
                    block25: {
                        block26: {
                            block23: {
                                block24: {
                                    nArray[1] = n4;
                                    n7 = n3 & fgFirstByteValueMask[n4];
                                    while (true) {
                                        if (n2 < n) break block23;
                                        if (!bl) {
                                            parsedEntity.setMark();
                                            bl = true;
                                        }
                                        parsedEntity.load();
                                        if (parsedEntity.error != null) break block24;
                                        if (parsedEntity.buffer == null) break;
                                        dataBuffer = parsedEntity.buffer;
                                        byArray = parsedEntity.bytes;
                                        n2 = parsedEntity.offset;
                                        n = parsedEntity.endOffset;
                                    }
                                    parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
                                    return;
                                }
                                return;
                            }
                            n6 = byArray[n2++] & 0xFF;
                            if ((0xC0 & n6) != 128) {
                                parsedEntity.error = UTF8Support.charConversionFailure(2, n3, n6, 0, 0);
                                return;
                            }
                            if (n4 == 2) {
                                nArray[0] = n7 = (n7 << 6) + (0x3F & n6);
                                if (bl) {
                                    parsedEntity.resetToMark();
                                }
                                return;
                            }
                            while (true) {
                                if (n2 < n) break block25;
                                if (!bl) {
                                    parsedEntity.setMark();
                                    bl = true;
                                }
                                parsedEntity.load();
                                if (parsedEntity.error != null) break block26;
                                if (parsedEntity.buffer == null) break;
                                dataBuffer = parsedEntity.buffer;
                                byArray = parsedEntity.bytes;
                                n2 = parsedEntity.offset;
                                n = parsedEntity.endOffset;
                            }
                            parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
                            return;
                        }
                        return;
                    }
                    n5 = byArray[n2++] & 0xFF;
                    if ((0xC0 & n5) != 128) {
                        parsedEntity.error = UTF8Support.charConversionFailure(3, n3, n6, n5, 0);
                        return;
                    }
                    if (n4 == 3) {
                        nArray[0] = n7 = (n7 << 12) + ((0x3F & n6) << 6) + (0x3F & n5);
                        if (bl) {
                            parsedEntity.resetToMark();
                        }
                        return;
                    }
                    while (true) {
                        if (n2 < n) break block27;
                        if (!bl) {
                            parsedEntity.setMark();
                            bl = true;
                        }
                        parsedEntity.load();
                        if (parsedEntity.error != null) break block28;
                        if (parsedEntity.buffer == null) break;
                        dataBuffer = parsedEntity.buffer;
                        byArray = parsedEntity.bytes;
                        n2 = parsedEntity.offset;
                        n = parsedEntity.endOffset;
                    }
                    parsedEntity.error = CharConversionError.insufficientInputToDecodeCharacter();
                    return;
                }
                return;
            }
            int n8 = byArray[n2++] & 0xFF;
            if ((0xC0 & n8) != 128) {
                parsedEntity.error = UTF8Support.charConversionFailure(4, n3, n6, n5, n8);
                return;
            }
            nArray[0] = n7 = (n7 << 18) + ((0x3F & n6) << 12) + ((0x3F & n5) << 6) + (0x3F & n8);
            if (bl) {
                parsedEntity.resetToMark();
            }
        } else {
            parsedEntity.error = UTF8Support.charConversionFailure(1, n3, 0, 0, 0);
        }
    }

    public static int lengthAsCharacters(DataBuffer dataBuffer, DataBuffer dataBuffer2, int n, int n2, int n3, int[] nArray) {
        boolean bl;
        DataBuffer dataBuffer3 = dataBuffer;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = (n3 & 8) != 0;
        boolean bl4 = bl = bl3 || (n3 & 4) != 0;
        if (nArray != null) {
            nArray[0] = 0;
        }
        if (dataBuffer2 == null) {
            dataBuffer2 = dataBuffer3;
        }
        while (true) {
            byte[] byArray = dataBuffer3.bytes;
            int n5 = dataBuffer3 == dataBuffer2 ? n2 : dataBuffer3.endOffset;
            block7: while (n < n5) {
                int n6 = byArray[n++];
                ++n4;
                if (n6 >= 0) {
                    if (!bl) continue;
                    if (bl2) {
                        bl2 = false;
                        if (n6 != 10) continue;
                        --n4;
                        continue;
                    }
                    if (n6 != 13) continue;
                    bl2 = true;
                    continue;
                }
                switch (fgMultiByteLength[(n6 &= 0xFF) >> 3]) {
                    default: {
                        return -1;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (bl2 && bl3 && n6 == 194) {
                            if (n < n5) {
                                if ((byArray[n] & 0xFF) == 133) {
                                    --n4;
                                    bl2 = false;
                                }
                            } else if (dataBuffer3 != dataBuffer2 && dataBuffer3.next.bytes[dataBuffer3.next.startOffset] == 133) {
                                --n4;
                                bl2 = false;
                            }
                        }
                        ++n;
                        break;
                    }
                    case 3: {
                        n += 2;
                        break;
                    }
                    case 4: {
                        n += 3;
                        if (nArray == null) continue block7;
                        nArray[0] = nArray[0] + 1;
                    }
                }
            }
            if (dataBuffer3 == dataBuffer2) break;
            dataBuffer3 = dataBuffer3.next;
            n = dataBuffer3.startOffset + (n - n5);
        }
        return n4;
    }

    public static int lengthAsCharacters(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            if (cArray[n] < '\ud800' || cArray[n] >= '\udc00') {
                ++n;
                continue;
            }
            n += 2;
            --n2;
        }
        return n2;
    }

    private UTF8Support() {
    }

    private static byte[] resize(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n << 1];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private static char[] resize(char[] cArray) {
        int n = cArray.length;
        char[] cArray2 = new char[n << 1];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    private static CharConversionError charConversionFailure(int n, int n2, int n3, int n4, int n5) {
        return CharConversionError.invalidUTF8CharacterEncoding(n, n2, n3, n4, n5);
    }
}

