/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.scan.util;

import com.ibm.xml.xlxp.scan.util.CharConversionError;
import com.ibm.xml.xlxp.scan.util.DataBuffer;
import com.ibm.xml.xlxp.scan.util.DataBufferFactory;
import com.ibm.xml.xlxp.scan.util.DataBufferReferrer;
import com.ibm.xml.xlxp.scan.util.DataSource;
import com.ibm.xml.xlxp.scan.util.ParsedEntityFactory;
import com.ibm.xml.xlxp.scan.util.UTF8Support;
import com.ibm.xml.xlxp.scan.util.UntestedCode;
import com.ibm.xml.xlxp.scan.util.XMLCharacterProperties;
import com.ibm.xml.xlxp.scan.util.XMLString;

public final class ParsedEntity {
    public String baseURI;
    public DataBuffer buffer;
    public byte[] bytes;
    public int offset;
    public int endOffset;
    public int startOffset;
    public int id;
    public boolean lineBreaksNormalized;
    public boolean unbuffered;
    public CharConversionError error;
    public boolean isXML10 = true;
    public boolean isInternal;
    public boolean isCoordinatesAware;
    public boolean loadCalled;
    public ParsedEntity parent;
    private final ParsedEntityFactory fEntityFactory;
    private final DataBufferReferrer fBufferReferrer;
    private final int[] fIntPointer;
    private DataSource fSource;
    protected DataBuffer fContentLastBuffer;
    private int fContentEndOffset;
    protected Mark fMarks;
    private Mark fFreeMarks;
    private DataBufferFactory fBufferFactory;

    public ParsedEntity(ParsedEntityFactory parsedEntityFactory) {
        this.fEntityFactory = parsedEntityFactory;
        this.fIntPointer = new int[2];
        this.fBufferReferrer = new DataBufferReferrer(){

            public boolean hasReferenceTo(DataBuffer dataBuffer) {
                Object object;
                if (ParsedEntity.this.buffer == dataBuffer) {
                    return true;
                }
                if (ParsedEntity.this.buffer.next != null) {
                    object = ParsedEntity.this.buffer.next;
                    while (object != null) {
                        if (object == dataBuffer) {
                            return true;
                        }
                        object = ((DataBuffer)object).next;
                    }
                }
                if (ParsedEntity.this.fContentLastBuffer == dataBuffer) {
                    return true;
                }
                if (ParsedEntity.this.fMarks != null) {
                    object = ParsedEntity.this.fMarks;
                    while (object != null) {
                        if (((Mark)object).markBuffer == dataBuffer) {
                            return true;
                        }
                        object = ((Mark)object).markNext;
                    }
                    return false;
                }
                return false;
            }
        };
    }

    public void setBufferFactory(DataBufferFactory dataBufferFactory) {
        if (dataBufferFactory != this.fBufferFactory) {
            if (this.fBufferFactory != null) {
                this.fBufferFactory.removeReferrer(this.fBufferReferrer);
            }
            dataBufferFactory.addReferrer(this.fBufferReferrer);
            this.fBufferFactory = dataBufferFactory;
        }
    }

    public void clear() {
        this.baseURI = null;
        this.bytes = null;
        this.startOffset = 0;
        this.lineBreaksNormalized = false;
        this.unbuffered = false;
        this.error = null;
        this.isXML10 = true;
        this.isInternal = false;
        this.loadCalled = false;
        if (this.fSource != null) {
            this.fSource.release();
            this.fSource = null;
        }
        this.buffer = null;
        if (this.fMarks != null) {
            if (this.fFreeMarks != null) {
                Mark mark = this.fMarks;
                while (mark.markNext != null) {
                    mark = mark.markNext;
                }
                mark.markNext = this.fFreeMarks;
            }
            this.fFreeMarks = this.fMarks;
            this.fMarks = null;
        }
        this.fContentLastBuffer = null;
        this.fBufferReferrer.active = false;
    }

    public boolean load() {
        this.loadCalled = true;
        if (this.buffer.next == null) {
            if (this.fSource != null) {
                this.error = this.fSource.load(this);
                return false;
            }
            return true;
        }
        if (this.buffer != this.fContentLastBuffer) {
            this.advanceBuffer(0);
            return false;
        }
        return true;
    }

    public void setValues(DataBuffer dataBuffer, int n, int n2, DataSource dataSource) {
        if (this.buffer != null) {
            this.buffer.next = dataBuffer;
        }
        this.buffer = dataBuffer;
        this.bytes = dataBuffer.bytes;
        this.offset = n;
        this.endOffset = n2;
        this.startOffset = n;
        this.unbuffered = dataSource == null;
        this.fSource = dataSource;
        this.fBufferReferrer.active = true;
    }

    public void setContent(XMLString xMLString) {
        this.buffer = xMLString.firstBuffer;
        this.bytes = this.buffer.bytes;
        this.startOffset = this.offset = xMLString.startOffset;
        if (xMLString.bytes != null) {
            this.endOffset = xMLString.endOffset;
            this.unbuffered = true;
            this.fContentLastBuffer = this.buffer;
            this.fContentEndOffset = this.endOffset;
        } else {
            this.fContentLastBuffer = xMLString.lastBuffer;
            this.fContentEndOffset = xMLString.endOffset;
            this.endOffset = this.buffer.endOffset;
            this.unbuffered = false;
        }
        this.fSource = null;
        this.fBufferReferrer.active = true;
    }

    public void release() {
        this.fBufferReferrer.active = false;
        this.fEntityFactory.releaseParsedEntity(this);
    }

    public void getEntireContents(XMLString xMLString) {
        xMLString.setStartPos(this.buffer, this.offset);
        while (!this.load()) {
        }
        xMLString.setEndPos(this.buffer, this.endOffset, 0);
        if (!this.lineBreaksNormalized) {
            xMLString.flags |= 0xC;
        } else {
            UntestedCode.needTest("unknown(24)");
        }
    }

    private void pushMark(Mark mark) {
        mark.markNext = this.fMarks;
        this.fMarks = mark;
    }

    private Mark popMark() {
        Mark mark = this.fMarks;
        this.fMarks = mark.markNext;
        return mark;
    }

    public void setMark() {
        Mark mark = this.fFreeMarks;
        if (mark != null) {
            this.fFreeMarks = mark.markNext;
            mark.markNext = null;
        } else {
            mark = new Mark();
        }
        mark.markBuffer = this.buffer;
        mark.markOffset = this.offset;
        mark.markStartOffset = this.startOffset;
        mark.markEndOffset = this.endOffset;
        this.pushMark(mark);
    }

    public void clearMark() {
        Mark mark = this.popMark();
        mark.markBuffer = null;
        mark.markNext = this.fFreeMarks;
        this.fFreeMarks = mark;
    }

    public void resetToMark() {
        Mark mark = this.popMark();
        if (this.buffer != mark.markBuffer) {
            this.buffer = mark.markBuffer;
            this.bytes = this.buffer.bytes;
            this.unbuffered = false;
        }
        mark.markBuffer = null;
        this.offset = mark.markOffset;
        this.startOffset = mark.markStartOffset;
        this.endOffset = mark.markEndOffset;
        mark.markNext = this.fFreeMarks;
        this.fFreeMarks = mark;
    }

    private void advanceBuffer(int n) {
        DataBuffer dataBuffer = this.buffer;
        this.buffer = dataBuffer.next;
        this.bytes = this.buffer.bytes;
        this.startOffset = this.buffer.startOffset;
        if (this.buffer == this.fContentLastBuffer) {
            this.endOffset = this.fContentEndOffset;
            this.unbuffered = true;
        } else {
            this.endOffset = this.buffer.endOffset;
            this.unbuffered = this.buffer.next == null && this.fSource == null;
        }
        this.offset = this.startOffset + n;
    }

    private void advanceOffset(int n) {
        this.offset += n;
        if (this.offset > this.endOffset) {
            n = this.offset - this.endOffset;
            this.advanceBuffer(n);
        }
    }

    public boolean skippedValidCharacter() {
        if (this.offset < this.endOffset || this.fSource != null) {
            UTF8Support.decodeCharacter(this, this.fIntPointer);
            if (this.error == null) {
                boolean bl;
                boolean bl2 = bl = this.isXML10 ? XMLCharacterProperties.validChar10(this.fIntPointer[0]) : XMLCharacterProperties.validChar11(this.fIntPointer[0], this.isInternal);
                if (bl) {
                    this.advanceOffset(this.fIntPointer[1]);
                    return true;
                }
                return false;
            }
            return false;
        }
        UntestedCode.needTest("unknown(51)");
        return false;
    }

    public boolean skippedNameStartCharacter() {
        UTF8Support.decodeCharacter(this, this.fIntPointer);
        if (this.error == null) {
            boolean bl;
            boolean bl2 = bl = this.isXML10 ? XMLCharacterProperties.nameStartChar10(this.fIntPointer[0]) : XMLCharacterProperties.nameStartChar11(this.fIntPointer[0]);
            if (bl) {
                this.advanceOffset(this.fIntPointer[1]);
                return true;
            }
            return false;
        }
        UntestedCode.needTest("unknown(55)");
        return false;
    }

    public boolean skippedNameCharacter() {
        UTF8Support.decodeCharacter(this, this.fIntPointer);
        if (this.error == null) {
            boolean bl;
            boolean bl2 = bl = this.isXML10 ? XMLCharacterProperties.nameChar10(this.fIntPointer[0]) : XMLCharacterProperties.nameChar11(this.fIntPointer[0]);
            if (bl) {
                this.advanceOffset(this.fIntPointer[1]);
                return true;
            }
            return false;
        }
        UntestedCode.needTest("unknown(59)");
        return false;
    }

    public boolean skippedXML11EOLCharacter() {
        if ((this.bytes[this.offset] & 0xDF) == 194) {
            UTF8Support.decodeCharacter(this, this.fIntPointer);
            if (this.error == null) {
                if (this.fIntPointer[0] == 133 || this.fIntPointer[0] == 8232) {
                    this.advanceOffset(this.fIntPointer[1]);
                    return true;
                }
                return false;
            }
            UntestedCode.needTest("unknown(60)");
            return false;
        }
        return false;
    }

    public int decodeCharacter() {
        UTF8Support.decodeCharacter(this, this.fIntPointer);
        if (this.error == null) {
            return this.fIntPointer[0];
        }
        return -1;
    }

    private class Mark {
        DataBuffer markBuffer;
        int markOffset;
        int markStartOffset;
        int markEndOffset;
        Mark markNext;

        private Mark() {
        }
    }
}

