﻿Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue 

$InputTestFrequency=$args
$minutes=$InputTestFrequency[0]

$minutes=-1*$minutes
$limit=1000

#$OutPut= Get-SPLogEvent -StartTime (get-date).AddMinutes($minutes) | Select-Object @{Expression={ $("{0}~{1}~{2}~{3}~{4}~{5}~{6}~{7}" -f $_.'area',$_.'category',$_.'level', $_.'Timestamp', $_.'correlation', $_.'eventid', $_.'message', $_.'process') } } |
# Format-Table –AutoSize -HideTableHeaders | out-string -width 25000 
#Write-Host $OutPut

$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$MyDir=$egurkhaPath+'/agent/SharePoint/'
if(!(Test-Path -Path $MyDir )){
    New-Item -ItemType directory -Path $MyDir
}
$csvPath=$MyDir+'SPGetULLogDtls.csv'
Get-SPLogEvent -StartTime (get-date).AddMinutes($minutes) | Select-Object area,category,level,Timestamp,correlation,eventid,message,process | Export-Csv $csvPath
$recordSets=Import-Csv $csvPath
if($limit -ne $null -and $limit -ne -1 -and $limit -ne ''){
    for($i=0;$i -lt $limit;$i++){
        $output=$recordSets[$i].area+'~'+$recordSets[$i].category+'~'+$recordSets[$i].level+'~'+$recordSets[$i].Timestamp+'~'+$recordSets[$i].correlation+'~'+$recordSets[$i].eventid+'~'+$recordSets[$i].message+'~'+$recordSets[$i].process
        Write-Host $output
    }
}
else{
    for($i=0;$i -lt $recordSets.Count;$i++){
        $output=$recordSets[$i].area+'~'+$recordSets[$i].category+'~'+$recordSets[$i].level+'~'+$recordSets[$i].Timestamp+'~'+$recordSets[$i].correlation+'~'+$recordSets[$i].eventid+'~'+$recordSets[$i].message+'~'+$recordSets[$i].process
        Write-Host $output
    }
}
Remove-Item -Path $csvPath

Remove-PSSnapin Microsoft.SharePoint.PowerShell