﻿clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUser=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$readingdate=[datetime]$TestInputs[4]
$proxyserver=$TestInputs[5]
$rptNam=$TestInputs[6]
#>

$toReadDat=$readingdate.tostring(“yyyy-MM-dd”)
$rptPath=$egurkhaPath+'\agent\SBO\'+$rptNam
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}
$o365Domain=Eg-GetDomain -userName $username -Password $password -proxyUsr $proxyUser -proxyPass $proxyPass -IsIntial $true -proxyserver $proxyserver

$appId=''
$appSecret=''
$tenantID=''
$authString=''
$resource=''
$typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $typePath

#------Get App Reg Details ------------
$GraphDir=$egurkhaPath+'\agent\O365\MsGraph'
$unProtPath=$GraphDir+'\GraphDetails.dat'
$keyFileNam='\GraphDetailsKey.dat'
$kvalue=Get-Content -Path $GraphDir$keyFileNam
$null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.ini'
$spoGraphDtls=$GraphDir+"\GraphDetails.ini"
$getInputs=Get-Content -Path $spoGraphDtls
Remove-Item $spoGraphDtls
$flag=$false
foreach($input in $getInputs){
    if($input.StartsWith('[') -and $input.ToLower().Contains($o365Domain.ToLower())){
        $flag=$true
    }
    if($flag){
        if($input.Contains("client_id")){
            $appId=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("client_secret")){
            $appSecret=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("TenantName")){
            $tenantID=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("Authority")){
            $authString=$input.ToString().Substring($input.IndexOf('~')+1)
            $authString=$authString+$o365Domain
        }
        if($input.Contains("Resource")){
            $resource=$input.ToString().Substring($input.IndexOf('~')+1)
            $flag=$false
        }
    }         
}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$SBOUsrActvtyDtlCSV=$rptPath+'\SBOUsrActvtyDtl'+$timenow+'.csv'
$url = "https://graph.microsoft.com/v1.0/reports/getSkypeForBusinessActivityUserDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url -filePath $SBOUsrActvtyDtlCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $SBOUsrActvtytotal=Import-Csv $SBOUsrActvtyDtlCSV
    $url=$SBOUsrActvtytotal.'@odata.nextLink'
    if($url -eq $null -or $url -eq ''){
        break
    }
}
$diffence=(NEW-TIMESPAN –Start $readingdate –End (Get-Date) | Select-Object Days).Days

$notFirsttime = $false
while($diffence -ge 1)
{
    if($notFirsttime){ $readingdate=$readingdate.AddDays(1) }
    $actualdate=$readingdate
    $notFirsttime = $true
    $SBOUsrActivity =$SBOUsrActvtytotal | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
    if($SBOUsrActivity)
    {
        Write-Host 'ReadDate for the Date#'$actualdate.tostring(“yyyy-MM-dd”)
        break
    }
    else
    {
        Write-Host 'thereIs No Data on#'$actualdate.tostring(“yyyy-MM-dd”)
    }
    $diffence=$diffence-1
}

Write-Host '#MeasuresStart#'
foreach($usr in $SBOUsrActivity) {
    Write-Host $usr.UserPrincipalName '#' $usr.'TotalPeer-to-peerSessionCount' '#' $usr.TotalOrganizedConferenceCount '#' $usr.TotalParticipatedConferenceCount '#' $usr.'Peer-to-peerIMCount' '#' $usr.'Peer-to-peerAudioCount' '#' $usr.'Peer-to-peerAudioMinutes' '#' $usr.'Peer-to-peerVideoCount' '#' $usr.'Peer-to-peerVideoMinutes' '#' $usr.'Peer-to-peerAppSharingCount' '#' $usr.'Peer-to-peerFileTransferCount' '#' $usr.ParticipatedConferenceIMCount '#' $usr.'ParticipatedConferenceAudio/VideoCount' '#' $usr.'ParticipatedConferenceAudio/VideoMinutes' '#' $usr.ParticipatedConferenceAppSharingCount '#' $usr.ParticipatedConferenceWebCount '#' $usr.'ParticipatedConferenceDial-in/out3rdPartyCount' '#' $usr.OrganizedConferenceIMCount '#' $usr.'OrganizedConferenceAudio/VideoCount' '#' $usr.'OrganizedConferenceAudio/VideoMinutes' '#' $usr.OrganizedConferenceAppSharingCount '#' $usr.OrganizedConferenceWebCount '#' $usr.'OrganizedConferenceDial-in/out3rdPartyCount' '#' $usr.'OrganizedConferenceDial-in/outMicrosoftCount' '#' $usr.'OrganizedConferenceDial-inMicrosoftMinutes' '#' $usr.'OrganizedConferenceDial-outMicrosoftMinutes'
}
Write-Host '#MeasuresEnd#'
Remove-Item $SBOUsrActvtyDtlCSV