﻿clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

$TestInputs=$args

$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyHost=$TestInputs[2]
$proxyPort=$TestInputs[3]
$proxyUsr=$TestInputs[4]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[5]

$azureVal=Eg-GetAzureEnv -UserName $userName -subject 'O365_AzureEnvironment'
$azureEnvArr=$azureVal.Split(',')

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if($proxyHost -ne 'none' -and $proxyPort -ne 'none'){
    $proxyserver='http://'+$proxyHost+':'+$proxyPort
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
}
if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
    $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
    [System.Net.WebRequest]::DefaultWebProxy.Credentials = $proxyCred	
    [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
}

Connect-MsolService -Credential $credential -AzureEnvironment $azureEnvArr[0] -ErrorAction SilentlyContinue

if($?){
    Write-Host 'success'
}else{
    Write-Host 'failure'
}


