﻿<#
    /*****************************************************************************
    Author            :       Mounika Kuna
    Purpose           :       Provides Office 365 Groups Activity Details
    Created           :       18/07/2020    
    /*****************************************************************************
#>

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUser=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserver=$TestInputs[4]
$readingdate=[datetime]$TestInputs[5]
$rptNam=$TestInputs[6]
#>

$toReadDat=$readingdate.tostring(“yyyy-MM-dd”)
$rptPath=$egurkhaPath+'\agent\EXO\'+$rptNam
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}
$o365Domain=Eg-GetDomain -userName $username -Password $password -proxyUsr $proxyUser -proxyPass $proxyPass -IsIntial $true -proxyserver $proxyserver

$appId=''
$appSecret=''
$tenantID=''
$authString=''
$resource=''
$typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $typePath

#------Get App Reg Details ------------
$GraphDir=$egurkhaPath+'\agent\O365\MsGraph'
$unProtPath=$GraphDir+'\GraphDetails.dat'
$keyFileNam='\GraphDetailsKey.dat'
$kvalue=Get-Content -Path $GraphDir$keyFileNam
$null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.ini'
$spoGraphDtls=$GraphDir+"\GraphDetails.ini"
$getInputs=Get-Content -Path $spoGraphDtls
Remove-Item $spoGraphDtls
$flag=$false
foreach($input in $getInputs){
    if($input.StartsWith('[') -and $input.ToLower().Contains($o365Domain.ToLower())){
        $flag=$true
    }
    if($flag){
        if($input.Contains("client_id")){
            $appId=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("client_secret")){
            $appSecret=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("TenantName")){
            $tenantID=$input.ToString().Substring($input.IndexOf('~')+1)
        }
        if($input.Contains("Authority")){
            $authString=$input.ToString().Substring($input.IndexOf('~')+1)
            $authString=$authString+$o365Domain
        }
        if($input.Contains("Resource")){
            $resource=$input.ToString().Substring($input.IndexOf('~')+1)
            $flag=$false
        }
    }         
}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$O365GrpsActDtlsCSV=$rptPath+'\O365GrpsActDtls'+$timenow+'.csv'
$url = "https://graph.microsoft.com/v1.0/reports/getOffice365GroupsActivityDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url -filePath $O365GrpsActDtlsCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $TotalO365GrpsActDtls=Import-Csv $O365GrpsActDtlsCSV
    $url=$TotalO365GrpsActDtls.'@odata.nextLink'
    if($url -eq $null -or $url -eq ''){
        break
    }
}
$diffence=(NEW-TIMESPAN –Start $readingdate –End (Get-Date) | Select-Object Days).Days

$notFirsttime = $false
while($diffence -ge 1)
{
    if($notFirsttime){ $readingdate=$readingdate.AddDays(1) }
    $actualdate=$readingdate
    $notFirsttime = $true
    $TotalO365GrpsAct =$TotalO365GrpsActDtls | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
    if($TotalO365GrpsAct)
    {
        Write-Host 'ReadDate for the Date#'$actualdate.tostring(“yyyy-MM-dd”)
        break
    }
    else
    {
        Write-Host 'thereIs No Data on#'$actualdate.tostring(“yyyy-MM-dd”)
    }
    $diffence=$diffence-1
}
try{
    foreach($O365GrpsActvty in $TotalO365GrpsAct){
        if($O365GrpsActvty.MemberCount -eq ""){ $MemberCount='0'}
            else{ 
                $MemberCount=$O365GrpsActvty.MemberCount
                    if($MemberCount -ne '0'){
                        $MemberCountDD=$O365GrpsActvty.ReportRefreshDate+'~!~'+$O365GrpsActvty.GroupDisplayName+'~!~'+$O365GrpsActvty.OwnerPrincipalName+'~!~'+$O365GrpsActvty.LastActivityDate+'~!~'+$O365GrpsActvty.GroupType+'~!~'+$O365GrpsActvty.GroupId
                        Write-Host 'MemberCountDD='$MemberCountDD
                    }
            }
        if($O365GrpsActvty.ExternalMemberCount -eq ""){ $ExternalMemberCount='0'}
            else{ $ExternalMemberCount=$O365GrpsActvty.ExternalMemberCount}
        if($O365GrpsActvty.ExchangeReceivedEmailCount -eq ""){ $ExchangeReceivedEmailCount='0'}
            else{ $ExchangeReceivedEmailCount=$O365GrpsActvty.ExchangeReceivedEmailCount}
        if($O365GrpsActvty.SharePointActiveFileCount -eq ""){ $SharePointActiveFileCount='0'}
            else{ $SharePointActiveFileCount=$O365GrpsActvty.SharePointActiveFileCount}
        if($O365GrpsActvty.YammerPostedMessageCount -eq ""){ $YammerPostedMessageCount='0'}
            else{ $YammerPostedMessageCount=$O365GrpsActvty.YammerPostedMessageCount}
        if($O365GrpsActvty.YammerReadMessageCount -eq ""){ $YammerReadMessageCount='0'}
            else{ $YammerReadMessageCount=$O365GrpsActvty.YammerReadMessageCount}
        if($O365GrpsActvty.YammerLikedMessageCount -eq ""){ $YammerLikedMessageCount='0'}
            else{ $YammerLikedMessageCount=$O365GrpsActvty.YammerLikedMessageCount}
        if($O365GrpsActvty.ExchangeMailboxTotalItemCount -eq ""){ $ExchangeMailboxTotalItemCount='0'}
            else{ $ExchangeMailboxTotalItemCount=$O365GrpsActvty.ExchangeMailboxTotalItemCount}  
        if($O365GrpsActvty.SharePointTotalFileCount -eq ""){ $SharePointTotalFileCount='0'}
            else{ $SharePointTotalFileCount=$O365GrpsActvty.SharePointTotalFileCount}    
    $Output = $O365GrpsActvty.GroupDisplayName+'~'+$MemberCount+'~'+$ExternalMemberCount+'~'+$ExchangeReceivedEmailCount+'~'+$SharePointActiveFileCount+'~'+$YammerPostedMessageCount+'~'+$YammerReadMessageCount+'~'+$YammerLikedMessageCount+'~'+$ExchangeMailboxTotalItemCount+'~'+[math]::Round(($O365GrpsActvty.ExchangeMailboxStorageUsed/1073741824),2)+'~'+$SharePointTotalFileCount+'~'+[math]::Round(($O365GrpsActvty.SharePointSiteStorageUsed/1073741824),2)
    Write-Host 'info&Measures='$Output
    }
}catch{    
    $exceptionmsg=($_.Exception.Message)+($_.ScriptStackTrace) 
	Write-error "Error Occured in O365GrpsActDtlsTest Script >>> "$exceptionmsg 
}
Remove-Item $O365GrpsActDtlsCSV
