﻿
clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy


$testargs=$args
$Rptcrds=$testargs[4].split("#")
$reportingname='MTM/'+$Rptcrds[0]
$testFrequency=$Rptcrds[1]
	
try{

    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "MTMdAuditOper" -keyFileName "kMTMdAuditOper" -EgPath $egurkhaPath
    $datafile=$readfiles[1] -replace (".csv",".dat") 
    $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
    $usractivites= import-csv $csvfile
    Remove-Item $csvfile       
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'MTMdAuditOper' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kMTMdAuditOper' -InputFile $readfiles[4]
    Write-Host "ReadFile:"$readfiles[3]

    }
    catch [System.Management.Automation.RuntimeException] {
        Write-Error -Message "File not found. The $reportingname location does not contain MTM usr Activities files."
    }
    catch{
        $errmsg=$_.Exception.Message
        $errstack=$_.Exception.StackTrace
        Write-Error -Message $errmsg
    }

$MemAdtions=0
$MemRolCnged=0
$TemSetngsCnged=0
$teamdeletecnt=0
$MemberRemovedCnt=0
$ChnlStngsCngCnt=0
$TmtentStngsCngCnt=0

    foreach($input in $usractivites)
    {
        $operation=$input.Operations
        $auditdata=$input.AuditData | ConvertFrom-Json
        $auditdata.CreationTime=($auditdata.CreationTime).Replace("T"," ")
        $usertype=[int]$auditdata.UserType
        if($usertype -eq 0) { $auditdata.UserType ="Regular user" }
        if($usertype -eq 2) { $auditdata.UserType ="Administrator" }
        if($usertype -eq 3) { $auditdata.UserType ="Microsoft datacenter administrator" }
        if($usertype -eq 4) { $auditdata.UserType ="System Account" }
        if($usertype -eq 5) { $auditdata.UserType ="An Application" }
        if($usertype -eq 6) { $auditdata.UserType ="Service principal" }
        if($usertype -eq 7) { $auditdata.UserType ="Custom policy" }
        if($usertype -eq 8) { $auditdata.UserType ="System policy" }

        if($operation -eq 'MemberAdded')
        {      
      #  Creation Time, Team Name, Members (UPN Value – Role, The values should be comma separated when there are more than one member}, Team GUID, Creator (UserID)

            write-host 'MemberAddedDD#' $auditdata.CreationTime'~!~'$auditdata.TeamName'~!~'$auditdata.Members'~!~'$empty '~!~' $empty '~!~' $auditdata.UserId'~!~'$auditdata.UserType'~!~'$auditdata.TeamGuid  #5
            $MemAdtions++
        }
        if($operation -eq 'MemberRoleChanged')
        {

    # “MemberRoleChanged” - Log Time, UserID, UserTpe, DisplayName, Role, UPN, TeamName, TeamGUID

      # {@{DisplayName=Sri Devi; Role=2; UPN=sridevi@egteam.onmicrosoft.com}}
            foreach($keyvalue in $auditdata.ExtraProperties)
            {
                $DisplayName = $keyvalue.DisplayName
                $Role = $keyvalue.Role
                $UPN = $keyvalue.UPN
            }

            write-host 'MemberRoleChangedDD#' $auditdata.CreationTime'~!~'$auditdata.TeamName'~!~'$DisplayName '~!~' $Role '~!~' $UPN '~!~' $auditdata.UserId'~!~'$auditdata.UserType'~!~'$auditdata.TeamGuid 
            $MemRolCnged++
        } 
 
        if($operation -eq 'TeamSettingChanged')
        {
        # “TeamSettingChanged” - LogTime, UserID, TeamGUID, TeamName, Name, New value, Old value
            write-host 'TeamSettingChangedDD#' $auditdata.CreationTime'~!~'$auditdata.TeamName'~!~'$auditdata.Name'~!~'$auditdata.NewValue'~!~'$auditdata.OldValue'~!~'$auditdata.UserId'~!~'$auditdata.UserType'~!~'$auditdata.TeamGuid 
            $TemSetngsCnged++
        }                                    
            
        if($operation -eq 'TeamDeleted')
        {
       # Log Time, Deleted by (UserId), Team Name, Team GUID 
             write-host 'TeamDeletedDD#' $auditdata.CreationTime'~!~'$auditdata.TeamName'~!~' -5 '~!~' -5 '~!~' -5 '~!~'$auditdata.UserId'~!~' -5 '~!~' $auditdata.TeamGuid
            $teamdeletecnt++
        }
        
        if($operation -eq 'MemberRemoved')
        {
            write-host 'MemberRemoved#' $auditdata.CreationTime'~!~'$auditdata.TeamName'~!~'$auditdata.Members'~!~' -5 '~!~' -5 '~!~'$auditdata.UserId'~!~'$auditdata.UserType'~!~'$auditdata.TeamGuid 
            $MemberRemovedCnt++
        }

        if($operation -eq 'ChannelSettingChanged')
        {
            write-host 'ChannelSettingChangedDD#' $auditdata.CreationTime'~!~'$auditdata.TeamName'~!~'$auditdata.Name'~!~'$auditdata.NewValue'~!~'$auditdata.OldValue'~!~'$auditdata.UserId'~!~'$auditdata.UserType'~!~'$auditdata.TeamGuid'~!~'$auditdata.ChannelGuid 
            $ChnlStngsCngCnt++
        }

         if($operation -eq 'TeamsTenantSettingChanged')
        {
            write-host 'TeamsTenantSettingChangedDD#' $auditdata.CreationTime'~!~'$auditdata.UserId'~!~'$auditdata.UserType'~!~'$auditdata.UserKey'~!~'$auditdata.ExtraProperties'~!~'$auditdata.Name'~!~'$auditdata.NewValue
            $TmtentStngsCngCnt++
        }                        
                
    }

    Write-host 'measures' $MemAdtions ~ $MemRolCnged ~ $TemSetngsCnged ~ $teamdeletecnt ~ $MemberRemovedCnt ~ $ChnlStngsCngCnt ~ $TmtentStngsCngCnt 


