﻿Function Get-LocalTime(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$dat, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$hr
    )
    Process
    {
        $ltimArr=@()
        $UTCTime=[DateTime]$dat
        $UTCTime=$UTCTime.AddHours([int]$hr)
        $strCurrentTimeZone = (Get-WmiObject win32_timezone).StandardName
        $TZ = [System.TimeZoneInfo]::FindSystemTimeZoneById($strCurrentTimeZone)
        $LocalTime = [System.TimeZoneInfo]::ConvertTimeFromUtc($UTCTime, $TZ)
        $ltimArr+='{0:yyyy-MM-dd}' -f $LocalTime
        $ltimArr+=(Get-Date $LocalTime).Hour
        Return $ltimArr
    }
}
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$mperiodAndIsTeam=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$mperiodAndIsTeam[0].Trim()
$IsTeamsEnabled=$mperiodAndIsTeam[1].Trim()
$rptTimNUPN=$mperiodAndIsTeam[2].Trim()
$prxyCrds=$TestInputs[3].ToString().Split('#')
$proxyUsr=$prxyCrds[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyCrds[1]
$proxyserverip=($TestInputs[4]).ToString().trim()
$shwTopNDD=[int]$TestInputs[5]
#>

$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }
$measures='Measures.Total Stream Count','Measures.Total CDR Available Stream Count','Measures.Total Media Failed Stream Count','Measures.Total Call Setup Failed Stream Count','Measures.Total Call Dropped Stream Count','Measures.Total Media Succeeded Stream Count','Measures.Total Call Setup Succeeded Stream Count','Measures.Total Call Setup Failure Percentage','Measures.Total Call Dropped Failure Percentage','Measures.Total Answer Seizure Ratio','Measures.Total Short Call Percentage','Measures.Total Media Failure Percentage','Measures.Avg Call Duration','Measures.Media Failed Due To Firewall DPI Stream Count','Measures.Firewall DPI Media Failure Percentage','Measures.Media Failed Due To Firewall IP Blocked Stream Count','Measures.Firewall IP Blocked Media Failure Percentage','Measures.Media Failed Due To Other Stream Count','Measures.Other Media Failure Percentage'
$Dimentions ='AllStreams.Start Time','AllStreams.End Time','AllStreams.Date','AllStreams.Hour','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.Conference Id','AllStreams.Is Teams','AllStreams.First UPN','AllStreams.Second UPN'
$CalSummryStrms=Get-CQDData -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3 | Where-Object {$_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled} | Sort-Object -Property 'End Time' -Descending
$latestCalSummry=@()
if($rptTimNUPN -ne 'none'){
    foreach($strms in $CalSummryStrms){
	if(([String]$strms.'First UPN').Trim() -eq '-' -and ([String]$strms.'Second UPN').Trim() -eq '-'){continue;}
        if($iswrite){
            $latestCalSummry+=$strms
        }
        $chktimNam=$strms.'End Time'+'#'+$strms.'First UPN'+'#'+$strms.'Second UPN'
        if($rptTimNUPN -eq $chktimNam){
            $iswrite=$true
        }
    }
}
if(!$iswrite){
    foreach($strms in $CalSummryStrms){
	if(([String]$strms.'First UPN').Trim() -eq '-' -and ([String]$strms.'Second UPN').Trim() -eq '-'){continue;}
        $cmprTime=[DateTime][String]$strms.'End Time'
        $cmprTime=$cmprTime.ToUniversalTime()
        if($cmprTime -ne ''){
            if($dat1 -lt $cmprTime){
                $latestCalSummry+=$strms 
            }
        }
    }
}
$lastObj=$CalSummryStrms |Select-Object -First 1
$rptEdTimNUPN='LastReporting EndTime and UPN#'+$lastObj.'End Time'+'~'+$lastObj.'First UPN'+'~'+$lastObj.'Second UPN'
Write-Host $rptEdTimNUPN

if($latestCalSummry){
    $toalStreamsCnt=0
    $TotalCDRAvailableStreamCount=0
    $TotalMediaFailedStreamCount=0
    $TotalCallSetupFailedStreamCount=0
    $TotalCallDroppedStreamCount=0
    $TotalMediaSucceededStreamCount=0
    $TotalCallSetupSucceededStreamCount=0
    $TotalCallSetupFailurePercentage=0
    $TotalCallDroppedFailurePercentage=0
    $TotalAnswerSeizureRatio=0
    $TotalShortCallPercentage=0
    $TotalMediaFailurePercentage=0
    $AvgCallDuration=0
    $MediaFailedDueToFirewallDPIStreamCount=0
    $FirewallDPIMediaFailurePercentage=0
    $MediaFailedDueToFirewallIPBlockedStreamCount=0
    $FirewallIPBlockedMediaFailurePercentage=0
    $MediaFailedDueToOtherStreamCount=0
    $OtherMediaFailurePercentage=0


    $toalStreamsCnt=($latestCalSummry | where-object { $_.'Total Stream Count' -ne 'NaN' } | Measure-Object "Total Stream Count" -Sum | select Sum).Sum
    if($toalStreamsCnt){
        $TotalCDRAvailableStreamCount=($latestCalSummry | where-object { $_.'Total CDR Available Stream Count' -ne 'NaN' } | Measure-Object "Total CDR Available Stream Count" -Sum | select Sum).Sum

        Write-Host '***************DD for TotalMediaFailedStreamCount Measure****************************'
        $TotalMediaFailedStreamCount=($latestCalSummry | where-object { $_.'Total Media Failed Stream Count' -ne 'NaN' } | Measure-Object "Total Media Failed Stream Count" -Sum | select Sum).Sum
        if($TotalMediaFailedStreamCount){
            $ddforFailedstreams = $latestCalSummry | Where-Object { $_."Total Media Failed Stream Count" -gt 0.001 } | Sort-Object { $_."Total Media Failed Stream Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddforFailedstreams){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                #Write-Host 'ddTotalMediaFailedStreamCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id' ~!~ $in.'Total Media Failed Stream Count'
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddTotalMediaFailedStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id' ~!~ $in.'Total Media Failed Stream Count'
            }
            $ddforFailedstreams=$null
        }

        Write-Host '***************DD for TotalCallSetupFailedStreamCount Measure****************************'
        $TotalCallSetupFailedStreamCount=($latestCalSummry  | where-object { $_.'Total Call Setup Failed Stream Count' -ne 'NaN' } | Measure-Object "Total Call Setup Failed Stream Count" -Sum | select Sum).Sum
        if($TotalCallSetupFailedStreamCount){
            $ddforTotalCalFiledstreams = $latestCalSummry | Where-Object { $_."Total Call Setup Failed Stream Count" -gt 0.001 } | Sort-Object { $_."Total Call Setup Failed Stream Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddforTotalCalFiledstreams){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddTotalCallSetupFailedStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Total Call Setup Failed Stream Count'
            }
            $ddforTotalCalFiledstreams=$null
        }

        Write-Host '***************DD for TotalCallDroppedStreamCount Measure****************************'
        $TotalCallDroppedStreamCount=($latestCalSummry  | where-object { $_.'Total Call Dropped Stream Count' -ne 'NaN' } | Measure-Object "Total Call Dropped Stream Count" -Sum | select Sum).Sum
        if($TotalCallDroppedStreamCount){
            $ddforTotalCallDroppedStreamCount = $latestCalSummry | Where-Object { $_."Total Call Dropped Stream Count" -gt 0.001 } | Sort-Object { $_."Total Call Dropped Stream Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddforTotalCallDroppedStreamCount){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddTotalCallDroppedStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Total Call Dropped Stream Count'
            }
            $ddforTotalCallDroppedStreamCount=$null
        }

        $TotalMediaSucceededStreamCount=($latestCalSummry | where-object { $_.'Total Media Succeeded Stream Count' -ne 'NaN' } | Measure-Object "Total Media Succeeded Stream Count" -Sum | select Sum).Sum
        $TotalCallSetupSucceededStreamCount=($latestCalSummry | where-object { $_.'Total Call Setup Succeeded Stream Count' -ne 'NaN' } | Measure-Object "Total Call Setup Succeeded Stream Count" -Sum | select Sum).Sum

        Write-Host '***************TotalCallSetupFailurePercentage Measure****************************'
        #$TotalCallSetupFailurePercentage=($latestCalSummry | where-object { $_.'Total Call Setup Failure Percentage' -ne 'NaN' -and $_."Total Call Setup Failure Percentage" -gt 0.001 } | Measure-Object "Total Call Setup Failure Percentage" -Average | select Average).Average
        $TotalCallSetupFailurePercentage=($TotalCallSetupFailedStreamCount/$toalStreamsCnt)*100
        if(-not $TotalCallSetupFailurePercentage){  $TotalCallSetupFailurePercentage=0 }  else { $TotalCallSetupFailurePercentage=$TotalCallSetupFailurePercentage.ToString("#.##") }

        Write-Host '***************TotalCallDroppedFailurePercentage Measure****************************'
        #$TotalCallDroppedFailurePercentage=($latestCalSummry | where-object { $_.'Total Call Dropped Failure Percentage' -ne 'NaN' -and $_."Total Call Dropped Failure Percentage" -gt 0.001 } | Measure-Object "Total Call Dropped Failure Percentage" -Average | select Average).Average
        $TotalCallDroppedFailurePercentage=($TotalCallDroppedStreamCount/$toalStreamsCnt)*100
        if(-not $TotalCallDroppedFailurePercentage){  $TotalCallDroppedFailurePercentage=0 }  else { $TotalCallDroppedFailurePercentage=$TotalCallDroppedFailurePercentage.ToString("#.##") }

        $TotalAnswerSeizureRatio=($latestCalSummry  | where-object { $_.'Total Answer Seizure Ratio' -ne 'NaN' } | Measure-Object "Total Answer Seizure Ratio" -Sum | select Sum).Sum

        Write-Host '***************TotalShortCallPercentage Measure************************************************'
        $totalshortcallcount=0
        $TotalShortCallPercentagelist=($latestCalSummry | where-object { $_.'Total Short Call Percentage' -ne 'NaN' -and $_."Total Short Call Percentage" -gt 0.001 } ) | Select-Object 'Total Stream Count','Total Short Call Percentage' #| Measure-Object "Total Short Call Percentage" -Average | select Average).Average
        foreach($input in $TotalShortCallPercentagelist){
            $totalshortcallcount=$totalshortcallcount+(([float]$input.'Total Short Call Percentage')*([float]$input.'Total Stream Count'))/100
        }
        $TotalShortCallPercentage=($totalshortcallcount/$toalStreamsCnt)*100
        if(-not $TotalShortCallPercentage){  $TotalShortCallPercentage=0 }  else { $TotalShortCallPercentage=$TotalShortCallPercentage.ToString("#.##") }

        Write-Host '***************TotalMediaFailurePercentage Measure****************************'
        <#
        $TotalMediaFailurePercentage=($latestCalSummry | where-object { $_.'Total Media Failure Percentage' -ne 'NaN' -and $_."Total Media Failure Percentage" -gt 0.001 } | Measure-Object "Total Media Failure Percentage" -Average | select Average).Average
        #>
        $TotalMediaFailurePercentage=($TotalMediaFailedStreamCount/$toalStreamsCnt)*100
        if(-not $TotalMediaFailurePercentage){  $TotalMediaFailurePercentage=0 }  else { $TotalMediaFailurePercentage=$TotalMediaFailurePercentage.ToString("#.##") }

        $AvgCallDuration=($latestCalSummry | where-object { $_.'Avg Call Duration' -ne 'NaN' -and $_."Avg Call Duration" -gt 0.001 } | Measure-Object "Avg Call Duration" -Average | select Average).Average
        if(-not $AvgCallDuration){  $AvgCallDuration=0 }  else { $AvgCallDuration=$AvgCallDuration.ToString("#.##") }

        Write-Host '***************DD for MediaFailedDueToFirewallDPIStreamCount Measure****************************'
        $MediaFailedDueToFirewallDPIStreamCount=($latestCalSummry | where-object { $_.'Media failed due to firewall DPI stream count' -ne 'NaN' } | Measure-Object "Media failed due to firewall DPI stream count" -Sum | select Sum).Sum
        if($MediaFailedDueToFirewallDPIStreamCount){
            $ddforMediaFailedDueToFirewallDPIStreamCount = $latestCalSummry | Where-Object { $_."Media failed due to firewall DPI stream count" -gt 0.001 } | Sort-Object { $_."Media failed due to firewall DPI stream count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddforMediaFailedDueToFirewallDPIStreamCount){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddMediaFailedDueToFirewallDPIStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Media failed due to firewall DPI stream count'
            }
            $ddforMediaFailedDueToFirewallDPIStreamCount=$null
        }

        Write-Host '*************** FirewallDPIMediaFailurePercentage Measure****************************'
        #$FirewallDPIMediaFailurePercentage=($latestCalSummry  | where-object { $_.'Firewall DPI Media Failure Percentage' -ne 'NaN' -and $_."Firewall DPI Media Failure Percentage" -gt 0.001 } | Measure-Object "Firewall DPI Media Failure Percentage" -Average | select Average).Average
        $FirewallDPIMediaFailurePercentage=($MediaFailedDueToFirewallDPIStreamCount/$toalStreamsCnt)*100
        if(-not $FirewallDPIMediaFailurePercentage){  $FirewallDPIMediaFailurePercentage=0 }  else { $FirewallDPIMediaFailurePercentage=$FirewallDPIMediaFailurePercentage.ToString("#.##") }

        Write-Host '***************DD for MediaFailedDueToFirewallIPBlockedStreamCount Measure****************************'
        $MediaFailedDueToFirewallIPBlockedStreamCount=($latestCalSummry | where-object { $_.'Media Failed Due To Firewall IP Blocked Stream Count' -ne 'NaN' } | Measure-Object "Media Failed Due To Firewall IP Blocked Stream Count" -Sum | select Sum).Sum
        if($MediaFailedDueToFirewallIPBlockedStreamCount){
            $ddforMediaFailedDueToFirewallIPBlockedStreamCount = $latestCalSummry | Where-Object { $_."Media Failed Due To Firewall IP Blocked Stream Count" -gt 0.001 } | Sort-Object { $_."Media Failed Due To Firewall IP Blocked Stream Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddforMediaFailedDueToFirewallDPIStreamCount){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddMediaFailedDueToFirewallIPBlockedStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Media Failed Due To Firewall IP Blocked Stream Count'
            }
            $ddforMediaFailedDueToFirewallIPBlockedStreamCount=$null
        }

        Write-Host '*************** FirewallIPBlockedMediaFailurePercentage Measure****************************'
        #$FirewallIPBlockedMediaFailurePercentage=($latestCalSummry  | where-object { $_.'Firewall IP Blocked Media Failure Percentage' -ne 'NaN' -and $_."Firewall IP Blocked Media Failure Percentage" -gt 0.001 } | Measure-Object "Firewall IP Blocked Media Failure Percentage" -Average | select Average).Average
        $FirewallIPBlockedMediaFailurePercentage=($MediaFailedDueToFirewallIPBlockedStreamCount/$toalStreamsCnt)*100
        if(-not $FirewallIPBlockedMediaFailurePercentage){  $FirewallIPBlockedMediaFailurePercentage=0 }  else { $FirewallIPBlockedMediaFailurePercentage=$FirewallIPBlockedMediaFailurePercentage.ToString("#.##") }

        Write-Host '***************DD for MediaFailedDueToOtherStreamCount Measure****************************'
        $MediaFailedDueToOtherStreamCount=($latestCalSummry | where-object { $_.'Media Failed Due To Other Stream Count' -ne 'NaN' } | Measure-Object "Media Failed Due To Other Stream Count" -Sum | select Sum).Sum
        if($MediaFailedDueToOtherStreamCount){
            $ddforMediaFailedDueToOtherStreamCount = $latestCalSummry | Where-Object { $_."Media Failed Due To Other Stream Count" -gt 0.001 } | Sort-Object { $_."Media Failed Due To Other Stream Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddforMediaFailedDueToOtherStreamCount){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddMediaFailedDueToOtherStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Media Failed Due To Other Stream Count'
            }
            $ddforMediaFailedDueToOtherStreamCount=$null
        }

        Write-Host '*************** OtherMediaFailurePercentage Measure****************************'
        #$OtherMediaFailurePercentage=($latestCalSummry | where-object { $_.'Other Media Failure Percentage' -ne 'NaN' -and $_."Other Media Failure Percentage" -gt 0.001 } | Measure-Object "Other Media Failure Percentage" -Average | select Average).Average
        $OtherMediaFailurePercentage=($MediaFailedDueToOtherStreamCount/$toalStreamsCnt)*100
        if(-not $OtherMediaFailurePercentage){  $OtherMediaFailurePercentage=0 }  else { $OtherMediaFailurePercentage=$OtherMediaFailurePercentage.ToString("#.##") }
    }
    Write-Host 'measures##' $toalStreamsCnt ~$TotalCDRAvailableStreamCount ~ $TotalMediaFailedStreamCount ~ $TotalCallSetupFailedStreamCount ~ $TotalCallDroppedStreamCount ~ $TotalMediaSucceededStreamCount ~ $TotalCallSetupSucceededStreamCount ~ $TotalCallSetupFailurePercentage ~ $TotalCallDroppedFailurePercentage ~ $TotalAnswerSeizureRatio ~ $TotalShortCallPercentage ~ $TotalMediaFailurePercentage ~ $AvgCallDuration ~ $MediaFailedDueToFirewallDPIStreamCount ~ $FirewallDPIMediaFailurePercentage ~ $MediaFailedDueToFirewallIPBlockedStreamCount ~ $FirewallIPBlockedMediaFailurePercentage ~ $MediaFailedDueToOtherStreamCount ~ $OtherMediaFailurePercentage
}









