﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$mperiodAndIsTeam=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$mperiodAndIsTeam[0].Trim()
$IsTeamsEnabled=$mperiodAndIsTeam[1].Trim()
$rptTimNUPN=$mperiodAndIsTeam[2].Trim()
$rptNam=$TestInputs[3].Trim()
$prxyCrds=$TestInputs[4].ToString().Split('#')
$proxyUsr=$prxyCrds[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyCrds[1]
$proxyserverip=($TestInputs[5]).ToString().trim()
$showPoorStreams=$TestInputs[6]
$showGoodStreams=$TestInputs[7]
#>

$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }


$measures='Measures.Audio Stream Count','Measures.Audio Poor Stream Count','Measures.Audio Good Stream Count','Measures.Audio Unclassified Stream Count','Measures.Audio Poor Percentage','Measures.Audio Poor Due To Jitter Count','Measures.Audio Poor Due To PacketLoss Count','Measures.Audio Poor Due To Degradation Count','Measures.Audio Poor Due To RoundTrip Count','Measures.Audio Poor Due To ConcealedRatio Count'
$Dimentions ='AllStreams.Start Time','AllStreams.End Time','AllStreams.Date','AllStreams.Hour','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.Conference Id','AllStreams.Audio Poor Due To Jitter','AllStreams.Audio Poor Due To RoundTrip','AllStreams.Audio Poor Due To PacketLoss','AllStreams.Audio Poor Due To Degradation','AllStreams.Audio Poor Due To ConcealedRatio','AllStreams.Media Type','AllStreams.ClassifiedPoorCall','AllStreams.Is Teams','AllStreams.First UPN','AllStreams.Second UPN'
$AudioStms=Get-CQDData -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3  | Where-Object { $_.'Media Type' -eq 'Audio' -and ($_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled)} |Sort-Object -Property 'End Time' -Descending

$dir=$egurkhaPath +'\agent\MTM\'+$rptNam
if(!(Test-Path -Path $dir )){
    $null=New-Item -ItemType directory -Path $dir
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$writPath=$dir+'\MTMAudioStrms'+ $timenow +".csv"
$iswrite=$false

$strmsCnt=0
$gdStmsCnt=0
$unclsfyStrmsCnt=0
$obj=$AudioStms| select -First 1
$rptEdTimNUPN=$obj.'End Time'+'#'+$obj.'First UPN'+'#'+$obj.'Second UPN'
if($showGoodStreams -eq 'none'){
    if($rptTimNUPN -ne 'none'){
        foreach($strms in $AudioStms){
            if($iswrite){
                $stmStr=([String]$strms.'Audio Stream Count').Trim()
                if($stmStr -ne $null -and $stmStr -ne '' -and $stmStr -ne 'NaN'){$strmsCnt+=[int]$stmStr}
                $stmGdStr=([String]$strms.'Audio Good Stream Count').Trim()
                if($stmGdStr -ne $null -and $stmGdStr -ne '' -and $stmGdStr -ne 'NaN'){$gdStmsCnt+=[int]$stmGdStr}
                $stmUnClsStr=([String]$strms.'Audio Unclassified Stream Count').Trim()
                if($stmUnClsStr -ne $null -and $stmUnClsStr -ne '' -and $stmUnClsStr -ne 'NaN'){$unclsfyStrmsCnt+=[int]$stmUnClsStr}
                $stmPrStr=([String]$strms.'Audio Poor Stream Count').Trim()
                if($stmPrStr -ne $null -and $stmPrStr -ne '' -and $stmPrStr -ne 'NaN' -and [int]$stmPrStr -gt 0){
                    $strms| Export-Csv $writPath -Append 
                }
            }
            $chktimNam=$strms.'End Time'+'#'+$strms.'First UPN'+'#'+$strms.'Second UPN'
            if($rptTimNUPN -eq $chktimNam){
                $iswrite=$true
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $AudioStms){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $stmStr=([String]$strms.'Audio Stream Count').Trim()
                    if($stmStr -ne $null -and $stmStr -ne '' -and $stmStr -ne 'NaN'){$strmsCnt+=[int]$stmStr}
                    $stmGdStr=([String]$strms.'Audio Good Stream Count').Trim()
                    if($stmGdStr -ne $null -and $stmGdStr -ne '' -and $stmGdStr -ne 'NaN'){$gdStmsCnt+=[int]$stmGdStr}
                    $stmUnClsStr=([String]$strms.'Audio Unclassified Stream Count').Trim()
                    if($stmUnClsStr -ne $null -and $stmUnClsStr -ne '' -and $stmUnClsStr -ne 'NaN'){$unclsfyStrmsCnt+=[int]$stmUnClsStr}
                    $stmPrStr=([String]$strms.'Audio Poor Stream Count').Trim()
                    if($stmPrStr -ne $null -and $stmPrStr -ne '' -and $stmPrStr -ne 'NaN' -and [int]$stmPrStr -gt 0){
                        $strms| Export-Csv $writPath -Append 
                    }
                }
            }
        }
    }
}
else{
    if($rptTimNUPN -ne 'none'){
        foreach($strms in $AudioStms){
            if($iswrite){
                $strms| Export-Csv $writPath -Append
            }
            $chktimNam=$strms.'End Time'+'#'+$strms.'First UPN'+'#'+$strms.'Second UPN'
            if($rptTimNUPN -eq $chktimNam){
                $iswrite=$true
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $AudioStms){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $strms| Export-Csv $writPath -Append  
                }
            }
        }
    }
}
$strcnt='StreamsCnt#'+$strmsCnt+'~'+$gdStmsCnt+'~'+$unclsfyStrmsCnt+'~'+$rptEdTimNUPN
Write-Host $strcnt
Write-Host 'LastReporting WritePath#'$writPath
