﻿<#
    /*****************************************************************************
    Author            :       Mounika Kuna
    Purpose           :       Provides Users Mails and Mailboxes Details
    Created           :       15/09/2020    
    /*****************************************************************************
#>

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$username=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUser=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserver=$TestInputs[4]
$strgLimit=$TestInputs[5]
$toreadDate_UsrsMailbx=[datetime]$TestInputs[6]
$toreadDate_UsrsMailactvty=[datetime]$TestInputs[7]
$toreadDate_UsrsMailAppUsg=[datetime]$TestInputs[8]
$rptNam=$TestInputs[9]
#>

$rptPath=$egurkhaPath+'\agent\EXO\'+$rptNam
if(!(Test-Path -Path $rptPath )){
   $null =  New-Item -ItemType directory -Path $rptPath -WarningAction SilentlyContinue
}
$o365Domain=Eg-GetDomain -userName $username -Password $password -proxyUsr $proxyUser -proxyPass $proxyPass -IsIntial $true -proxyserver $proxyserver

$appId=''
$appSecret=''
$tenantID=''
$authString=''
$resource=''
$typePath=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
Add-Type -Path $typePath

#------Get App Reg Details ------------
$GraphDir=$egurkhaPath+'\agent\O365\MsGraph'
$unProtPath=$GraphDir+'\GraphDetails.dat'
$keyFileNam='\GraphDetailsKey.dat'
$kvalue=Get-Content -Path $GraphDir$keyFileNam
$null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.ini'
$spoGraphDtls=$GraphDir+"\GraphDetails.ini"
$getInputs=Get-Content -Path $spoGraphDtls
Remove-Item $spoGraphDtls
$flag=$false
foreach($input in $getInputs){
    if($input.StartsWith('[') -and $input.ToLower().Contains($o365Domain.ToLower())){
        $flag=$true
    }
    if($flag){
        if($input.Contains("client_id")){$appId=$input.ToString().Substring($input.IndexOf('~')+1)}        
        if($input.Contains("client_secret")){$appSecret=$input.ToString().Substring($input.IndexOf('~')+1)}        
        if($input.Contains("TenantName")){$tenantID=$input.ToString().Substring($input.IndexOf('~')+1)}        
        if($input.Contains("Authority")){
            $authString=$input.ToString().Substring($input.IndexOf('~')+1)
            $authString=$authString+$o365Domain
        }
        if($input.Contains("Resource")){
            $resource=$input.ToString().Substring($input.IndexOf('~')+1)
            $flag=$false
        }
    }         
}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$MailboxUsageDetailCSV=$rptPath+'\MailboxUsageDetail'+$timenow+'.csv'
$url1 = "https://graph.microsoft.com/v1.0/reports/getMailboxUsageDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url1 -filePath $MailboxUsageDetailCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $TotalMailboxUsageDetail=Import-Csv $MailboxUsageDetailCSV
    $url1=$TotalMailboxUsageDetail.'@odata.nextLink'
    if($url1 -eq $null -or $url1 -eq ''){
        break
    }
}
$firstRecord1=$TotalMailboxUsageDetail | select ReportRefreshDate -First 1
$ReportRefreshDate1=($firstRecord1.ReportRefreshDate)
$diffence1=(NEW-TIMESPAN –Start $toreadDate_UsrsMailbx –End $ReportRefreshDate1 | Select-Object Days).Days
if($diffence1 -ge 1){$reportRefreshed1=$true}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$UserEmailActivitiesCSV=$rptPath+'\UserEmailActivities'+$timenow+'.csv'
$url2 = "https://graph.microsoft.com/v1.0/reports/getEmailActivityUserDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url2 -filePath $UserEmailActivitiesCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $UserEmailActivities=Import-Csv $UserEmailActivitiesCSV
    $url2=$UserEmailActivities.'@odata.nextLink'
    if($url2 -eq $null -or $url2 -eq ''){
        break
    }
}
$firstRecord2=$UserEmailActivities | select ReportRefreshDate -First 1
$ReportRefreshDate2=($firstRecord2.ReportRefreshDate)
$diffence2=(NEW-TIMESPAN –Start $toreadDate_UsrsMailactvty –End $ReportRefreshDate2 | Select-Object Days).Days
if($diffence2 -ge 1){$reportRefreshed2=$true}

$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$MailAppUsageCSV=$rptPath+'\MailAppUsage'+$timenow+'.csv'
$url3 = "https://graph.microsoft.com/v1.0/reports/getEmailAppUsageUserDetail(period='D7')"
while($true){
    Eg-InvokeGraphUrl -Url $url3 -filePath $MailAppUsageCSV -appId $appId -appSecret $appSecret -authString $authString -resource $resource
    $TotalMailAppUsage=Import-Csv $MailAppUsageCSV
    $url3=$TotalMailAppUsage.'@odata.nextLink'
    if($url3 -eq $null -or $url3 -eq ''){
        break
    }
}
$firstRecord3=$TotalMailAppUsage | select ReportRefreshDate -First 1
$ReportRefreshDate3=($firstRecord3.ReportRefreshDate)
$diffence3=(NEW-TIMESPAN –Start $toreadDate_UsrsMailAppUsg –End $ReportRefreshDate3 | Select-Object Days).Days
if($diffence3 -ge 1){$reportRefreshed3=$true}

if($reportRefreshed1 -and $reportRefreshed2 -and $reportRefreshed3){
    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsrsMailbx –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsrsMailbx=$toreadDate_UsrsMailbx.AddDays(1) }
        $actualdate=$toreadDate_UsrsMailbx
        $notFirsttime = $true
        $TotalMailboxUsage =$TotalMailboxUsageDetail | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
        if($TotalMailboxUsage)
        {
            Write-Host 'ReadDate of UsersMailbox Data on#'$actualdate.tostring(“yyyy-MM-dd”)
            break
        }
        else
        {
            Write-Host 'thereIs No UsersMailbox Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }

    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsrsMailactvty –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsrsMailactvty=$toreadDate_UsrsMailactvty.AddDays(1) }
        $actualdate=$toreadDate_UsrsMailactvty
        $notFirsttime = $true
        $UserEmailAct =$UserEmailActivities | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
        if($UserEmailAct)
        {
            Write-Host 'ReadDate of UsersMailActivity Data on#'$actualdate.tostring(“yyyy-MM-dd”)
            break
        }
        else
        {
            Write-Host 'thereIs No UsersMailActivity Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }

    $diffence=(NEW-TIMESPAN –Start $toreadDate_UsrsMailAppUsg –End (Get-Date) | Select-Object Days).Days
    $notFirsttime = $false
    while($diffence -ge 1)
    {
        if($notFirsttime){ $toreadDate_UsrsMailAppUsg=$toreadDate_UsrsMailAppUsg.AddDays(1) }
        $actualdate=$toreadDate_UsrsMailAppUsg
        $notFirsttime = $true
        $TotalMailAppUsg =$TotalMailAppUsage | Where-Object { [datetime]$_.ReportRefreshDate -eq $actualdate }       
        if($TotalMailAppUsg)
        {
            Write-Host 'ReadDate of UsersMailAppUsage Data on#'$actualdate.tostring(“yyyy-MM-dd”)
            break
        }
        else
        {
            Write-Host 'thereIs No UsersMailAppUsage Data on#'$actualdate.tostring(“yyyy-MM-dd”)
        }
        $diffence=$diffence-1
    }
}
foreach($User in $TotalMailboxUsage){
    $ItemCount=$User.ItemCount      
    $IssueWarningQuotaLimit=(([math]::Round(([long]$User.StorageUsed/1073741824),2))/([math]::Round(([long]$User.IssueWarningQuota/1073741824),2)))*100
    if($IssueWarningQuotaLimit -ge $strgLimit){ $ReachingIssueWarningQuotaLimit=1 }else{ $ReachingIssueWarningQuotaLimit=0 }   
    $ProhibitSendQuotaLimit=(([math]::Round(([long]$User.StorageUsed/1073741824),2))/([math]::Round(([long]$User.ProhibitSendQuota/1073741824),2)))*100
    if($ProhibitSendQuotaLimit -ge $strgLimit){ $ReachingProhibitSendQuotaLimit=1 }else{ $ReachingProhibitSendQuotaLimit=0 }     
    $ProhibitSendRecvQuotaLimit=(([math]::Round(([long]$User.StorageUsed/1073741824),2))/([math]::Round(([long]$User.'ProhibitSend/ReceiveQuota'/1073741824),2)))*100
    if($ProhibitSendRecvQuotaLimit -ge $strgLimit){ $ReachingProhibitSendRecvQuotaLimit=1 }else{ $ReachingProhibitSendRecvQuotaLimit=0 }
    $DeletedItemCount=$User.DeletedItemCount    
    $UserID=$User.UserPrincipalName
    $Output='info&Measures='+$UserID+'~'+$ItemCount+'~'+[math]::Round(($User.StorageUsed/1073741824),2)+'~'+[math]::Round(($User.IssueWarningQuota/1073741824),2)+'~'+[math]::Round(($User.ProhibitSendQuota/1073741824),2)+'~'+[math]::Round(($User.'ProhibitSend/ReceiveQuota'/1073741824),2)+'~'+$ReachingIssueWarningQuotaLimit+'~'+$ReachingProhibitSendQuotaLimit+'~'+$ReachingProhibitSendRecvQuotaLimit+'~'+$DeletedItemCount+'~'+[math]::Round(($User.DeletedItemSize/1073741824),2)
    Write-Host $Output 
}
Remove-Item $MailboxUsageDetailCSV

foreach($User in $UserEmailAct){
        $AssignedProducts = New-Object -TypeName "System.Collections.ArrayList"
        $UserPrincipalName=$User.UserPrincipalName
        $SendCount=$User.SendCount
        $ReceiveCount=$User.ReceiveCount
        $ReadCount=$User.ReadCount        
        $Output = 'info&Measures='+$UserPrincipalName+'~'+$SendCount+'~'+$ReceiveCount+'~'+$ReadCount
        Write-Host $Output        
}
Remove-Item $UserEmailActivitiesCSV

foreach($Apps in $TotalMailAppUsg){
    #----------------MailForMac ---------------------
    if($Apps.MailForMac -eq ""){$MailForMac = "0"}elseif($Apps.MailForMac -eq "Undetermined"){$MailForMac = "1"}else{$MailForMac="2"}
    #---------------OutlookForMac---------------------
    if($Apps.OutlookForMac -eq ""){$OutlookForMac = "0"}elseif($Apps.OutlookForMac -eq "Undetermined"){$OutlookForMac = "1"}else{$OutlookForMac="2"}             
    #---------------OutlookForWindows---------------------
    if($Apps.OutlookForWindows -eq ""){$OutlookForWindows = "0"}elseif($Apps.OutlookForWindows -eq "Undetermined"){$OutlookForWindows = "1"}else{$OutlookForWindows="2"}        
    #---------------OutlookForMobile---------------------
    if($Apps.OutlookForMobile -eq ""){$OutlookForMobile = "0"}elseif($Apps.OutlookForMobile -eq "Undetermined"){$OutlookForMobile = "1"}else{$OutlookForMobile="2"}
    #---------------OtherForMobile---------------------
    if($Apps.OtherForMobile -eq ""){$OtherForMobile = "0"}elseif($Apps.OtherForMobile -eq "Undetermined"){$OtherForMobile = "1"}else{$OtherForMobile="2"}        
    #---------------OutlookForWeb---------------------
    if($Apps.OutlookForWeb -eq ""){$OutlookForWeb = "0"}elseif($Apps.OutlookForWeb -eq "Undetermined"){$OutlookForWeb = "1"}else{$OutlookForWeb="2"}
    #---------------POP3App---------------------
    if($Apps.POP3App -eq ""){$POP3App = "0"}elseif($Apps.POP3App -eq "Undetermined"){$POP3App = "1"}else{$POP3App="2"}
    #---------------IMAP4App---------------------
    if($Apps.IMAP4App -eq ""){$IMAP4App = "0"}elseif($Apps.IMAP4App -eq "Undetermined"){$IMAP4App = "1"}else{$IMAP4App="2"}
    #---------------SMTPApp---------------------
    if($Apps.SMTPApp -eq ""){$SMTPApp = "0"}elseif($Apps.SMTPApp -eq "Undetermined"){$SMTPApp = "1"}else{$SMTPApp="2"}

$MailAppUsage='info&Measures='+$Apps.UserPrincipalName+'~'+$MailForMac+'~'+$OutlookForMac+'~'+$OutlookForWindows+'~'+$OutlookForMobile+'~'+$OtherForMobile+'~'+$OutlookForWeb+'~'+$POP3App+'~'+$IMAP4App+'~'+$SMTPApp
Write-Host $MailAppUsage
}
Remove-Item $MailAppUsageCSV