﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

$locPath=$egurkhaPath+'\lib\OE.exe'

Import-Module O365ServiceCommunications

#https://www.cogmotive.com/blog/office-365-tips/guest-blog-office-365-health-monitoring-with-powershell
#https://www.anupams.net/monitor-office-365-health-status-using-powershell/

$testargs=$args


$userName=$testargs[0]
$Password=& $locPath $testargs[1]
$testFrequency=$testargs[2]


$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
 


$cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
[System.Net.WebRequest]::DefaultWebProxy.Credentials = $cred  
Connect-MsolService  -Credential -AzureEnvironment $azureEnvArr[0]

$types = "Incident","Maintenance"

$MySession = New-SCSession -Credential $cred

$lastruntime=((Get-date).AddMinutes($testFrequency)).ToUniversalTime()    

$O365Servies = Get-SCServiceInfo -SCSession $MySession
foreach($srvc in $O365Servies)
{
    write-host "ServiceName >>> "$srvc.ServiceName
}

foreach($type in $types)
{

    $serv = Get-SCEvent -EventTypes $type -PastDays 90 -SCSession $MySession  | sort ID, LastUpdatedTime


    $prvSrvcName = "" 
    $prvStartime = "" 
    $prvEndtime = "" 
    $prvlastupdated = "" 

        foreach($incidents in $serv)
        {
            $Status = $incidents.Status
            $ID = $incidents.Id
            $title = $incidents.Title
            $Affected = $incidents.AffectedTenantCount
            $ServiceName=$incidents.AffectedServiceHealthStatus.ServiceName
            $Startime=$incidents.StartTime
            $Endtime =$incidents.EndTime
        
            $lastupdated=$incidents.LastUpdatedTime
            $messages=$incidents.messages.messagetext
            $ServiceFeatureStatus=$incidents.AffectedServiceHealthStatus.ServiceFeatureStatus
            $FeatureName= $ServiceFeatureStatus.FeatureName

            $ServiceHealthCollection = New-Object System.Collections.ArrayList
        
            $finalSrvcHealth = $ServiceFeatureStatus

            if ((($lastupdated -gt $lastruntime) -or ($Endtime -eq $null)) -and ($type -eq "Incident") -and (($Status -eq "Investigating") -or ($Status -eq "Service interruption") -or ($Status -eq "Restoring") -or ($Status -eq "Service degradation") -or ($Status -eq "Extended recovery"))) {
               Write-Host "NOTOKSERVICE>>>>"$type  ~!~  $Status ~!~  $ID ~!~  $title ~!~  $Affected   ~!~  $ServiceName ~!~  $Startime ~!~  $Endtime ~!~  $lastupdated ~!~  $FeatureName ~!~  #$messages "##msage##"
            }elseif (($Endtime -gt $lastruntime) -and ($type -ne "Incident")) {
               Write-Host $type  ~!~  $Status ~!~  $ID ~!~  $title ~!~  $Affected   ~!~  $ServiceName ~!~  $Startime ~!~  $Endtime ~!~  $lastupdated ~!~  $FeatureName ~!~  #$messages "##msage##"
            }
        }
}