﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear
$testargs=$args
$excldMailbox= ($testargs[0]).trim()
$toHideAdminAct=$testargs[1]
$reportingname='EXO\'+$testargs[2]
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value

	    $uniqExcOper=@{}
	    $uniqExcUser=@{}
	    $excClintIP=@{}
	    $uniqexUserips=@{}
	    $uniqexUseropertions=@{}
            $exClintIpOpertns=@{}

    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "nonowneractvts" -keyFileName "knonowneractvts" -EgPath $egurkhaPath
    $datafile=$readfiles[1] -replace (".csv",".dat") 
    $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
    $excAdminAuditLog= import-csv $csvfile | select-object AuditData | Where-Object {$_.AuditData -like '*"LogonType":1*'}
    Remove-Item $csvfile
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'nonowneractvts' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'knonowneractvts' -InputFile $readfiles[4]
    Write-Host "ReadFile:"$readfiles[3]

	    foreach($log in $excAdminAuditLog){
		
		    $data= $log.AuditData | ConvertFrom-Json
            $usermailbox=$data.UserId
            if($toHideAdminAct -eq $true)
            {
                if($usermailbox -eq $excldMailbox)
                {
                    continue
                }
            }

            if($data.ClientIPAddress -eq '::1'){ $data.ClientIPAddress='-'}

		    if($data -ne "" -and $data -ne $null){

		        Write-Host '>TotalOperation' ~!~ $data.CreationTime ~!~ $data.Operation ~!~ $data.ClientIPAddress ~!~ $data.UserId ~!~ $data.OriginatingServer ~!~ $data.Parameters '>'


		    if($uniqExcOper.ContainsKey($data.Operation)){
			    $uniqExcOper[$data.Operation]=[int]$uniqExcOper[$data.Operation]+1
		    }else{
			    $uniqExcOper.Add($data.Operation,1) 
		    }

		    if($uniqExcUser.ContainsKey($data.UserId) -and $uniqexUserips.Contains($data.UserId) -and $uniqexUseropertions.Contains($data.UserId))
            {

                if(($uniqexUserips[$data.UserId]).Contains($data.ClientIPAddress))
                {
                }
                else{
                        $uniqexUserips[$data.UserId].Add($data.ClientIPAddress)
                }
                if(($uniqexUseropertions[$data.UserId]).Contains($data.Operation))
                {
                }
                else{
                       $uniqexUseropertions[$data.UserId].Add($data.Operation)
                }			  

			   [int]$uniqExcUser[$data.UserId]= [int]$uniqExcUser[$data.UserId]+1

		    }
            else{
			     $uniqExcUser.Add($data.UserId,1)
                 $uniqexUserips[$data.UserId]=New-Object System.Collections.ArrayList
                 $uniqexUserips[$data.UserId].Add($data.ClientIPAddress)
                 $uniqexUseropertions[$data.UserId]=New-Object System.Collections.ArrayList
                 $uniqexUseropertions[$data.UserId].Add($data.Operation)
		    }

		    if($excClintIP.ContainsKey($data.ClientIPAddress) -and $exClintIpOpertns.Contains($data.ClientIPAddress)){

                if(($exClintIpOpertns[$data.ClientIPAddress]).Contains($data.Operation))
                {
                }
                else{
                     $exClintIpOpertns[$data.ClientIPAddress].Add($data.Operation)
                }

				
			    $excClintIP[$data.ClientIPAddress]=[int]$excClintIP[$data.ClientIPAddress]+1  
		    }
            else{
                $exClintIpOpertns[$data.ClientIPAddress]=New-Object System.Collections.ArrayList
                $exClintIpOpertns[$data.ClientIPAddress].Add($data.Operation)
			    $excClintIP.Add($data.ClientIPAddress,1)
		    }
		   
		    if($data.ExternalAccess -eq 'true'){
			    Write-Host '>MSAdminOperation' ~!~ $data.CreationTime ~!~ $data.Operation ~!~ $data.ClientIPAddress ~!~ $data.UserId ~!~ $data.OriginatingServer ~!~ $data.Parameters '>'
		    }
		}
	 }


	    foreach($key in $uniqExcOper.keys){
		Write-Host ">UniqueOpeartion" ~!~ $key ~!~ $uniqExcOper[$key] '>'
	    }

	    foreach($key in $uniqExcUser.keys){

            $temp=""
            $isfirst=$true
          
           foreach($ip in $uniqexUserips[$key])
           {
            if($isfirst){
                $temp=$temp+$ip
                $isfirst=$false
            }
            else{ $temp=$temp+','+$ip }

           }
           $isfirst=$true
           $tempoptn=""
           foreach($optn in $uniqexUseropertions[$key])
           {
            if($isfirst){
                $tempoptn=$tempoptn+$optn
                $isfirst=$false
            }
            else{ $tempoptn=$tempoptn+','+$optn } 
                    
           }



		#Write-Host ">UniqueUsers" ~!~ $key ~!~ $temp ~!~ $tempoptn ~!~ $uniqExcUser[$key] '>'
		Write-Host ">UniqueUsers" ~!~ $key ~!~ $temp ~!~ $uniqExcUser[$key] ~!~ $tempoptn  '>'


	    }

	     foreach($key in $excClintIP.keys){
            $temp=""
            $isfirst=$true
           foreach($operation in $exClintIpOpertns[$key])
           {
            if($isfirst){
                $temp=$temp+$operation
                $isfirst=$false
            }
            else{ $temp=$temp+','+$operation } 

           }
		#Write-Host ">UniqueClientIP" ~!~ $key ~!~ $temp ~!~ $excClintIP[$key] '>'
		Write-Host ">UniqueClientIP" ~!~ $key ~!~ $excClintIP[$key] ~!~ $temp  '>'
	    }
