﻿
clear

function Get-INIContent(){
    [CmdletBinding()]
    Param (
    [Parameter(Mandatory=$true, Position=1)]
    [String]$subject, 
    [Parameter(Mandatory=$true, Position=2)]
    [String]$appNam
    )
    Process
    {
        $appVal=''
        $hashAppVal=@{}
        $ischk=$false
        $egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
        $tstIniPath=$egurkhaPath+'\agent\config\O365_Prerequisites.ini'
        $iniContent=get-content -Path $tstIniPath
        $isFound=$false
        for($i=0;$i -lt $iniContent.Length;$i++ ){
            if($appNam -eq 'none'){
                if($iniContent[$i].StartsWith('['+$subject) -and (!$iniContent[$i].StartsWith(';'))){ 
                    $ischk=$true
                    #Write-Host '88888 ' $iniContent[$i]
                    $subNam=($iniContent[$i] -split '-')[1]
                    $val=$subNam.Substring(0,($subNam.length-1)).Trim()
                    $i++
                    $key=($iniContent[$i] -split '=')[1]
                    $hashAppVal.Add($key,$val)
                }
            }else{
                if($iniContent[$i].StartsWith('['+$subject) -and (!$iniContent[$i].StartsWith(';'))){ 
                    $i++
                    while($true){
                        try{
                            $iniArr=$iniContent[$i].Split('=')
                            if($appNam -eq $iniArr[0]){
                                $appVal=$iniArr[1]
                                $isFound=$true
                                break;    
                            }
                        }catch{$isFound=$true;break;}
                            $i++  
                    }
                }
            if($isFound){break;}
            }
        }
        if($ischk){
            return $hashAppVal
        }
        else{
            return $appVal
        }
    }
}

$dwnld=Get-INIContent -subject 'Location' -appNam 'Download'
if($dwnld -ne 'none' -and (Test-Path $dwnld)){
    $DownloadLocation=$dwnld   
}else{
    $DownloadLocation = $env:USERPROFILE+'\downloads\O365\'
}
if(!(Test-Path -Path $DownloadLocation)){
    $null=New-Item -ItemType directory -Path $DownloadLocation
}
$os=[String](Get-WMIObject win32_operatingsystem).Name
$osNam=$os.Substring(0,$os.IndexOf('|')).Trim() #(Microsoft Windows 7 Professional |C:\Windows|\Device\Harddisk0\Partition2)
$csdVersion=(Get-WMIObject win32_operatingsystem).CSDVersion #(Service Pack 1)
$sysType=(Get-WMIObject win32_operatingsystem).OSArchitecture #(64-bit)

Write-Host 'SYSTEM INFO - ' $osNam ' -- ' $csdVersion '--' $sysType
Write-Host 'Download Location - ' $DownloadLocation

#LOG
$lgf=Get-INIContent -subject 'Location' -appNam 'Log'
if($lgf -ne 'none' -and (Test-Path $lgf)){
    $logDir=$lgf   
}else{
    $egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
    $logDir=$egurkhaPath+'\agent\O365'
}
if(!(Test-Path -Path $logDir)){
    $null=New-Item -ItemType directory -Path $logDir
}
$logFile=$logDir+'\Installation.log'
#Remove-Item -Path $logFile
Function O365-WriteLog{
	Param(
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G
    ( "[" + $date + "] - [" + $ReportingName+"]"+" - " + $writString ) | Out-File -FilePath $LogPath -Append
    if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
        if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
            Remove-Item $LogPath1 
        } 
        Rename-Item $LogPath $LogPath1 
    }
}

function Unzip{
    param([string]$zipfile, [string]$outpath)
    #[System.IO.Compression.ZipFile]::ExtractToDirectory($zipfile, $outpath)
    $shell_app=new-object -com shell.application
    $zip_file = $shell_app.namespace($zipfile)
    $destination = $shell_app.namespace($outpath)
    $destination.Copyhere($zip_file.items())
}
O365-WriteLog -writString '*****************************************************************' -LogPath $logFile -ReportingName 'START-1'
O365-WriteLog -writString $osNam ' -- ' $csdVersion '--' $sysType -LogPath $logFile -ReportingName 'SYSTEM INFO'
O365-WriteLog -writString $DownloadLocation -LogPath $logFile -ReportingName 'Download Location'
$isR2=$false
function Chk-OSTypes(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$OSStr       
    )
    Process
    {
        if($OSStr -eq 'AllOS'){
            return $true
        }else{
            $chkOS=$false
            $osArr=$OSStr -split '!'
            foreach($osTyp in $osArr){           
                if($osTyp -match '#' -and $osTyp -notmatch '-'){
                    $osVerArr=$osTyp -split '#'
                    if($osNam -match $osVerArr[0] -and $osNam -match $osVerArr[1]){$chkOS=$true}
                    $isR2=$true
                }elseif($osTyp -match '#' -and $osTyp -match '-'){
                    $osVerArr=$osTyp -split '#'
                    $osHyArr=$osVerArr[1] -split '-'
                    if($osNam -match $osVerArr[0] -and $osNam -match $osHyArr[0] -and $csdVersion -match $osHyArr[1]){$chkOS=$true}
                }elseif($osTyp -notmatch '#' -and $osTyp -match '-'){
                    $osVerArr=$osTyp -split '-'
                    if($osNam -match $osVerArr[0] -and $csdVersion -match $osVerArr[1]){$chkOS=$true}
                }else{
                    if($osNam -match $osTyp){$chkOS=$true}
                }
                if($chkOS){
                    return $true
                }
            }
            return $false   
        }
    }
}

function Chk-Registry(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$RegStr       
    )
    Process
    {
        if($RegStr -eq 'NIL'){
            return $true
        }else{
        $regArr=$RegStr -split '#'
        $regValuesArr=$regArr[1] -split '!'
        $regValues=Get-ItemProperty -Path $regArr[0]
        foreach($regValue in $regValuesArr){
            $valArr=$regValue -split '-'
            $regStr=$valArr[0]
            $curval=[int]$regValues."$regStr"
            $val=[int]$valArr[1]
            if(!($curval -ge $val)){
                return $true
                break;
            }
        }
        return $false
        }
    }
}

function Get-DotNetVer(){
    $releases=Get-ChildItem 'HKLM:\SOFTWARE\Microsoft\NET Framework Setup\NDP' -recurse |Get-ItemProperty -name Version,Release -EA 0 |Where { $_.PSChildName -match '^(?!S)\p{L}'} |Select Release
    $version=0
    foreach($re in $releases){
        $release=$re.Release
        if($release -eq ""){$release=0}else{$release=[int]$release}
        if($release -gt $version){
            $version=$release
        }   
    }
    return $version
}

$preDwnldHash=New-Object System.Collections.Specialized.OrderedDictionary #[ordered]@{}
$installHash=New-Object System.Collections.Specialized.OrderedDictionary #[ordered]@{}

function Proceed-Download(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$APPName, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$APPFile
    )
    Process
    {
        Try{
            if($APPFile -match '#'){
                $arr=$APPFile -split '#'
                $appDst=$arr[0].Substring($arr[0].LastIndexOf('/')+1)
                $dest=$DownloadLocation+$appDst
                if((Get-Host).Version.Major -le 3){
                    $wc=New-Object System.Net.WebClient
                    $wc.DownloadFile($arr[0],$dest)
                }else{
                    $isPresent=Test-Path $dest -PathType Leaf
                    if(!$isPresent){
                        Try{
                            Write-Host $APPName '- Downloading started' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading started' -LogPath $logFile -ReportingName $APPName
                            Start-BitsTransfer -Source $arr[0] -Destination $dest -TransferType Download -Description "Transfering $APPName" -ErrorAction Stop
                            Write-Host $APPName '- Downloading completed' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading completed' -LogPath $logFile -ReportingName $APPName
                        }Catch{
                            Write-Host $APPName '- Downloading not completed or failed' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading not completed or failed' -LogPath $logFile -ReportingName $APPName
                        }
                    }
                }
                Unzip -zipfile $dest -outpath $DownloadLocation
                #$dest=$dest.Replace(".zip",$arr[1])
                #$installHash.Add($dest,$APPName)
            }else{
                $appDst=$APPFile.Substring($APPFile.LastIndexOf('/')+1)
                $dest=$DownloadLocation+$appDst
                if((Get-Host).Version.Major -le 3){
                    $wc=New-Object System.Net.WebClient
                    $wc.DownloadFile($APPFile,$dest)
                }else{
                    $isPresent=Test-Path $dest -PathType Leaf
                    if(!$isPresent){
                        Try{
                            Write-Host $APPName '- Downloading started' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading started' -LogPath $logFile -ReportingName $APPName
                            Start-BitsTransfer -Source $APPFile -Destination $dest -TransferType Download -Description "Transfering $APPName" -ErrorAction Stop
                            Write-Host $APPName '- Downloading completed' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading completed' -LogPath $logFile -ReportingName $APPName
                        }Catch{
                            Write-Host $APPName '- Downloading not completed or failed' -ForegroundColor Green
                            O365-WriteLog -writString 'Downloading not completed or failed' -LogPath $logFile -ReportingName $APPName
                        }
                    }
                }       
            }
        }Catch{
                Write-Host "Download Failed" $Exception.Message -ForegroundColor Red
        }
    }      
}

function EG-Download(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$APPName, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$APPFile
    )
    Process
    {
        if($APPFile -match '#'){
            $arr=$APPFile -split '#'
            $appDst=$arr[0].Substring($arr[0].LastIndexOf('/')+1)
            $dest=$DownloadLocation+$appDst
            $isPresent=Test-Path $dest -PathType Leaf
            if(!$isPresent){
                $preDwnldHash.add($APPName,$APPFile)
            }
            $dest=$dest.Replace(".zip",$arr[1])
        }else{
            $appDst=$APPFile.Substring($APPFile.LastIndexOf('/')+1)
            $dest=$DownloadLocation+$appDst
            $isPresent=Test-Path $dest -PathType Leaf
            if(!$isPresent){
                $preDwnldHash.add($APPName,$APPFile)
            }  
        } 
        $installHash.Add($dest,$APPName)    
    }
}

$dotNetInsVer=0
$currVer=0
function DotNet-Download{
    if ($sysType -match '64-bit'){
        $dotNetVerArr =Get-INIContent -subject 'DotNet' -appNam 'Dotnet_64' 
    }
    if($sysType -match '32-bit'){
        $dotNetVerArr =Get-INIContent -subject 'DotNet' -appNam 'Dotnet_32' 
    }
    $dotNetArr=$dotNetVerArr -split '~'
    foreach($element in $dotNetArr){
        if($isR2){$isR2=$false; continue;}
        $valArr=$element -split '@'
        $currVer=Get-DotNetVer #379393
        $dotNetInsVer=[int]$valArr[2]
        $isOk=Chk-OSTypes -OSStr $valArr[1] 
        if($currVer -lt $dotNetInsVer -and $isOk){
            EG-Download -APPName $valArr[0] -APPFile $valArr[3]  
        }
        
    }
}

$updatOptions=@{}
$updatOptions=Get-INIContent -subject 'Updates' -appNam 'none'
$onames =$updatOptions.Keys
$chkBxStr=''

######***GUI****#######
 $form = New-Object System.Windows.Forms.Form
    $flowlayoutpanel = New-Object System.Windows.Forms.FlowLayoutPanel
    $buttonOK = New-Object System.Windows.Forms.Button
    $textbox1=New-Object System.Windows.Forms.TextBox
    $label1=New-Object System.Windows.Forms.Label
    $textbox2=New-Object System.Windows.Forms.TextBox
    $label2=New-Object System.Windows.Forms.Label

    $textbox3=New-Object System.Windows.Forms.TextBox
    $label3=New-Object System.Windows.Forms.Label
    $textbox4=New-Object System.Windows.Forms.TextBox
    $label4=New-Object System.Windows.Forms.Label
    $label5=New-Object System.Windows.Forms.Label
    
    $totalvalues = ($onames.count)

    $formsize = 225 + (30 * $totalvalues)
    $flowlayoutsize = 10 + (30 * $totalvalues)
    $buttonplacement = 160 + (30 * $totalvalues)

    $script:CheckBoxArray = @()

    $form_Load = {

       foreach($user in $onames){

            $DynamicCheckBox = New-object System.Windows.Forms.CheckBox

            $DynamicCheckBox.Margin = '10, 8, 0, 0'
            $DynamicCheckBox.Name = $user
            $DynamicCheckBox.Size = '200, 22'
            $DynamicCheckBox.Text = "" + $user
            $DynamicCheckBox.TextAlign = 'MiddleLeft'
            $flowlayoutpanel.Controls.Add($DynamicCheckBox)
            $script:CheckBoxArray += $DynamicCheckBox
        }       
    }
    $form.Controls.Add($label5)
    $form.Controls.Add($label1)
    $form.Controls.Add($textbox1)
    $form.Controls.Add($label2)
    $form.Controls.Add($textbox2)
    $form.Controls.Add($label3)
    $form.Controls.Add($textbox3)
    $form.Controls.Add($label4)
    $form.Controls.Add($textbox4)
    $form.Controls.Add($flowlayoutpanel)
    $form.Controls.Add($buttonOK)
    $form.AcceptButton = $buttonOK
    $form.AutoScaleDimensions = '8, 17'
    $form.AutoScaleMode = 'Font'
    $form.ClientSize = "380 , $formsize"
    $form.FormBorderStyle = 'FixedDialog'
    $form.Margin = '5, 5, 5, 5'
    $form.MaximizeBox = $False
    $form.MinimizeBox = $False
    $form.Name = 'form1'
    $form.StartPosition = 'CenterScreen'
    $form.Text = 'O365 Prerequisites'
    $form.add_Load($($form_Load))

    
    $flowlayoutpanel.BorderStyle = 'FixedSingle'
    $flowlayoutpanel.Location = '38, 135'
    $flowlayoutpanel.Margin = '4, 4, 4, 4'
    $flowlayoutpanel.Name = 'flowlayoutpanel1'
    $flowlayoutpanel.AccessibleName = 'flowlayoutpanel1'
    $flowlayoutpanel.Size = "300, $flowlayoutsize"
    $flowlayoutpanel.TabIndex = 1

    $label5.Location="38,15"
    $label5.Anchor="Bottom, Left"
    $label5.Text="&Proxy Details :"
    $label5.Size="100,20"

    $label1.Location="38,40"
    $label1.Anchor="Bottom, Left"
    $label1.Text="&Host IP"
    $label1.Size="60,20"

    $textbox1.Location="105,40"
    $textbox1.Name="ProxyHost"
    $textbox1.Size="120,20"
    $textbox1.Text="none"

    $label2.Location="228,40"
    $label2.Anchor="Bottom, Left"
    $label2.Text="&Port"
    $label2.Size="25,20"

    $textbox2.Location="255,40"
    $textbox2.Name="Port"
    $textbox2.Size="50,20"
    $textbox2.Text="none"

    $label3.Location="38,70"
    $label3.Anchor="Bottom, Left"
    $label3.Text="&Username"
    $label3.Size="60,20"

    $textbox3.Location="105,70"
    $textbox3.Name="ProxyUser"
    $textbox3.Size="200,20"
    $textbox3.Text="none"

    $label4.Location="38,100"
    $label4.Anchor="Bottom, Left"
    $label4.Text="&Password"
    $label4.Size="60,20"

    $textbox4.Location="105,100"
    $textbox4.Name="ProxyPass"
    $textbox4.Size="200,20"
    $textbox4.Text="none"
    $textbox4.PasswordChar='*'

    $buttonOK.Anchor = 'Bottom, Right'
    $buttonOK.DialogResult = 'OK'
    $buttonOK.Location = "150, $buttonplacement"
    $buttonOK.Margin = '4, 4, 4, 4'
    $buttonOK.Name = 'buttonOK'
    $buttonOK.Size = '100, 30'
    $buttonOK.TabIndex = 0
    $buttonOK.Text = '&OK'

    $frmDialog=$form.ShowDialog()
    $isChkdOption=$false
    foreach($cbox in $CheckBoxArray){
        if($cbox.CheckState -eq 'Checked'){
            $isChkdOption=$true
            $chkBxStr=$chkBxStr+'~'+$updatOptions[$cbox.Name]
        }   
    }  
    Remove-Variable checkbox*

if($frmDialog -eq 'OK'){
    $proxyHost=$textbox1.Text
    $proxyPort=$textbox2.Text
    $proxyUsr=$textbox3.Text
    $proxyPass=$textbox4.Text

    if($proxyHost -ne '' -and $proxyHost -ne $null -and $proxyHost -ne 'none' -and $proxyPort -ne '' -and $proxyPort -ne $null -and $proxyPort -ne 'none'){
        $proxyserver='http://'+$proxyHost+':'+$proxyPort
        O365-WriteLog -writString 'Proxy Available in this System '$proxyserver -LogPath $logFile -ReportingName 'SYSTEM'
        [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
        if($proxyUsr -ne '' -and $proxyUsr -ne $null -and $proxyUsr -ne 'none' -and $proxyPass -ne '' -and $proxyPass -ne $null -and $proxyPass -ne 'none'){
            O365-WriteLog -writString 'Proxy credentials are Available in this System ' -LogPath $logFile -ReportingName 'SYSTEM'
            $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
            [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
            [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
        }
    }
    
    O365-WriteLog -writString 'Installations Block Started' -LogPath $logFile -ReportingName 'SYSTEM'

    if((Get-Host).Version.Major -ge 5 -and (Get-Host).Version.Minor -ge 1){
        Write-Host "powershell version -- " (Get-Host).Version
        O365-WriteLog -writString (Get-Host).Version 'version' -LogPath $logFile -ReportingName 'Windows FrameWork'    
    }
    else{
        DotNet-Download
        O365-WriteLog -writString (Get-Host).Version 'version' -LogPath $logFile -ReportingName 'Windows FrameWork'
        if ($sysType -match '64-bit'){
            $winFWArr=Get-INIContent -subject 'WinFW' -appNam 'WinFW_64' 
        }
        if($sysType -match '32-bit'){
            $winFWArr=Get-INIContent -subject 'WinFW' -appNam 'WinFW_64'
        }
        $sss=
        $wmfArr=$winFWArr -split '~'
        foreach($wmf in $wmfArr){
            $wmfValArr=$wmf -split '@'
            $chkOk=Chk-OSTypes -OSStr $wmfValArr[1]
            if($chkOk){
                EG-Download -APPName $wmfValArr[0] -APPFile $wmfValArr[2]
                break;
            }
        }
    }
}

if($isChkdOption){
    foreach($upOpt in $updatOptions.Values){
        if($chkBxStr -match $upOpt){
            if ($sysType -match '64-bit'){
                $cntNam='Update_'+$upOpt+'_64'
                $updatOptArr =Get-INIContent -subject 'Updates' -appNam $cntNam
            }
            if($sysType -match '32-bit'){
                $cntNam='Update_'+$upOpt+'_32'
                $updatOptArr =Get-INIContent -subject 'Updates' -appNam $cntNam 
            }
            $updatOpts=$updatOptArr -split '~'
            foreach($updatOpt in $updatOpts){
                $updatFilesArr=$updatOpt -split '@'
                if($updatFilesArr[0] -match '.Net FrameWork'){
                    DotNet-Download
                }else{
                    $chkOSTyps=Chk-OSTypes -OSStr $updatFilesArr[1]
                    $chkRegs=Chk-Registry -RegStr $updatFilesArr[2]
                    if($chkOSTyps -and $chkRegs){
                        EG-Download -APPName $updatFilesArr[0] -APPFile $updatFilesArr[3]
                    }
                }
            }
        }
    }
}

$proceedInstal=$False
if($preDwnldHash.Count -ne 0){
    $message = @("Download the below?")
    $message+=" "
    foreach($key in $preDwnldHash.Keys){
    $message+=' -> '+$key
    }
    $res=[system.windows.forms.messagebox]::show(($message -join "`n"),"Download",'YesNo')
    if($res -eq 'Yes'){
        foreach($key in $preDwnldHash.Keys){
            Proceed-Download -APPName $key -APPFile $preDwnldHash[$key]
        } 
        $proceedInstal=$true    
    }else{
        Write-Host 'u have cancelled the download ....'
    }
}else{
    $msg = @("Downloads available in")
    $msg+=$DownloadLocation
    $msg+=" "
    $msg+="Proceed with installation?"
    $procdIns=[system.windows.forms.messagebox]::show(($msg -join "`n"),"Download",'YesNo')
    if($procdIns -eq 'Yes'){
        $proceedInstal=$true
    }else{
        Write-Host 'u have cancelled to proceed installation ....'
    }
}

if($proceedInstal){
    if($installHash.Count -ne 0){
        $insMsg=@("Install the below?")
        $insMsg+=" "
        foreach($key in $installHash.Keys){
            $insMsg+=' -> '+$installHash[$key]
        }
        $insRes=[system.windows.forms.messagebox]::show(($insMsg -join "`n"),"Installation",'YesNo')
        if($insRes -eq 'Yes'){
            foreach($key in $installHash.Keys){
            Try{
                Write-Host $installHash[$key]' Installation Started' -ForegroundColor Yellow
                O365-WriteLog -writString 'Installation started' -LogPath $logFile -ReportingName $installHash[$key]
                Start-Process $key -Wait -ErrorAction Stop
                Write-Host $installHash[$key]' Installation process completed' -ForegroundColor Yellow
                O365-WriteLog -writString 'Installation process completed' -LogPath $logFile -ReportingName $installHash[$key]
            }Catch{
                Write-Host 'Installation failed' -ForegroundColor Red
                O365-WriteLog -writString 'Installation process not completed or failed' -LogPath $logFile -ReportingName $installHash[$key]
            }  
        }     
        }else{
            Write-Host 'u have cancelled the installation ....'
        }
    }else{
       [system.windows.forms.messagebox]::show("All Prerequisites are in place","Installation",'Ok')
    }
}


#TESTING
#-------
Write-Host 'Testing ............'
O365-WriteLog -writString 'Testing started ' -LogPath $logFile -ReportingName 'Testing'
#DOTNET
if ($sysType -match '64-bit'){
        $dotNetVerArr =Get-INIContent -subject 'DotNet' -appNam 'Dotnet_64' 
}
if($sysType -match '32-bit'){
    $dotNetVerArr =Get-INIContent -subject 'DotNet' -appNam 'Dotnet_32' 
}
$dotNetArr=$dotNetVerArr -split '~'
foreach($element in $dotNetArr){
    $valArr=$element -split '@'
    $currVer=Get-DotNetVer
    $dotNetInsVer=[int]$valArr[2]
    if($currVer -ge $dotNetInsVer){
        Write-Host $valArr[0] '- installed sucessfully'
        O365-WriteLog -writString '- installed sucessfully' -LogPath $logFile -ReportingName $valArr[0]
    }else{
        Write-Host $valArr[0] '- not installed properly'
        O365-WriteLog -writString '- not installed properly' -LogPath $logFile -ReportingName $valArr[0]
    }
}
#WMF
if((Get-Host).Version.Major -ge 5 -and (Get-Host).Version.Minor -ge 1){
    Write-Host 'WMF 5.1 - installed sucessfully'
    O365-WriteLog -writString '- installed sucessfully' -LogPath $logFile -ReportingName 'WMF 5.1'
}else{
    Write-Host 'WMF 5.1 - not installed properly'
    O365-WriteLog -writString '- not installed properly' -LogPath $logFile -ReportingName 'WMF 5.1'
}
#UPDATES
foreach($upOpt in $updatOptions.Values){
    if($chkBxStr -match $upOpt){
        if($sysType -match '64-bit'){
            $cntNam='Update_'+$upOpt+'_64'
            $updatOptArr =Get-INIContent -subject 'Updates' -appNam $cntNam 
        }
        if($sysType -match '32-bit'){
            $cntNam='Update_'+$upOpt+'_32'
            $updatOptArr =Get-INIContent -subject 'Updates' -appNam $cntNam 
        }
        $updatOpts=$updatOptArr -split '~'
        foreach($updatOpt in $updatOpts){
            $updatFilesArr=$updatOpt -split '@'
            if($updatFilesArr[0] -match '.Net FrameWork'){
                $currVer=Get-DotNetVer
                $dotNetInsVer=[int]$updatFilesArr[2]
                if($currVer -ge $dotNetInsVer){
                    Write-Host $valArr[0] '- installed sucessfully'
                    O365-WriteLog -writString '- installed sucessfully' -LogPath $logFile -ReportingName $valArr[0]
                }else{
                    Write-Host $valArr[0] '- not installed properly'
                    O365-WriteLog -writString '- not installed properly' -LogPath $logFile -ReportingName $valArr[0]
                }
            }else{  
                $chkRegs=Chk-Registry -RegStr $updatFilesArr[2]
                if(!$chkRegs){
                    Write-Host $updatFilesArr[0] '- installed sucessfully'
                    O365-WriteLog -writString '- installed sucessfully' -LogPath $logFile -ReportingName $updatFilesArr[0]
                }else{
                    Write-Host $updatFilesArr[0] '- not installed properly'
                    O365-WriteLog -writString '- not installed properly' -LogPath $logFile -ReportingName $updatFilesArr[0]
                }
            }
        }
    }
}
O365-WriteLog -writString '**************************************************************************' -LogPath $logFile -ReportingName 'END'
#END
# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUaLKwg7iA/W8GKZUSfrSUYKlj
# 1cSggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUM44ZqN1lyQXHPADJlb93yRpw
# IDYwDQYJKoZIhvcNAQEBBQAEggEACkjsus71jl68FAbcql85Rcgk3Mb10+kcKoGd
# tv/uB57FoIHY/09setiqwHxrX00XuY4KpMWhJLyRGnAq+nkPJlHXF7w6MmHJaKJq
# NyKcMrYj8gI5sPnHycXtsYInhkymqAiPbBS+0CA4OHjuvGQtYFxQj0elA/BsFV7Q
# 8dZ+9zypkDZdDRDXEq92fIYSLx3sySiK7zjZtc5x08+iTxciDqbjL/aYb8ys4vyi
# C4T8MFnsetd/X6rAliejoLMg5h9XEiLDJrqULsVBrVyAA1ws7y4gJSHM2A333jK4
# t43Zvr3C8kX/PqaAm5S3tbxKBamsln17JdBRCSzKuaLINe8z/qGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwNzIzMDIwNDEzWjAjBgkqhkiG9w0BCQQxFgQU7fnkTHhWRN6knaFTOUJZ
# uddHr9QwDQYJKoZIhvcNAQEBBQAEggEAAaRiIPq2nJJGILPakHLBBbhwVfUo1JWr
# 8wTVbpvCOA6B+zXeZSizNlfEUeetaK7ZSdbAPsE4DaYbxuLBb5+1sAD7G6HVUpEu
# YtNouaxOGE4M9v0mpcWWj3skEHltIH5crMr93gOe6RlJTjWBOZgw2sKnVZUSu+zP
# gTCtWWWcovTJJk1/n2o0QNYq0RNxTKea9mxR3wkDkwXg6sioGRBrn6HilWp4eFsj
# GhnmYptWbpGRY7bXon9bHEcuE33MJNnLcVKBzkjtDFaWZ7dCKwjz8AisX6H/Tq8N
# xujtzTBt5xQKigpoUIXWSv/cxHRdFRtx9MPa0OpfZTW8Px0IJrcm+w==
# SIG # End signature block
