﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear
$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$repNameCompname=($TestInputs[4]).ToString().Split('#')
$reportingNam=$repNameCompname[0]
$CompType=$repNameCompname[1]

$rptArr=$reportingNam.Split("_")
$rptFoldr=($rptArr[$rptArr.Count-1]).ToLower()
if($rptFoldr -eq 'mtm'){$fldr='MTM'}
elseif($rptFoldr -eq 'sbo'){$fldr='SBO'}
elseif($rptFoldr -eq 'exo'){$fldr='EXO'}
elseif($rptFoldr -eq 'spo'){$fldr='SPO'}
else {$fldr='O365'}

$rptPath=$fldr+'/'+$reportingNam
$LicensesCnt=0


$readmsolLUsr=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365PSmsolAccSku" -keyFileName "kO365PSmsolAccSku" -EgPath $egurkhaPath
$unProtctLUsr=$readmsolLUsr[1] -replace (".csv",".dat") 
$mlUsrPath=Unprotect-File $unProtctLUsr -Algorithm AES -KeyAsPlainText $readmsolLUsr[0]	
$Licenses= import-csv $mlUsrPath
Remove-Item $mlUsrPath

Eg-DeleteFiles -FilePath $readmsolLUsr[2] -Pattern 'O365PSmsolAccSku' -InputFile $readmsolLUsr[3]
Eg-DeleteFiles -FilePath $readmsolLUsr[2] -Pattern 'kO365PSmsolAccSku' -InputFile $readmsolLUsr[4]

if($Licenses.Count -ne $null){
    $LicensesCnt= $Licenses.Count
}else{
    $LicensesCnt=1
}

$readmsolLUsr1=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365PSmsolUsr" -keyFileName "kO365PSmsolUsr" -EgPath $egurkhaPath
$unProtctLUsr1=$readmsolLUsr1[1] -replace (".csv",".dat") 
$mlUsrPath1=Unprotect-File $unProtctLUsr1 -Algorithm AES -KeyAsPlainText $readmsolLUsr1[0]	
$users= import-csv $mlUsrPath1
Remove-Item $mlUsrPath1
Eg-DeleteFiles -FilePath $readmsolLUsr1[2] -Pattern 'O365PSmsolUsr' -InputFile $readmsolLUsr1[3]
Eg-DeleteFiles -FilePath $readmsolLUsr1[2] -Pattern 'kO365PSmsolUsr' -InputFile $readmsolLUsr1[4]

$DisabledHash = @{} 
$PendingActivationHash = @{} 
$PendingProvisionHash = @{} 
$PendingInputHash = @{} 
$OthersHash = @{} 
$SuccessHash= @{}
$measurehash=@{}
$tmpServiceName=$null

$SPOServiceName=@()
$SBOServiceName=@()
$EXOServiceName=@()
$MTMServiceName=@()
$tests=Get-content -Path $egurkhaPath'\agent\config\eg_tests.ini'
$firstEntry=$false
    foreach($testsini in $tests){
        if($testsini -eq '[AGENT_SETTINGS]'){
            $firstEntry=$true
        }
        elseif($testsini.StartsWith("[")){
            $firstEntry=$false
        }
        if($firstEntry){
            if($testsini.StartsWith("ExcludeO365Service")){
                $ExcludeService= $testsini.Split("=")[1].Split(",")
            }
        }
    }

    $firstEntry=$false
    foreach($testsini in $tests){
        if($testsini -eq '[O365_Subscriptions]'){
            $firstEntry=$true
        }
        elseif($testsini.StartsWith("[")){
            $firstEntry=$false
        }
        if($firstEntry){
            if($testsini -ne '[O365_Subscriptions]'){           
                $valAndOpt= $testsini.Split("=")
                $testsini=$testsini.ToUpper()
                $ExternalName=$valAndOpt[0]
                if($ExcludeService -contains ($ExternalName)){
                    continue
                }
                if($testsini.Contains("EXCHANGE")){
                    $EXOServiceName+="$ExternalName"
        	    }
			    elseif($testsini.Contains("LYNC") -or $testsini.Contains("SKYPE")){
                    $SBOServiceName+="$ExternalName"
			    }
			    elseif($testsini.Contains("SHAREPOINT")){
				    $SPOServiceName+="$ExternalName"
			    }
			    elseif($testsini.Contains("MICROSOFT TEAMS")){
				    $MTMServiceName+="$ExternalName"
			    }
            }
        }
    }

    if($CompType -eq 'SBO'){
        $tmpServiceName=$SBOServiceName
    }
    elseif($CompType -eq 'SPO'){
        $tmpServiceName=$SPOServiceName
    }
    elseif($CompType -eq 'EXO'){
        $tmpServiceName=$EXOServiceName
    }
    elseif($CompType -eq 'MTM'){
        $tmpServiceName=$MTMServiceName
    }
    for($k=0; $k -lt $LicensesCnt; $k++){ 
        $LicenseAccountSKUID = $Licenses[$k].AccountSKUID
        $SvcsCnt = $Licenses[$k].Status.split('~').count
        foreach($userstmp in $users){
            $UserAccountSKUID=$userstmp.AccId
                if($LicenseAccountSKUID -eq $UserAccountSKUID){      
                    for($j=0; $j -lt $SvcsCnt; $j++){
                        $ServiceName=$userstmp.ServiceName.Split(' ')
                        $ProvisioningStatus=$userstmp.ProvisioningStatus.Split(' ')
                        $SrvcName = $ServiceName[$j]
                        $SrvcStatus = $ProvisioningStatus[$j]
                        $UserName = $userstmp.UserName
                        $supportFlow=$false
                        if($SrvcName -ne $null -and $tmpServiceName -eq $null){ 
                            $supportFlow=$true
                        }
                        elseif($tmpServiceName -contains ($SrvcName)){
                            $supportFlow=$true
                        }
                        if($supportFlow){
                            $key = $UserName+'~'+$LicenseAccountSKUID+'~'+$SrvcName
                            $licSrvKey = $LicenseAccountSKUID +'~'+$SrvcName
                            $key1 = $LicenseAccountSKUID
                            if($measurehash.ContainsKey($key1)){
                                $tmparr=[int[]]$measurehash[$key1]
                                if($SrvcStatus -eq 'PendingActivation'){ 
                                    $tmparr[0]+=1
                                }
				                elseif ($SrvcStatus -eq 'PendingProvisioning'){ 
                                    $tmparr[1]+=1
                                }
                                elseif($SrvcStatus -eq 'PendingInput'){ 
                                    $tmparr[2]+=1
                                }
                                elseif($SrvcStatus -eq 'Success'){ 
                                    $tmparr[3]+=1
                                }
                                elseif($SrvcStatus -eq 'Disabled'){ 
                                    $tmparr[4]+=1
                                }
                            }
                            else{
                                $Disabledcnt=0
                                $PendingActivationcnt=0
                                $PendingProvisioncnt=0 
                                $PendingInputcnt=0
                                $Successcnt=0
                                if ($SrvcStatus -eq 'PendingProvisioning'){ 
                                    $PendingProvisioncnt=1
                                }
                                elseif($SrvcStatus -eq 'PendingActivation'){ 
                                    $PendingActivationcnt = 1
                                }
                                elseif($SrvcStatus -eq 'PendingInput'){ 
                                    $PendingInputcnt = 1
                                }
                                elseif($SrvcStatus -eq 'Success'){ 
                                    $Successcnt= 1
                                }
                                elseif($SrvcStatus -eq 'Disabled'){ 
                                    $Disabledcnt =1
                                }
                                [int[]]$measurearr =$PendingActivationcnt,$PendingProvisioncnt,$PendingInputcnt,$Successcnt,$Disabledcnt
                                $measurehash.add($key1,$measurearr)
                            }
                        if ($SrvcStatus -eq 'PendingProvisioning'){
                            if($PendingProvisionHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$PendingProvisionHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $PendingProvisionHash.add($licSrvKey, $ddarr)
                            }                              
                        }
                        elseif($SrvcStatus -eq 'PendingActivation'){
                            if($PendingActivationHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$PendingActivationHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $PendingActivationHash.add($licSrvKey, $ddarr)
                            }
                        }
                        elseif($SrvcStatus -eq 'PendingInput'){ 
                            if($PendingInputHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$PendingInputHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $PendingInputHash.add($licSrvKey, $ddarr)
                            }                                
                        }
                        elseif($SrvcStatus -eq 'Success'){
                            if($SuccessHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$SuccessHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $SuccessHash.add($licSrvKey, $ddarr)
                            }
                        }
                        elseif($SrvcStatus -eq 'Disabled'){ 
                            if($DisabledHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$DisabledHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $DisabledHash.add($licSrvKey, $ddarr)
                            }
                        }
                    }
                }
            }
        }
    }
    foreach($Hkey in $PendingActivationHash.keys){
        $HValue = $PendingActivationHash[$Hkey]
        Write-Host 'PendingActivationDD~'$Hkey'~'$HValue 
    }

    foreach($Hkey in $PendingProvisionHash.keys){
        $HValue = $PendingProvisionHash[$Hkey]
        Write-Host 'PendingProvisionDD~'$Hkey'~'$HValue 
    }

    foreach($Hkey in $PendingInputHash.keys){
        $HValue = $PendingInputHash[$Hkey]
        Write-Host 'PendingInputDD~'$Hkey'~'$HValue 
    }
    foreach($Hkey in $SuccessHash.keys){
        $HValue = $SuccessHash[$Hkey]
        Write-Host 'SuccessDD~'$Hkey'~'$HValue 
    }

    foreach($Hkey in $DisabledHash.keys){
        $HValue = $DisabledHash[$Hkey]
        Write-Host 'DisabledtDD~'$Hkey'~'$HValue 
    }
    foreach($Hkey in $measurehash.keys){
        $HValue = $measurehash[$Hkey]
        $HValue =$HValue -join '~'
        Write-Host 'MeasureCnt~'$Hkey '~' $HValue
    }

# SIG # Begin signature block
# MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQU02qiCLHF1mWfwzWQX8UBgA5t
# rIKgghSjMIIE/jCCA+agAwIBAgIQDUJK4L46iP9gQCHOFADw3TANBgkqhkiG9w0B
# AQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFz
# c3VyZWQgSUQgVGltZXN0YW1waW5nIENBMB4XDTIxMDEwMTAwMDAwMFoXDTMxMDEw
# NjAwMDAwMFowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMTCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAMLmYYRnxYr1DQikRcpja1HXOhFCvQp1dU2UtAxQ
# tSYQ/h3Ib5FrDJbnGlxI70Tlv5thzRWRYlq4/2cLnGP9NmqB+in43Stwhd4CGPN4
# bbx9+cdtCT2+anaH6Yq9+IRdHnbJ5MZ2djpT0dHTWjaPxqPhLxs6t2HWc+xObTOK
# fF1FLUuxUOZBOjdWhtyTI433UCXoZObd048vV7WHIOsOjizVI9r0TXhG4wODMSlK
# XAwxikqMiMX3MFr5FK8VX2xDSQn9JiNT9o1j6BqrW7EdMMKbaYK02/xWVLwfoYer
# vnpbCiAvSwnJlaeNsvrWY4tOpXIc7p96AXP4Gdb+DUmEvQECAwEAAaOCAbgwggG0
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsG
# AQUFBwMIMEEGA1UdIAQ6MDgwNgYJYIZIAYb9bAcBMCkwJwYIKwYBBQUHAgEWG2h0
# dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAfBgNVHSMEGDAWgBT0tuEgHf4prtLk
# YaWyoiWyyBc1bjAdBgNVHQ4EFgQUNkSGjqS6sGa+vCgtHUQ23eNqerwwcQYDVR0f
# BGowaDAyoDCgLoYsaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC10cy5jcmwwMqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFz
# c3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGGGGh0dHA6
# Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2VydHMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRFRpbWVzdGFtcGluZ0NB
# LmNydDANBgkqhkiG9w0BAQsFAAOCAQEASBzctemaI7znGucgDo5nRv1CclF0CiNH
# o6uS0iXEcFm+FKDlJ4GlTRQVGQd58NEEw4bZO73+RAJmTe1ppA/2uHDPYuj1UUp4
# eTZ6J7fz51Kfk6ftQ55757TdQSKJ+4eiRgNO/PT+t2R3Y18jUmmDgvoaU+2QzI2h
# F3MN9PNlOXBL85zWenvaDLw9MtAby/Vh/HUIAHa8gQ74wOFcz8QRcucbZEnYIpp1
# FUL1LTI4gdr0YKK6tFL7XOBhJCVPst/JKahzQ1HavWPWH1ub9y4bTxMd90oNcX6X
# t/Q/hOvB46NJofrOp79Wz7pZdmGJX36ntI5nePk2mOHLKNpbh6aKLzCCBTAwggQY
# oAMCAQICEAQJGBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4X
# DTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTAT
# BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
# MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBD
# QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsx
# SRnP0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3Gde2qvCchqXYJawO
# eSg6funRZ9PG+yknx9N7I5TkkSOWkHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJ
# RdQtoaPpiCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/6XzLkqHlOzEc
# z+ryCuRXu0q16XTmK/5sy350OTYNkO/ktU6kqepqCquE86xnTrXE94zRICUj6whk
# PlKWwfIPEvTFjg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+mM6n9Gd8l
# k9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQD
# AgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggrBgEF
# BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
# Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
# Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5k
# aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsME8GA1UdIARI
# MEYwOAYKYIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
# Y2VydC5jb20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7KgqjpepxA8Bg
# +S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzANBgkqhkiG
# 9w0BAQsFAAOCAQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134LYP3DPQ/E
# r4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFOEKTuP3GOYw4TS63XX0R58zYUBor3
# nEZOXP+QsRsHDpEV+7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRHoXpo
# aK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQMJQhCMrI2iiQC/i9yfhzXSUWW
# 6Fkd6fp0ZGuy62ZD2rOwjNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
# 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBTEwggQZoAMCAQICEAqhJdbW
# Mht+QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNV
# BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
# A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
# MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lD
# ZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGln
# aUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQTCCASIwDQYJKoZI
# hvcNAQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0Uz
# URB90Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcuHjvuzKb2Mln+
# X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPu
# XciaC1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287DxgaqwvB8z9
# 8OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgPhH+fMRTWrdXyZMt7HgXQ
# hBlyF/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOCAc4w
# ggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1bjAfBgNVHSMEGDAWgBRF
# 66Kv9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
# /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5BggrBgEFBQcBAQRtMGswJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
# dENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2Ny
# bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBQBgNV
# HSAESTBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cu
# ZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggEB
# AHGVEulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysfDCFa
# KrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIlHsS6HHssIeLWWywUNUME
# aLLbdQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
# 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4UijGHKeZR+WfyMD+NvtQEm
# tmyl7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR7
# 9VYzIi8iNrJLokqV2PWmjlIwggU0MIIEHKADAgECAhAC4RhLEBaeoPexTwPcEzNS
# MA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwHhcNMTgwNzEwMDAw
# MDAwWhcNMjEwOTE1MTIwMDAwWjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
# IEplcnNleTEPMA0GA1UEBxMGSXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9u
# cywgSW5jLjEdMBsGA1UEAxMUZUcgSW5ub3ZhdGlvbnMsIEluYy4wggEiMA0GCSqG
# SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCg23tdYHXL3HC28IY79eKldqWU6RndJx1e
# 6dYI42cHOvJF0KPsL9Zf2zUJTwqSNE8WNZb4E5e+8LhlSrDQB3a4kBfIFjb+VX15
# qhNEUHopvb+0nMbeN7tVy7wzEYmXDM9BCuvqJwQl6oA8UTu+bNOFVt30fWfll2bD
# HbRYIV7ZX2rJVge3v/oZLtYHYLDCNPqJWaIo/wdleCve0dl4ARvu11Cp3n//177w
# ynxqdvxl02AL09CMGZutD/AfeRXrmAov7mRuBG8h+yZjFeJTUgWSritJD61+wO1i
# oGEZ+i95/0a3xlOPHtLh+iu3HBHu2XOL7As7mbwj2ybgjai7Ig5BAgMBAAGjggHF
# MIIBwTAfBgNVHSMEGDAWgBRaxLl7KgqjpepxA8Bg+S32ZXUOWDAdBgNVHQ4EFgQU
# PfJGp2zDpQh118w/CFQy/YBoZEAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoG
# CCsGAQUFBwMDMHcGA1UdHwRwMG4wNaAzoDGGL2h0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9zaGEyLWFzc3VyZWQtY3MtZzEuY3JsMDWgM6Axhi9odHRwOi8vY3JsNC5k
# aWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDBMBgNVHSAERTBDMDcG
# CWCGSAGG/WwDATAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdpY2VydC5j
# b20vQ1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2MCQGCCsGAQUFBzABhhho
# dHRwOi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUHMAKGQmh0dHA6Ly9jYWNl
# cnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1cmVkSURDb2RlU2lnbmlu
# Z0NBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEBCwUAA4IBAQA/VCcnpMRz
# Np4bFWiQyKewpqbWYkH7MOTgH2t+bfWJpl705429H9QkCz7lvSAoFkX02ZNV1rIB
# hXvi9lTkgSVGjn2rqFuD/bRa7ztTKgRiPCu/YPEeCXfPzSmK4uWWah7v28S79ti+
# t4FqbNmYeXLFE/S6zYpF8SwsEfbfLWjMEBMtzfIG76YJ8OD0TVF+GkrIPWIweRsL
# 3ROjpuk6U/093pHhYQAVE4guCbZuh9BmE3hQ0psnW4sK9XY2JRtTv5hILc0/1J2m
# FoMGI6dRaIrwyNMg9luGHdCMjl/fjapxSJHgsbH9n/qmrjDpgdZ3xzVzN7EPvFUK
# ibtlp8I4oVbLMYIERDCCBEACAQEwgYYwcjELMAkGA1UEBhMCVVMxFTATBgNVBAoT
# DERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UE
# AxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBDQQIQAuEY
# SxAWnqD3sU8D3BMzUjAJBgUrDgMCGgUAoHAwEAYKKwYBBAGCNwIBDDECMAAwGQYJ
# KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisGAQQB
# gjcCARUwIwYJKoZIhvcNAQkEMRYEFN7cSrPC2w5mJI9JpJoOIWFQRHMCMA0GCSqG
# SIb3DQEBAQUABIIBAFYyTaMF1YUq2YD591rF6A5Bm/p8LTYNzahU841zcgtDCERe
# TXJbNTGJCSozQfrIXuablrAcokzRYaspLd8NCuRvZaa8gN6Zz69tMaKSDgQN/VQB
# HAMbH/aM9iytklFl79WbsdbPHe4qTyAsOWuh0CEY1ywfgj1NJrFCwDmuKb1kbT3b
# gLw9V3y45YAgA5ytJxistxopf/9bN7fiy+QbwJKFajZWtQvUa7Iz8jdolTpN72TI
# 4O+dcAnWPQScZnEsYs/zGsp6QDizEQRralz23EylLlHGFNPeQPC156+aQt68fri4
# dtZJMJhP/Px0TSvuiqZQqxy8ZlV3vAneq5QdmL2hggIgMIICHAYJKoZIhvcNAQkG
# MYICDTCCAgkCAQEwgYYwcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0
# IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNl
# cnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQQIQDUJK4L46iP9gQCHO
# FADw3TAJBgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkq
# hkiG9w0BCQUxDxcNMjEwMTA0MDU0MTA0WjAjBgkqhkiG9w0BCQQxFgQU8wuhrpqm
# sr6axOVNNRqoI+paOOwwDQYJKoZIhvcNAQEBBQAEggEAoD79ebfJY/xDA4C3jyPJ
# n1Vd9eRhh0yEEL8nltoDW2nZzNp2osyXAxxZyRLfjdpzuULDSBJf5u+KM2R0bX4x
# SJydVIUv6WOkPgKy7tqtLxqh7TsqF/vBsqyiaKmC9oTsR+qoQ3JM68WVgGMPRtIP
# /EfnX9sTGw59XSjnzW6K7LiU8SE+foNVLzrD7hg+MksFLSmyVz0G7RaBsrkqzdwa
# 4nIAos1I2RE/UhaGRFsGfNXBwDEKGqwL1/oU9F+iUq/Y90W1z/6kknB7G+gjMKCI
# LF+YGHO5vD/fQMtDRPIYZ2TTbolmJOd5fLTaWsSUbn2hX2snOTpE1H9b6vUF2B3R
# Kg==
# SIG # End signature block
