﻿##/******************************************************************************
##Author                :   Vishnu V
##Purpose               :   Display the list of services and their status in O365
##Created               :   12/01/2018
##Modified By		    : 

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear

$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$reptnameProxy=($TestInputs[4]).ToString().Split("#")
$reportingNam=$reptnameProxy[0]
$proxyserverip=$reptnameProxy[1]
$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }


$cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
if(!$proxyserverip.Contains('none')){

    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }


Connect-MsolService -Credential $cred -AzureEnvironment $azureEnvArr[0]

$rptArr=$reportingNam.Split("_")
$rptFoldr=($rptArr[$rptArr.Count-1]).ToLower()
if($rptFoldr -eq 'mtm'){$fldr='MTM'}
elseif($rptFoldr -eq 'sbo'){$fldr='SBO'}
elseif($rptFoldr -eq 'exo'){$fldr='EXO'}
elseif($rptFoldr -eq 'spo'){$fldr='SPO'}
else {$fldr='O365'}

$rptPath=$fldr+'/'+$reportingNam
$LicensesCnt=0
 
 #------------------------UserlogTest-----------------------------#
    Try{
        $writArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
        Get-MsolUser -All | select DisplayName,UserPrincipalName,SignInName,Licenses,IsLicensed,UsageLocation,PasswordNeverExpires,BlockCredential,LastPasswordChangeTimestamp,StrongAuthenticationRequirements| ForEach-Object {$val=$_.Licenses.AccountSkuId -join '#';$MFAstate=$_.StrongAuthenticationRequirements.State -join '#';$_ | Add-Member -MemberType NoteProperty -Name 'AccId' -Value $val -PassThru| Add-Member -MemberType NoteProperty -Name 'MFAStatus' -Value $MFAstate -PassThru}  | Export-Csv $writArr[1]
        $null=Protect-File  $writArr[1] -Algorithm AES -KeyAsPlainText $writArr[0] -RemoveSource
    }Catch{Write-Host $_.Exception.Message}

    Try{
        $delUsrWArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365msolDelUsr" -keyFileName "kO365msolDelUsr" -EgPath $egurkhaPath
        Get-MsolUser -All -ReturnDeletedUsers| select UserPrincipalName,SignInName,Licenses,IsLicensed,UsageLocation | ForEach-Object {$val=$_.Licenses.AccountSkuId -join '#';$_ | Add-Member -MemberType NoteProperty -Name 'AccId' -Value $val -PassThru} |Export-Csv $delUsrWArr[1]
        $null=Protect-File  $delUsrWArr[1] -Algorithm AES -KeyAsPlainText $delUsrWArr[0] -RemoveSource
    }Catch{}

    Try{
        $dmUsrWArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365msolDomUsr" -keyFileName "kO365msolDomUsr" -EgPath $egurkhaPath
        Get-MSOLDomain | select Name |Export-Csv $dmUsrWArr[1]
        $null=Protect-File  $dmUsrWArr[1] -Algorithm AES -KeyAsPlainText $dmUsrWArr[0] -RemoveSource
    }Catch{}

 #----------------------------------------------------------------#


 #------------------------Service Provisioning-----------------------------#
  try{
        $writmsolLUsr = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365PSmsolAccSku" -keyFileName "kO365PSmsolAccSku" -EgPath $egurkhaPath
        Get-MsolAccountSku |Select-Object AccountSKUID,ServiceStatus| ForEach-Object {$val=$_.ServiceStatus.ServicePlan.ServiceName -join '~';$_ | Add-Member -MemberType NoteProperty -Name 'Status' -Value $val -PassThru} | Export-Csv -Path $writmsolLUsr[1]
        $null=Protect-File  $writmsolLUsr[1] -Algorithm AES -KeyAsPlainText $writmsolLUsr[0] -RemoveSource
    }Catch{Write-Host $_.Exception.Message}

    Try{
        $writmsolLUsr1 = Eg-WriteFile -ComntRptPath $rptPath -FileName "O365PSmsolUsr" -keyFileName "kO365PSmsolUsr" -EgPath $egurkhaPath


        $sss=Get-MsolUser -All |select UserPrincipalName,Licenses
        
        foreach($dmn in $sss){
            $usr1=$dmn.UserPrincipalName 
            foreach($dn in $dmn.Licenses){
                $valid=$dn| Select-Object -Property @{Name='UserName';Expression={$dmn.UserPrincipalName }},@{Name='AccId';Expression={$dn.AccountSkuId}},@{Name='ServiceName';Expression={$dn.ServiceStatus.ServicePlan.ServiceName}},@{Name='ProvisioningStatus';Expression={$dn.ServiceStatus.ProvisioningStatus}}
                if($valid -ne $null -and $valid -ne ''){
                    $valid|Export-Csv -Append -LiteralPath $writmsolLUsr1[1] #-Force
                }
            }
        }
	$null=Protect-File  $writmsolLUsr1[1] -Algorithm AES -KeyAsPlainText $writmsolLUsr1[0] -RemoveSource
    }Catch{
	Write-Host $_.Exception.Message
	}
 #--------------------------------------------------------------------------#
# SIG # Begin signature block
# MIIZfQYJKoZIhvcNAQcCoIIZbjCCGWoCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUwiixR/7mwmh7l5dwYgOAZxHM
# ecugghSjMIIE/jCCA+agAwIBAgIQDUJK4L46iP9gQCHOFADw3TANBgkqhkiG9w0B
# AQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFz
# c3VyZWQgSUQgVGltZXN0YW1waW5nIENBMB4XDTIxMDEwMTAwMDAwMFoXDTMxMDEw
# NjAwMDAwMFowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMTCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAMLmYYRnxYr1DQikRcpja1HXOhFCvQp1dU2UtAxQ
# tSYQ/h3Ib5FrDJbnGlxI70Tlv5thzRWRYlq4/2cLnGP9NmqB+in43Stwhd4CGPN4
# bbx9+cdtCT2+anaH6Yq9+IRdHnbJ5MZ2djpT0dHTWjaPxqPhLxs6t2HWc+xObTOK
# fF1FLUuxUOZBOjdWhtyTI433UCXoZObd048vV7WHIOsOjizVI9r0TXhG4wODMSlK
# XAwxikqMiMX3MFr5FK8VX2xDSQn9JiNT9o1j6BqrW7EdMMKbaYK02/xWVLwfoYer
# vnpbCiAvSwnJlaeNsvrWY4tOpXIc7p96AXP4Gdb+DUmEvQECAwEAAaOCAbgwggG0
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsG
# AQUFBwMIMEEGA1UdIAQ6MDgwNgYJYIZIAYb9bAcBMCkwJwYIKwYBBQUHAgEWG2h0
# dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAfBgNVHSMEGDAWgBT0tuEgHf4prtLk
# YaWyoiWyyBc1bjAdBgNVHQ4EFgQUNkSGjqS6sGa+vCgtHUQ23eNqerwwcQYDVR0f
# BGowaDAyoDCgLoYsaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC10cy5jcmwwMqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFz
# c3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGGGGh0dHA6
# Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2VydHMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRFRpbWVzdGFtcGluZ0NB
# LmNydDANBgkqhkiG9w0BAQsFAAOCAQEASBzctemaI7znGucgDo5nRv1CclF0CiNH
# o6uS0iXEcFm+FKDlJ4GlTRQVGQd58NEEw4bZO73+RAJmTe1ppA/2uHDPYuj1UUp4
# eTZ6J7fz51Kfk6ftQ55757TdQSKJ+4eiRgNO/PT+t2R3Y18jUmmDgvoaU+2QzI2h
# F3MN9PNlOXBL85zWenvaDLw9MtAby/Vh/HUIAHa8gQ74wOFcz8QRcucbZEnYIpp1
# FUL1LTI4gdr0YKK6tFL7XOBhJCVPst/JKahzQ1HavWPWH1ub9y4bTxMd90oNcX6X
# t/Q/hOvB46NJofrOp79Wz7pZdmGJX36ntI5nePk2mOHLKNpbh6aKLzCCBTAwggQY
# oAMCAQICEAQJGBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4X
# DTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTAT
# BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
# MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBD
# QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsx
# SRnP0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3Gde2qvCchqXYJawO
# eSg6funRZ9PG+yknx9N7I5TkkSOWkHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJ
# RdQtoaPpiCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/6XzLkqHlOzEc
# z+ryCuRXu0q16XTmK/5sy350OTYNkO/ktU6kqepqCquE86xnTrXE94zRICUj6whk
# PlKWwfIPEvTFjg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+mM6n9Gd8l
# k9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQD
# AgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggrBgEF
# BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
# Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
# Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5k
# aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsME8GA1UdIARI
# MEYwOAYKYIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
# Y2VydC5jb20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7KgqjpepxA8Bg
# +S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzANBgkqhkiG
# 9w0BAQsFAAOCAQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134LYP3DPQ/E
# r4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFOEKTuP3GOYw4TS63XX0R58zYUBor3
# nEZOXP+QsRsHDpEV+7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRHoXpo
# aK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQMJQhCMrI2iiQC/i9yfhzXSUWW
# 6Fkd6fp0ZGuy62ZD2rOwjNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
# 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBTEwggQZoAMCAQICEAqhJdbW
# Mht+QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNV
# BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
# A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
# MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lD
# ZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGln
# aUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQTCCASIwDQYJKoZI
# hvcNAQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0Uz
# URB90Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcuHjvuzKb2Mln+
# X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPu
# XciaC1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287DxgaqwvB8z9
# 8OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgPhH+fMRTWrdXyZMt7HgXQ
# hBlyF/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOCAc4w
# ggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1bjAfBgNVHSMEGDAWgBRF
# 66Kv9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
# /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5BggrBgEFBQcBAQRtMGswJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
# dENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2Ny
# bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBQBgNV
# HSAESTBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cu
# ZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggEB
# AHGVEulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysfDCFa
# KrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIlHsS6HHssIeLWWywUNUME
# aLLbdQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
# 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4UijGHKeZR+WfyMD+NvtQEm
# tmyl7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR7
# 9VYzIi8iNrJLokqV2PWmjlIwggU0MIIEHKADAgECAhAC4RhLEBaeoPexTwPcEzNS
# MA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwHhcNMTgwNzEwMDAw
# MDAwWhcNMjEwOTE1MTIwMDAwWjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
# IEplcnNleTEPMA0GA1UEBxMGSXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9u
# cywgSW5jLjEdMBsGA1UEAxMUZUcgSW5ub3ZhdGlvbnMsIEluYy4wggEiMA0GCSqG
# SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCg23tdYHXL3HC28IY79eKldqWU6RndJx1e
# 6dYI42cHOvJF0KPsL9Zf2zUJTwqSNE8WNZb4E5e+8LhlSrDQB3a4kBfIFjb+VX15
# qhNEUHopvb+0nMbeN7tVy7wzEYmXDM9BCuvqJwQl6oA8UTu+bNOFVt30fWfll2bD
# HbRYIV7ZX2rJVge3v/oZLtYHYLDCNPqJWaIo/wdleCve0dl4ARvu11Cp3n//177w
# ynxqdvxl02AL09CMGZutD/AfeRXrmAov7mRuBG8h+yZjFeJTUgWSritJD61+wO1i
# oGEZ+i95/0a3xlOPHtLh+iu3HBHu2XOL7As7mbwj2ybgjai7Ig5BAgMBAAGjggHF
# MIIBwTAfBgNVHSMEGDAWgBRaxLl7KgqjpepxA8Bg+S32ZXUOWDAdBgNVHQ4EFgQU
# PfJGp2zDpQh118w/CFQy/YBoZEAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoG
# CCsGAQUFBwMDMHcGA1UdHwRwMG4wNaAzoDGGL2h0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9zaGEyLWFzc3VyZWQtY3MtZzEuY3JsMDWgM6Axhi9odHRwOi8vY3JsNC5k
# aWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDBMBgNVHSAERTBDMDcG
# CWCGSAGG/WwDATAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdpY2VydC5j
# b20vQ1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2MCQGCCsGAQUFBzABhhho
# dHRwOi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUHMAKGQmh0dHA6Ly9jYWNl
# cnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1cmVkSURDb2RlU2lnbmlu
# Z0NBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEBCwUAA4IBAQA/VCcnpMRz
# Np4bFWiQyKewpqbWYkH7MOTgH2t+bfWJpl705429H9QkCz7lvSAoFkX02ZNV1rIB
# hXvi9lTkgSVGjn2rqFuD/bRa7ztTKgRiPCu/YPEeCXfPzSmK4uWWah7v28S79ti+
# t4FqbNmYeXLFE/S6zYpF8SwsEfbfLWjMEBMtzfIG76YJ8OD0TVF+GkrIPWIweRsL
# 3ROjpuk6U/093pHhYQAVE4guCbZuh9BmE3hQ0psnW4sK9XY2JRtTv5hILc0/1J2m
# FoMGI6dRaIrwyNMg9luGHdCMjl/fjapxSJHgsbH9n/qmrjDpgdZ3xzVzN7EPvFUK
# ibtlp8I4oVbLMYIERDCCBEACAQEwgYYwcjELMAkGA1UEBhMCVVMxFTATBgNVBAoT
# DERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UE
# AxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBDQQIQAuEY
# SxAWnqD3sU8D3BMzUjAJBgUrDgMCGgUAoHAwEAYKKwYBBAGCNwIBDDECMAAwGQYJ
# KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisGAQQB
# gjcCARUwIwYJKoZIhvcNAQkEMRYEFBvf4+pZmUM09sn2gA2QARhuUkgLMA0GCSqG
# SIb3DQEBAQUABIIBADMYoor6DwNbagvO211DNU+FDUTaTWn+NTW4bGAHmyg8BhEX
# tDEbuT/Aceek3s8Ly20Yaey+H4DE+vwiglowKPFd7NxWF2MiHKu6LaMTpvSuLeT+
# +NNqwtpd/mw7s9ovLWKOOS/59SHu1Ru0zKyzRrd0bajmUS0F80a6uU6GG5H2z4OY
# S9/gWDqW5gIetkgHS/lFy4DphhYnpBPZEy3yG/zkg+zSoy4iLX4iwc/5lK8HRqYe
# teCXiIlzic6akLVdSEF0jtHEzMySZ0Z5W9Um+2Ov7PfbaddSRmLqgR3ZWWs8b4eO
# 2DI5u/kGcJ02n/NZJdPq6urWycOqj201kPpsyk6hggIgMIICHAYJKoZIhvcNAQkG
# MYICDTCCAgkCAQEwgYYwcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0
# IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNl
# cnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQQIQDUJK4L46iP9gQCHO
# FADw3TAJBgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkq
# hkiG9w0BCQUxDxcNMjEwMTA0MDU0MTA0WjAjBgkqhkiG9w0BCQQxFgQU/ArHrpY1
# xP3U968EL7eIao3d1/QwDQYJKoZIhvcNAQEBBQAEggEAIFa8Ry+Sy8YnNT6INdqO
# iVGs6hXs3chkBUCZLaNJxNBRBIVFCx6x9X+YBFxk0kSSoY2MNBEnYhkzSpPyGX9i
# tLj46LC8dYAzG964QEntTQUGzJYbgU8crUynaiETdJESNoeO24SIQ0hsihazpPqO
# QEVy+3Xi2VjJoQ0I27cHnrTwoiSEVjvPuMgdSU1yutC83SnQ2sJrQLGpkTv3R3Uy
# FcOKkuwpyqINWktgm61TcPYzBW50uXc7RknOhzZtyywzsQghRaLUd+gXCcBNxxRR
# 2xQRrE9EXwGKRrzy+zfMz8UqVlOd3QG2y1MAWLouRJFswY1erzlG3x8nonaHGN3p
# ew==
# SIG # End signature block
