﻿Function Get-LocalTime(){
	[CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$dat, 
        [Parameter(Mandatory=$true, Position=2)]
        [String]$hr
    )
    Process
    {
        $ltimArr=@()
        $UTCTime=[DateTime]$dat
        $UTCTime=$UTCTime.AddHours([int]$hr)
        $strCurrentTimeZone = (Get-WmiObject win32_timezone).StandardName
        $TZ = [System.TimeZoneInfo]::FindSystemTimeZoneById($strCurrentTimeZone)
        $LocalTime = [System.TimeZoneInfo]::ConvertTimeFromUtc($UTCTime, $TZ)
        $ltimArr+='{0:yyyy-MM-dd}' -f $LocalTime
        $ltimArr+=(Get-Date $LocalTime).Hour
        Return $ltimArr
    }
}
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$mperiodAndIsTeam=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$mperiodAndIsTeam[0].Trim()
$IsTeamsEnabled=$mperiodAndIsTeam[1].Trim()
$rptTimNUPN=$mperiodAndIsTeam[2].Trim()
$prxyCrds=$TestInputs[3].ToString().Split('#')
$proxyUsr=$prxyCrds[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyCrds[1]
$proxyserverip=($TestInputs[4]).ToString().trim()
$shwTopNDD=[int]$TestInputs[5]
#>

$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2

$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }
$measures='Measures.Total Stream Count','Measures.Total CDR Available Stream Count','Measures.Total Media Failed Stream Count','Measures.Total Call Setup Failed Stream Count','Measures.Total Call Dropped Stream Count','Measures.Total Media Succeeded Stream Count','Measures.Total Call Setup Succeeded Stream Count','Measures.Total Call Setup Failure Percentage','Measures.Total Call Dropped Failure Percentage','Measures.Total Answer Seizure Ratio','Measures.Total Short Call Percentage','Measures.Total Media Failure Percentage','Measures.Avg Call Duration','Measures.Media Failed Due To Firewall DPI Stream Count','Measures.Firewall DPI Media Failure Percentage','Measures.Media Failed Due To Firewall IP Blocked Stream Count','Measures.Firewall IP Blocked Media Failure Percentage','Measures.Media Failed Due To Other Stream Count','Measures.Other Media Failure Percentage'
$Dimentions ='AllStreams.Start Time','AllStreams.End Time','AllStreams.Date','AllStreams.Hour','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.Conference Id','AllStreams.Is Teams','AllStreams.First UPN','AllStreams.Second UPN'
$CalSummryStrms=Get-CQDData -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat  -Measures $measures -OutPutType DataTable -username $username -password $password -CQDVer V3 | Where-Object {$_.'Is Teams' -eq '1' -or $_.'Is Teams' -eq $IsTeamsEnabled} | Sort-Object -Property 'End Time' -Descending
$latestCalSummry=@()
if($rptTimNUPN -ne 'none'){
    foreach($strms in $CalSummryStrms){
	if(([String]$strms.'First UPN').Trim() -eq '-' -and ([String]$strms.'Second UPN').Trim() -eq '-'){continue;}
        if($iswrite){
            $latestCalSummry+=$strms
        }
        $chktimNam=$strms.'End Time'+'#'+$strms.'First UPN'+'#'+$strms.'Second UPN'
        if($rptTimNUPN -eq $chktimNam){
            $iswrite=$true
        }
    }
}
if(!$iswrite){
    foreach($strms in $CalSummryStrms){
	if(([String]$strms.'First UPN').Trim() -eq '-' -and ([String]$strms.'Second UPN').Trim() -eq '-'){continue;}
        $cmprTime=[DateTime][String]$strms.'End Time'
        $cmprTime=$cmprTime.ToUniversalTime()
        if($cmprTime -ne ''){
            if($dat1 -lt $cmprTime){
                $latestCalSummry+=$strms 
            }
        }
    }
}
$lastObj=$CalSummryStrms |Select-Object -First 1
$rptEdTimNUPN='LastReporting EndTime and UPN#'+$lastObj.'End Time'+'~'+$lastObj.'First UPN'+'~'+$lastObj.'Second UPN'
Write-Host $rptEdTimNUPN

if($latestCalSummry){
    $toalStreamsCnt=0
    $TotalCDRAvailableStreamCount=0
    $TotalMediaFailedStreamCount=0
    $TotalCallSetupFailedStreamCount=0
    $TotalCallDroppedStreamCount=0
    $TotalMediaSucceededStreamCount=0
    $TotalCallSetupSucceededStreamCount=0
    $TotalCallSetupFailurePercentage=0
    $TotalCallDroppedFailurePercentage=0
    $TotalAnswerSeizureRatio=0
    $TotalShortCallPercentage=0
    $TotalMediaFailurePercentage=0
    $AvgCallDuration=0
    $MediaFailedDueToFirewallDPIStreamCount=0
    $FirewallDPIMediaFailurePercentage=0
    $MediaFailedDueToFirewallIPBlockedStreamCount=0
    $FirewallIPBlockedMediaFailurePercentage=0
    $MediaFailedDueToOtherStreamCount=0
    $OtherMediaFailurePercentage=0


    $toalStreamsCnt=($latestCalSummry | where-object { $_.'Total Stream Count' -ne 'NaN' } | Measure-Object "Total Stream Count" -Sum | select Sum).Sum
    if($toalStreamsCnt){
        $TotalCDRAvailableStreamCount=($latestCalSummry | where-object { $_.'Total CDR Available Stream Count' -ne 'NaN' } | Measure-Object "Total CDR Available Stream Count" -Sum | select Sum).Sum

        Write-Host '***************DD for TotalMediaFailedStreamCount Measure****************************'
        $TotalMediaFailedStreamCount=($latestCalSummry | where-object { $_.'Total Media Failed Stream Count' -ne 'NaN' } | Measure-Object "Total Media Failed Stream Count" -Sum | select Sum).Sum
        if($TotalMediaFailedStreamCount){
            $ddforFailedstreams = $latestCalSummry | Where-Object { $_."Total Media Failed Stream Count" -gt 0.001 } | Sort-Object { $_."Total Media Failed Stream Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddforFailedstreams){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                #Write-Host 'ddTotalMediaFailedStreamCount#' $ltimArr[0] ~!~ $ltimArr[1] ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id' ~!~ $in.'Total Media Failed Stream Count'
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddTotalMediaFailedStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address' ~!~ $in.'Conference Id' ~!~ $in.'Total Media Failed Stream Count'
            }
            $ddforFailedstreams=$null
        }

        Write-Host '***************DD for TotalCallSetupFailedStreamCount Measure****************************'
        $TotalCallSetupFailedStreamCount=($latestCalSummry  | where-object { $_.'Total Call Setup Failed Stream Count' -ne 'NaN' } | Measure-Object "Total Call Setup Failed Stream Count" -Sum | select Sum).Sum
        if($TotalCallSetupFailedStreamCount){
            $ddforTotalCalFiledstreams = $latestCalSummry | Where-Object { $_."Total Call Setup Failed Stream Count" -gt 0.001 } | Sort-Object { $_."Total Call Setup Failed Stream Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddforTotalCalFiledstreams){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddTotalCallSetupFailedStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Total Call Setup Failed Stream Count'
            }
            $ddforTotalCalFiledstreams=$null
        }

        Write-Host '***************DD for TotalCallDroppedStreamCount Measure****************************'
        $TotalCallDroppedStreamCount=($latestCalSummry  | where-object { $_.'Total Call Dropped Stream Count' -ne 'NaN' } | Measure-Object "Total Call Dropped Stream Count" -Sum | select Sum).Sum
        if($TotalCallDroppedStreamCount){
            $ddforTotalCallDroppedStreamCount = $latestCalSummry | Where-Object { $_."Total Call Dropped Stream Count" -gt 0.001 } | Sort-Object { $_."Total Call Dropped Stream Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddforTotalCallDroppedStreamCount){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddTotalCallDroppedStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Total Call Dropped Stream Count'
            }
            $ddforTotalCallDroppedStreamCount=$null
        }

        $TotalMediaSucceededStreamCount=($latestCalSummry | where-object { $_.'Total Media Succeeded Stream Count' -ne 'NaN' } | Measure-Object "Total Media Succeeded Stream Count" -Sum | select Sum).Sum
        $TotalCallSetupSucceededStreamCount=($latestCalSummry | where-object { $_.'Total Call Setup Succeeded Stream Count' -ne 'NaN' } | Measure-Object "Total Call Setup Succeeded Stream Count" -Sum | select Sum).Sum

        Write-Host '***************TotalCallSetupFailurePercentage Measure****************************'
        #$TotalCallSetupFailurePercentage=($latestCalSummry | where-object { $_.'Total Call Setup Failure Percentage' -ne 'NaN' -and $_."Total Call Setup Failure Percentage" -gt 0.001 } | Measure-Object "Total Call Setup Failure Percentage" -Average | select Average).Average
        $TotalCallSetupFailurePercentage=($TotalCallSetupFailedStreamCount/$toalStreamsCnt)*100
        if(-not $TotalCallSetupFailurePercentage){  $TotalCallSetupFailurePercentage=0 }  else { $TotalCallSetupFailurePercentage=$TotalCallSetupFailurePercentage.ToString("#.##") }

        Write-Host '***************TotalCallDroppedFailurePercentage Measure****************************'
        #$TotalCallDroppedFailurePercentage=($latestCalSummry | where-object { $_.'Total Call Dropped Failure Percentage' -ne 'NaN' -and $_."Total Call Dropped Failure Percentage" -gt 0.001 } | Measure-Object "Total Call Dropped Failure Percentage" -Average | select Average).Average
        $TotalCallDroppedFailurePercentage=($TotalCallDroppedStreamCount/$toalStreamsCnt)*100
        if(-not $TotalCallDroppedFailurePercentage){  $TotalCallDroppedFailurePercentage=0 }  else { $TotalCallDroppedFailurePercentage=$TotalCallDroppedFailurePercentage.ToString("#.##") }

        $TotalAnswerSeizureRatio=($latestCalSummry  | where-object { $_.'Total Answer Seizure Ratio' -ne 'NaN' } | Measure-Object "Total Answer Seizure Ratio" -Sum | select Sum).Sum

        Write-Host '***************TotalShortCallPercentage Measure************************************************'
        $totalshortcallcount=0
        $TotalShortCallPercentagelist=($latestCalSummry | where-object { $_.'Total Short Call Percentage' -ne 'NaN' -and $_."Total Short Call Percentage" -gt 0.001 } ) | Select-Object 'Total Stream Count','Total Short Call Percentage' #| Measure-Object "Total Short Call Percentage" -Average | select Average).Average
        foreach($input in $TotalShortCallPercentagelist){
            $totalshortcallcount=$totalshortcallcount+(([float]$input.'Total Short Call Percentage')*([float]$input.'Total Stream Count'))/100
        }
        $TotalShortCallPercentage=($totalshortcallcount/$toalStreamsCnt)*100
        if(-not $TotalShortCallPercentage){  $TotalShortCallPercentage=0 }  else { $TotalShortCallPercentage=$TotalShortCallPercentage.ToString("#.##") }

        Write-Host '***************TotalMediaFailurePercentage Measure****************************'
        <#
        $TotalMediaFailurePercentage=($latestCalSummry | where-object { $_.'Total Media Failure Percentage' -ne 'NaN' -and $_."Total Media Failure Percentage" -gt 0.001 } | Measure-Object "Total Media Failure Percentage" -Average | select Average).Average
        #>
        $TotalMediaFailurePercentage=($TotalMediaFailedStreamCount/$toalStreamsCnt)*100
        if(-not $TotalMediaFailurePercentage){  $TotalMediaFailurePercentage=0 }  else { $TotalMediaFailurePercentage=$TotalMediaFailurePercentage.ToString("#.##") }

        $AvgCallDuration=($latestCalSummry | where-object { $_.'Avg Call Duration' -ne 'NaN' -and $_."Avg Call Duration" -gt 0.001 } | Measure-Object "Avg Call Duration" -Average | select Average).Average
        if(-not $AvgCallDuration){  $AvgCallDuration=0 }  else { $AvgCallDuration=$AvgCallDuration.ToString("#.##") }

        Write-Host '***************DD for MediaFailedDueToFirewallDPIStreamCount Measure****************************'
        $MediaFailedDueToFirewallDPIStreamCount=($latestCalSummry | where-object { $_.'Media failed due to firewall DPI stream count' -ne 'NaN' } | Measure-Object "Media failed due to firewall DPI stream count" -Sum | select Sum).Sum
        if($MediaFailedDueToFirewallDPIStreamCount){
            $ddforMediaFailedDueToFirewallDPIStreamCount = $latestCalSummry | Where-Object { $_."Media failed due to firewall DPI stream count" -gt 0.001 } | Sort-Object { $_."Media failed due to firewall DPI stream count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddforMediaFailedDueToFirewallDPIStreamCount){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddMediaFailedDueToFirewallDPIStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Media failed due to firewall DPI stream count'
            }
            $ddforMediaFailedDueToFirewallDPIStreamCount=$null
        }

        Write-Host '*************** FirewallDPIMediaFailurePercentage Measure****************************'
        #$FirewallDPIMediaFailurePercentage=($latestCalSummry  | where-object { $_.'Firewall DPI Media Failure Percentage' -ne 'NaN' -and $_."Firewall DPI Media Failure Percentage" -gt 0.001 } | Measure-Object "Firewall DPI Media Failure Percentage" -Average | select Average).Average
        $FirewallDPIMediaFailurePercentage=($MediaFailedDueToFirewallDPIStreamCount/$toalStreamsCnt)*100
        if(-not $FirewallDPIMediaFailurePercentage){  $FirewallDPIMediaFailurePercentage=0 }  else { $FirewallDPIMediaFailurePercentage=$FirewallDPIMediaFailurePercentage.ToString("#.##") }

        Write-Host '***************DD for MediaFailedDueToFirewallIPBlockedStreamCount Measure****************************'
        $MediaFailedDueToFirewallIPBlockedStreamCount=($latestCalSummry | where-object { $_.'Media Failed Due To Firewall IP Blocked Stream Count' -ne 'NaN' } | Measure-Object "Media Failed Due To Firewall IP Blocked Stream Count" -Sum | select Sum).Sum
        if($MediaFailedDueToFirewallIPBlockedStreamCount){
            $ddforMediaFailedDueToFirewallIPBlockedStreamCount = $latestCalSummry | Where-Object { $_."Media Failed Due To Firewall IP Blocked Stream Count" -gt 0.001 } | Sort-Object { $_."Media Failed Due To Firewall IP Blocked Stream Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddforMediaFailedDueToFirewallDPIStreamCount){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddMediaFailedDueToFirewallIPBlockedStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Media Failed Due To Firewall IP Blocked Stream Count'
            }
            $ddforMediaFailedDueToFirewallIPBlockedStreamCount=$null
        }

        Write-Host '*************** FirewallIPBlockedMediaFailurePercentage Measure****************************'
        #$FirewallIPBlockedMediaFailurePercentage=($latestCalSummry  | where-object { $_.'Firewall IP Blocked Media Failure Percentage' -ne 'NaN' -and $_."Firewall IP Blocked Media Failure Percentage" -gt 0.001 } | Measure-Object "Firewall IP Blocked Media Failure Percentage" -Average | select Average).Average
        $FirewallIPBlockedMediaFailurePercentage=($MediaFailedDueToFirewallIPBlockedStreamCount/$toalStreamsCnt)*100
        if(-not $FirewallIPBlockedMediaFailurePercentage){  $FirewallIPBlockedMediaFailurePercentage=0 }  else { $FirewallIPBlockedMediaFailurePercentage=$FirewallIPBlockedMediaFailurePercentage.ToString("#.##") }

        Write-Host '***************DD for MediaFailedDueToOtherStreamCount Measure****************************'
        $MediaFailedDueToOtherStreamCount=($latestCalSummry | where-object { $_.'Media Failed Due To Other Stream Count' -ne 'NaN' } | Measure-Object "Media Failed Due To Other Stream Count" -Sum | select Sum).Sum
        if($MediaFailedDueToOtherStreamCount){
            $ddforMediaFailedDueToOtherStreamCount = $latestCalSummry | Where-Object { $_."Media Failed Due To Other Stream Count" -gt 0.001 } | Sort-Object { $_."Media Failed Due To Other Stream Count" -as [int] } -Descending | select -First $shwTopNDD
            foreach($in in $ddforMediaFailedDueToOtherStreamCount){
                #$ltimArr=Get-LocalTime -dat $in.Date -hr $in.Hour
                $strtTim=($in.'Start Time').Replace('T',' ');$strtTim=$strtTim.Replace('Z','')
                $endTim=($in.'End Time').Replace('T',' ');$endTim=$endTim.Replace('Z','')
                Write-Host 'ddMediaFailedDueToOtherStreamCount#' $strtTim ~!~ $endTim ~!~ $in.'First UPN' ~!~ $in.'Second UPN' ~!~ $in.'First IP Address' ~!~ $in.'Second IP Address'  ~!~ $in.'Conference Id' ~!~ $in.'Media Failed Due To Other Stream Count'
            }
            $ddforMediaFailedDueToOtherStreamCount=$null
        }

        Write-Host '*************** OtherMediaFailurePercentage Measure****************************'
        #$OtherMediaFailurePercentage=($latestCalSummry | where-object { $_.'Other Media Failure Percentage' -ne 'NaN' -and $_."Other Media Failure Percentage" -gt 0.001 } | Measure-Object "Other Media Failure Percentage" -Average | select Average).Average
        $OtherMediaFailurePercentage=($MediaFailedDueToOtherStreamCount/$toalStreamsCnt)*100
        if(-not $OtherMediaFailurePercentage){  $OtherMediaFailurePercentage=0 }  else { $OtherMediaFailurePercentage=$OtherMediaFailurePercentage.ToString("#.##") }
    }
    Write-Host 'measures##' $toalStreamsCnt ~$TotalCDRAvailableStreamCount ~ $TotalMediaFailedStreamCount ~ $TotalCallSetupFailedStreamCount ~ $TotalCallDroppedStreamCount ~ $TotalMediaSucceededStreamCount ~ $TotalCallSetupSucceededStreamCount ~ $TotalCallSetupFailurePercentage ~ $TotalCallDroppedFailurePercentage ~ $TotalAnswerSeizureRatio ~ $TotalShortCallPercentage ~ $TotalMediaFailurePercentage ~ $AvgCallDuration ~ $MediaFailedDueToFirewallDPIStreamCount ~ $FirewallDPIMediaFailurePercentage ~ $MediaFailedDueToFirewallIPBlockedStreamCount ~ $FirewallIPBlockedMediaFailurePercentage ~ $MediaFailedDueToOtherStreamCount ~ $OtherMediaFailurePercentage
}










# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUgGpMvI/9OMm/Lim0NTZQpr18
# V/qggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUrpjZddhJunjgpmSIiZdlkx9P
# UdQwDQYJKoZIhvcNAQEBBQAEggEAij28/hD63Pd3leWAIZW0VRxqDL8SPBo0Y3X3
# lM/7j5FeGVjeh4+evFNy0PpWw5/8oDrh1tCQTI0osj6Pk8KlqfXN6TBYBzRO1Rhv
# 55wefFe+zthk4IOFZorLfmFx3rHY6xHBMUu/r/N7bUASQnQtfwCfzXMTZbOXg70g
# 7sObmeun4YjHzyNa1tRkMe5ddL6hlSLZyRcgzzzQoG34YIUSqDOvZKQwjRh6NoGS
# Y88wGeIMhmSglRAle+32MM7Td4JN3OkRH7mlZsBt6NfgFxbuNwqqtGCwogrZAlwI
# 3IE2wahtVGFrGnH3mPZAfF8yw/quTuhIZvaTK6CLoovBX4ujaaGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAxMjIxMTEyMjQzWjAjBgkqhkiG9w0BCQQxFgQUWcHTKzqdJ7yKxaYu24gt
# K3yzkb4wDQYJKoZIhvcNAQEBBQAEggEAotkn5XCTbZWWjb6/U9aNQ0dRxMfKuQya
# n5NTK7NkgVt6EAYFDZJE5473sQL9idhIZNbjUt9mqMk6124pgc0n7i/m8khWMJo3
# xEKu4pb3fYUDTtPhFbn647EOP6ulzA6EhrgfyaxM4ZT92hYKN3HzF6CYaoLI/fl1
# NEuG+Mnd8Drn9crvb7HxSBXonGlLXtXhplcvKtiCYvhHFwfErH3dZ0MKCRVoBTcH
# 9jTQtqn3Y5bMJmEHfTaigaBi4UjrjPF3ePpWoH19egH40lqJMI495bJ3dA/ILm1E
# mddYcZOHDVajSo2nEWv4qT8iUx65H1gx1eJ9rc4mNgMfkP4VAm1Qew==
# SIG # End signature block
