﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear

$TestInputs=$args
$reportingname='EXO/'+$TestInputs[0]
$userName=$TestInputs[1]
$Password=Eg-O365Dcr -EncStr $TestInputs[2]
$proxyids=$TestInputs[3]
$days=$TestInputs[4]
$rptTopNDD=[int]$TestInputs[5]
$prxyusrpwd=$proxyids.split("#")
$alldays=$days.split("#")
$proxyUsr=$prxyusrpwd[0]
$proxyPass=Eg-O365Dcr -EncStr $prxyusrpwd[1]
$activeDays=$alldays[0]
$InactiveDays=$alldays[1]
$PassExpDays=$alldays[2]
$ExcludingNames=$alldays[3]
$proxyserverip=($alldays[4]).ToString().trim()

$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }

$cred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
if(!$proxyserverip.Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

Connect-MsolService  -Credential $cred -AzureEnvironment $azureEnvArr[0]

$readfiles=0
$readfiles1=0
$readfiles2=0
$readfiles3=0
$dmnPwdExp=@{}

try{  
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "mailbox" -keyFileName "kmailbox" -EgPath $egurkhaPath
    $datafile=$readfiles[1] -replace (".csv",".dat") 
    $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
    $measureterms= import-csv $csvfile
    Remove-Item $csvfile
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'mailbox' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kmailbox' -InputFile $readfiles[4]
}
catch [System.Management.Automation.RuntimeException] {
    Write-Error -Message "File not found. The $reportingname location does not contain mailbox files."
}
catch{
    $errmsg=$_.Exception.Message
    $errstack=$_.Exception.StackTrace
    Write-Error -Message $errmsg
}

try{
    $readfiles1=Eg-ReadFile -ComntRptPath $reportingname -FileName "casmailboxes" -keyFileName "kcasmailboxes" -EgPath $egurkhaPath
    $datafile1=$readfiles1[1] -replace (".csv",".dat") 
    $csvfile1=Unprotect-File $datafile1 -Algorithm AES -KeyAsPlainText $readfiles1[0]	
    $DDD= import-csv $csvfile1
    Remove-Item $csvfile1
    Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'casmailboxes' -InputFile $readfiles1[3]
    Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'kcasmailboxes' -InputFile $readfiles1[4]
}
catch [System.Management.Automation.RuntimeException] {
    Write-Error -Message "File not found. The $reportingname location does not contain casmailboxes files."
}
catch{
    $errmsg=$_.Exception.Message
    $errstack=$_.Exception.StackTrace
    Write-Error -Message $errmsg
}

try{
    $readfiles2=Eg-ReadFile -ComntRptPath $reportingname -FileName "statsmailbox" -keyFileName "kstatsmailbox" -EgPath $egurkhaPath
    $datafile2=$readfiles2[1] -replace (".csv",".dat") 
    $csvfile2=Unprotect-File $datafile2 -Algorithm AES -KeyAsPlainText $readfiles2[0]	
    $mailboxstatistics= import-csv $csvfile2
    Remove-Item $csvfile2
    Eg-DeleteFiles -FilePath $readfiles2[2] -Pattern 'statsMailbox' -InputFile $readfiles2[3]
    Eg-DeleteFiles -FilePath $readfiles2[2] -Pattern 'kstatsMailbox' -InputFile $readfiles2[4]
	$mailStats=$mailboxstatistics | select -First 1
	#$isPreviousScript=[bool]($mailStats.PSobject.Properties.name -match "PrimarySmtpAddress")
}
catch [System.Management.Automation.RuntimeException] {
    Write-Error -Message "File not found. The $reportingname location does not contain statsmailbox files."
}
catch{
    $errmsg=$_.Exception.Message
    $errstack=$_.Exception.StackTrace
    Write-Error -Message $errmsg
}

try{
    $readfiles3=Eg-ReadFile -ComntRptPath $reportingname -FileName "RecipntPerm" -keyFileName "kRecipntPerm" -EgPath $egurkhaPath
    $datafile3=$readfiles3[1] -replace (".csv",".dat") 
    $csvfile3=Unprotect-File $datafile3 -Algorithm AES -KeyAsPlainText $readfiles3[0]	
    $ReciPrmterm= import-csv $csvfile3
    Remove-Item $csvfile3
    Eg-DeleteFiles -FilePath $readfiles3[2] -Pattern 'RecipntPerm' -InputFile $readfiles3[3]
    Eg-DeleteFiles -FilePath $readfiles3[2] -Pattern 'kRecipntPerm' -InputFile $readfiles3[4]
}
catch [System.Management.Automation.RuntimeException] {
    Write-Error -Message "File not found. The $reportingname location does not contain RecipntPerm files."
}
catch{
    $errmsg=$_.Exception.Message
    $errstack=$_.Exception.StackTrace
    Write-Error -Message $errmsg
}
 
Try{
    $dmUsrWArr = Eg-WriteFile -ComntRptPath $reportingname -FileName "O365msolDomUsr" -keyFileName "kO365msolDomUsr" -EgPath $egurkhaPath
    Get-MSOLDomain | select * |Export-Csv $dmUsrWArr[1]
    $null=Protect-File  $dmUsrWArr[1] -Algorithm AES -KeyAsPlainText $dmUsrWArr[0] -RemoveSource
}Catch{}

$dmUsrRArr=Eg-ReadFile -ComntRptPath $reportingname -FileName "O365msolDomUsr" -keyFileName "kO365msolDomUsr" -EgPath $egurkhaPath
$uPMDomUsr=$dmUsrRArr[1] -replace (".csv",".dat") 
$mdomusrPath=Unprotect-File $uPMDomUsr -Algorithm AES -KeyAsPlainText $dmUsrRArr[0]	
$domain= import-csv $mdomusrPath
Remove-Item $mdomusrPath

Eg-DeleteFiles -FilePath $dmUsrRArr[2] -Pattern 'O365msolDomUsr' -InputFile $dmUsrRArr[3]
Eg-DeleteFiles -FilePath $dmUsrRArr[2] -Pattern 'kO365msolDomUsr' -InputFile $dmUsrRArr[4]

Try{
	$passPlcyWArr = Eg-WriteFile -ComntRptPath $reportingname -FileName "O365msolpass" -keyFileName "kO365msolpass" -EgPath $egurkhaPath   
	foreach($dmn in $domain){
	    $valid=((Get-MsolPasswordPolicy -domain $dmn.Name -ErrorAction SilentlyContinue))| Select-Object -Property @{Name='Domain';Expression={$dmn.Name}},ValidityPeriod
	    if($valid -ne $null -and $valid -ne ''){
		    $valid|Export-Csv -Append -LiteralPath $passPlcyWArr[1] #-Force
	    }
	}
	$null=Protect-File  $passPlcyWArr[1] -Algorithm AES -KeyAsPlainText $passPlcyWArr[0] -RemoveSource
    $passPlcyRArr=Eg-ReadFile -ComntRptPath $reportingname -FileName "O365msolpass" -keyFileName "kO365msolpass" -EgPath $egurkhaPath
    $mpassPlcyUsr=$passPlcyRArr[1] -replace (".csv",".dat") 
    $passPlcyPath=Unprotect-File $mpassPlcyUsr -Algorithm AES -KeyAsPlainText $passPlcyRArr[0]	
    $msolPassword= import-csv $passPlcyPath 
    for($j=0; $j -lt $msolPassword.Length; $j++){
        $Domain=$msolPassword[$j].Domain.toString()
        [int]$ValidityPeriod=$msolPassword[$j].ValidityPeriod
        $dmnPwdExp.Add($Domain,$ValidityPeriod)
    }
    Remove-Item $passPlcyPath
    Eg-DeleteFiles -FilePath $passPlcyRArr[2] -Pattern 'O365msolpass' -InputFile $passPlcyRArr[3]
    Eg-DeleteFiles -FilePath $passPlcyRArr[2] -Pattern 'kO365msolpass' -InputFile $passPlcyRArr[4]
    }
    Catch{
	    $egurkhaRprtPath=  $egurkhaPath+'\agent\'+$rptPath+'\'
        $fileRead=Get-ChildItem -Path $egurkhaRprtPath |Where-Object {$_.Name -like 'kO365msolpass*.dat'}| Sort-Object LastWriteTime -Descending | Select Name -First 1
        foreach($file in $fileRead){
                $fileName=([String]$file.Name).Trim()
                Remove-Item $egurkhaRprtPath$fileName -Force
        }
    }
    Try{
        $writArr = Eg-WriteFile -ComntRptPath $reportingname -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
        Get-MsolUser -All| select * |Export-Csv $writArr[1]
        $null=Protect-File  $writArr[1] -Algorithm AES -KeyAsPlainText $writArr[0] -RemoveSource
    }Catch{}

    $readArr=Eg-ReadFile -ComntRptPath $reportingname -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
    $unProtctMUsr=$readArr[1] -replace (".csv",".dat") 
    $musrPath=Unprotect-File $unProtctMUsr -Algorithm AES -KeyAsPlainText $readArr[0]	
    $usersview= import-csv $musrPath
    Remove-Item $musrPath
    Eg-DeleteFiles -FilePath $readArr[2] -Pattern 'O365msolUsr' -InputFile $readArr[3]
    Eg-DeleteFiles -FilePath $readArr[2] -Pattern 'kO365msolUsr' -InputFile $readArr[4]

    Write-Host 'ReadFile:'$readfiles[3]','$readfiles1[3] ','$readfiles2[3] ','$readfiles3[3] ','$readArr[3] ','$dmUsrRArr[3]
	$sysDat=Get-Date
	$MsolRole = Get-MsolRole
	foreach($roles in $MsolRole){
	    $rolemember=Get-MsolRoleMember -RoleObjectId $roles.ObjectId |Where{$_.RoleMemberType -eq 'User'}|select DisplayName
        if($rolemember -ne $null){
		foreach($rolemembers in $rolemember ){   
                Write-Host 'DDAdminUsers' $rolemembers.DisplayName '!' $roles.Name 
		    }
	    }
	} 
    
    $actSync=0
	$actNonSync=0
	$ExcludingNames=$ExcludingNames.Replace("_"," ")
	$ExcludingName=$ExcludingNames.split('|')
	$DDD=$DDD |where {$ExcludingName -notcontains $_.DisplayName} | Sort-Object DisplayName 
    
    $culture = Get-Culture
    $culture.DateTimeFormat.ShortDatePattern = 'yyyy-MM-dd'
    Set-Culture $culture
    $CultureDateTimeFormat = (Get-Culture).DateTimeFormat
    $DateFormat = $CultureDateTimeFormat.ShortDatePattern
    $DateTimeFormat = "$DateFormat"
    <#
    if($isPreviousScript){
	    foreach($Measures in $DDD){
            try{
                if($Measures.ActiveSyncEnabled -ne $true){
                    $LastLogonTime=$mailboxstatistics |  Where-Object {$_.PrimarySmtpAddress -eq $Measures.PrimarySmtpAddress} | select LastLogonTime
                    $usrLogonDat = [DateTime]::ParseExact($LastLogonTime.LastLogonTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
	                Write-Host DDSyncUsers $Measures.PrimarySmtpAddress '~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
                    $actNonSync++
                }
                else{
                    $actSync++
                }
            }catch{
                if($Measures.ActiveSyncEnabled -ne $true){
                    $LastLogonTime=$mailboxstatistics |  Where-Object {$_.PrimarySmtpAddress -eq $Measures.PrimarySmtpAddress} | select LastLogonTime
                    $usrLogonDat = [DateTime]::ParseExact($LastLogonTime.LastLogonTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)	            
	                Write-Host DDSyncUsers $Measures.PrimarySmtpAddress '~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
                    $actNonSync++
                }
                else{
                    $actSync++
                }
            }
        }
        $lastsyncUsers=$mailboxstatistics | Sort-Object { $_.LastLogonTime -as [DateTime] } -Descending | select -First 10
        foreach($topActiveUsers in  $lastsyncUsers  ){
            $usrLogonDat = [DateTime]::ParseExact($topActiveUsers.LastLogonTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
            Write-Host DDActiveSyncUsers $topActiveUsers.PrimarySmtpAddress ~!~ $usrLogonDat
        }
    }
    #>
    #else{
	    foreach($Measures in $DDD){
            try{
                if($Measures.ActiveSyncEnabled -ne $true){
                    $LastLogonTime=$mailboxstatistics |  Where-Object {$_.UserPrincipalName -eq $Measures.PrimarySmtpAddress} | select LastActivityDate
                    $usrLogonDat = [DateTime]::ParseExact($LastLogonTime.LastActivityDate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
	                Write-Host DDSyncUsers $Measures.PrimarySmtpAddress '~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
                    $actNonSync++
                }
                else{
                    $actSync++
                }
            }catch{
                if($Measures.ActiveSyncEnabled -ne $true){
                    $LastLogonTime=$mailboxstatistics |  Where-Object {$_.UserPrincipalName -eq $Measures.PrimarySmtpAddress} | select LastActivityDate
                    $usrLogonDat = [DateTime]::ParseExact($LastLogonTime.LastActivityDate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)	            
	                Write-Host DDSyncUsers $Measures.PrimarySmtpAddress '~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
                    $actNonSync++
                }
                else{
                    $actSync++
                }
            }
        }
        $lastsyncUsers=$mailboxstatistics | Sort-Object { $_.LastActivityDate -as [DateTime] } -Descending | select -First $rptTopNDD
        foreach($topActiveUsers in  $lastsyncUsers  ){
            $usrLogonDat = [DateTime]::ParseExact($topActiveUsers.LastActivityDate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
            Write-Host DDActiveSyncUsers $topActiveUsers.UserPrincipalName ~!~ $usrLogonDat
        }  
    #}
	Write-Host  SyncUsers$actSync'#'$actNonSync
    $ReciPrmterm=$ReciPrmterm | Sort-Object Identity
    foreach($mm in $ReciPrmterm){
	    if($mm -ne $null){
	    write-host SendAs $mm.Identity'~!~'$mm.Trustee'~!~'$mm.AccessControlType'~!~'$mm.IsInherited'~!~'$mm.InheritanceType'~!~'$mm.IsValid
	    }
	}

	$SendOnBehalf=$measureterms |  Where-Object {$_.GrantSendOnBehalfTo -ne ''} | select DisplayName,Alias,UserPrincipalName,PrimarySmtpAddress,GrantSendOnBehalfTo,Identity | Sort-Object Identity
	foreach($mailbox in $SendOnBehalf){	
		Write-Host SendOnBehalf  $mailbox.DisplayName'~!~'$mailbox.UserPrincipalName'~!~'$mailbox.PrimarySmtpAddress'~!~'$mailbox.GrantSendOnBehalfTo'~!~-~!~-'
	}

	$Activecount=0 
	$InActivecount=0
	$neverlogcount=0
    <#
	if($isPreviousScript){
	    Foreach ($mailboxstat in $mailboxstatistics) {           
	        if($mailboxstat.LastLogonTime -eq $null -or $mailboxstat.LastLogonTime -eq "" ){
		        if($mailboxstat.DisplayName -ne "Discovery Search Mailbox"){
		            Write-Host "NeverLoggedIn~"$mailboxstat.PrimarySmtpAddress'~!~-~!~-~!~-~!~-~!~-'
		            $neverlogcount++
		        }
	        }
	        else{
	            #[datetime]$usrLogonDat=$mailboxstat.LastLogonTime
                $usrLogonDat = [DateTime]::ParseExact($mailboxstat.LastLogonTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
		        if($usrLogonDat -gt  $sysDat.AddDays(-$activeDays)){
				    #Write-Host "Active users~"$mailboxstat.PrimarySmtpAddress'~!~'$usrLogonDat '~!~-~!~-~!~-~!~-'
		            $Activecount++
			    }
			    elseif($usrLogonDat -lt $sysDat.AddDays(-$InactiveDays)){
				    Write-Host "Inactive users~"$mailboxstat.PrimarySmtpAddress'~!~'$usrLogonDat'~!~-~!~-~!~-~!~-'
		            $InActivecount++
			    }
	        }
	    }
    }
    #>
    #else{
        Foreach ($mailboxstat in $mailboxstatistics){           
	        if($mailboxstat.LastActivityDate -eq $null -or $mailboxstat.LastActivityDate -eq "" ){
		        if($mailboxstat.DisplayName -ne "Discovery Search Mailbox"){  
		            Write-Host "NeverLoggedIn~"$mailboxstat.UserPrincipalName'~!~-~!~-~!~-~!~-~!~-'
		            $neverlogcount++
		        }
	        }
	        else{
                $usrLogonDat = [DateTime]::ParseExact($mailboxstat.LastActivityDate,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
		        if ($usrLogonDat -gt  $sysDat.AddDays(-$activeDays)){
		            $Activecount++
			    }
			    elseif($usrLogonDat -lt $sysDat.AddDays(-$InactiveDays)){
				    Write-Host "Inactive users~"$mailboxstat.UserPrincipalName'~!~'$usrLogonDat'~!~-~!~-~!~-~!~-'
		            $InActivecount++
			    }
	        }
	    }
    #}
    $cultureDTFrmt1 = Get-Culture
    $cultureDTFrmt1.DateTimeFormat.ShortDatePattern = 'M/d/yyyy'
    $cultureDTFrmt1.DateTimeFormat.LongTimePattern='h:mm:ss tt'
    Set-Culture $cultureDTFrmt1
    $CultureDateTimeFormat1 = (Get-Culture).DateTimeFormat
    $DateFormat1 = $CultureDateTimeFormat1.ShortDatePattern
    $TimeFormat1 = $CultureDateTimeFormat1.LongTimePattern
    $DateTimeFormat1 = "$DateFormat1 $TimeFormat1"
	$users = $usersview |  where { $_.PasswordNeverExpires -eq $false } 
	$chkEnd=[datetime](Get-Date).AddDays(+$PassExpDays).ToUniversalTime()
	$chkStart=[datetime](Get-Date).ToUniversalTime()
	foreach($user in $users){
        $usrname = $user.UserPrincipalName
        $signname = $user.SignInName
        #[datetime]$passwordSetDate = $user.LastPasswordChangeTimestamp 
        $passwordSetDate = [DateTime]::ParseExact($user.LastPasswordChangeTimestamp,$DateTimeFormat1,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
        $domainName= $usrname.substring($usrname.IndexOf('@')+1)
        [int]$maxPasswordAge=$dmnPwdExp[$domainName]
        try{
	        $expireson = $passwordSetDate.addDays($maxPasswordAge)
            if(($chkStart -le $expireson) -and ($chkEnd -ge $expireson)){
                $userlicAcc =  $user.Licenses.AccountSKUID
                if($userlicAcc -eq $null){
                    $userlicAcc = "-"
                }
                $userislic = $user.IsLicensed
                $usageloc = $user.UsageLocation
                if($usageloc -eq $null){
                    $usageloc = "-"
                }
                Write-Host 'userpassexpire~'$usrname'~!~'$signname'~!~'$expireson'~!~'$userlicAcc'~!~'$userislic'~!~'$usageloc
            }
        }
        catch{}
    }
Write-Host 'UsersCount~'$Activecount'~'$InActivecount'~'$neverlogcount
# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUbUgzXU6qjenToDvnRN8bdPoa
# 78eggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUuQjgdB0BqSduWtA1hOsCeFwo
# QIowDQYJKoZIhvcNAQEBBQAEggEAn55dLOG89FswXC3uyj10OGSItOUVTlwpUXQ7
# DePDmfLQK6CQmirEhZXD5zyLwhJZV0haOPxhXLkiSm/I1xwfo1tAS737tqKCvdyq
# wXeU6CXbNS9h/H6+jpt3Mtum3OORtP5fGrAk32OxNCT1Lc5Nkb2x3nxg8H8pjUDZ
# 61tuc9z/MBzLSDX/MYwkJRY+dHOFIZyru8dIig65mA+8JySFL7RZQdNkmvNLD+AZ
# aTUlR0lfLG2/j3uXiF/9dU6Muwhy1qSXY/yB4fPVtFLKckwHpsMrXrgb2F7k8HgI
# KO/QsqDgQej5kJR+bmQWvW1DwQ/0wlRp9DMO2b6QX7WKc2RhxqGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAxMDIyMTA1OTA5WjAjBgkqhkiG9w0BCQQxFgQUP9VfRRWRDo7AVwCLMt13
# 3hdgK60wDQYJKoZIhvcNAQEBBQAEggEACl09B2VwxB7L7K3zh7mDCcLlefd5crht
# XeGNt6M0MqN+kHdNzi7LmLgQEHINT8b8Q/8aIiwv9oP5YBEgH+u0+vRyi5O2QQU7
# wQ4JdKJzStrNM3my2Kryits6ihpQwW2+Nwv2pxpqPVP/H+lpCVUZCxYtqLBs3lSb
# 59lZLjqaUiC+2EvXKocZ1IMLrYMx0ZHDu38utV5E4C88tyV0SbrMjmSeHVFXoV+Y
# mvjd0o2rMNi9p2CMlQbH6wBvmXANHscfrd88GVeOraefus5sqeVEjzkFhxgg9Hhv
# 9ajVK0kiuXrN5ylIWtRfrIKWomo+urhykpeqd6U4eAdEcUsMnQJJsg==
# SIG # End signature block
